/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.restriction.RestrictionInfoFactory;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastBinaryOperator;

class UastPropertiesReferenceProvider
extends UastInjectionHostReferenceProvider {
    private final boolean myDefaultSoft;

    UastPropertiesReferenceProvider(boolean defaultSoft) {
        this.myDefaultSoft = defaultSoft;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        return PropertyReferenceBase.isPropertyPsi((PsiElement)target);
    }

    public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression element, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        String bundleName;
        boolean soft;
        UExpression parent = StringFlowUtil.goUp((UExpression)element, (boolean)false, (RestrictionInfoFactory)NlsInfo.factory());
        if (!UastPropertiesReferenceProvider.canBePropertyKeyRef(parent)) {
            return PsiReference.EMPTY_ARRAY;
        }
        Object value = element.evaluate();
        if (!(value instanceof String)) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = (String)value;
        if (text.indexOf(10) != -1) {
            return PsiReference.EMPTY_ARRAY;
        }
        Ref resourceBundleValue = Ref.create();
        if (JavaI18nUtil.mustBePropertyKey(element, (Ref<? super UExpression>)resourceBundleValue)) {
            Object bundleValue;
            soft = false;
            UExpression resourceBundleName = (UExpression)resourceBundleValue.get();
            bundleName = resourceBundleName != null ? ((bundleValue = resourceBundleName.evaluate()) == null ? null : bundleValue.toString()) : null;
        } else {
            soft = this.myDefaultSoft;
            bundleName = null;
        }
        PropertyReference reference = new PropertyReference(text, (PsiElement)host, bundleName, soft);
        return new PsiReference[]{reference};
    }

    private static boolean canBePropertyKeyRef(@NotNull UExpression element) {
        UElement parent = element.getUastParent();
        return !(parent instanceof UPolyadicExpression) || ((UPolyadicExpression)parent).getOperator() == UastBinaryOperator.ASSIGN;
    }
}

