/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFoldingSettings;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleContextFoldingBuilder
extends FoldingBuilderEx {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (!PropertiesFoldingSettings.getInstance().isFoldPlaceholdersToContext()) {
            return FoldingDescriptor.EMPTY;
        }
        ArrayList result = new ArrayList();
        for (IProperty property : ((PropertiesFile)root).getProperties()) {
            String value = property.getValue();
            if (value == null || !value.contains("{0}")) continue;
            ResourceBundleContextFoldingBuilder.fold(property, result);
        }
        return result.toArray(FoldingDescriptor.EMPTY);
    }

    private static void fold(@NotNull IProperty property, @NotNull List<? super FoldingDescriptor> result) {
        ReferencesSearch.search((PsiElement)property.getPsiElement()).forEach(reference -> !ResourceBundleContextFoldingBuilder.tryToFoldReference(reference, property, result));
    }

    private static boolean tryToFoldReference(@NotNull PsiReference reference, @NotNull IProperty property, @NotNull List<? super FoldingDescriptor> result) {
        PsiElement[] arguments;
        int before = result.size();
        PsiElement referenceElement = reference.getElement();
        String key = property.getUnescapedKey();
        if (key == null) {
            return false;
        }
        PsiElement psiElement = property.getPsiElement();
        String text = psiElement.getText();
        PsiElement[] psiElementArray = arguments = referenceElement.getLanguage().getID().equals("kotlin") ? ResourceBundleContextFoldingBuilder.getKotlinArguments(referenceElement) : ResourceBundleContextFoldingBuilder.getJavaArguments(referenceElement);
        if (arguments == null) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            PsiElement argument = arguments[i];
            String templateText = "{" + i + "}";
            int offset = text.indexOf(templateText, key.length());
            if (offset == -1) continue;
            int start = psiElement.getTextRange().getStartOffset();
            result.add((FoldingDescriptor)new FoldingDescriptor(psiElement, start + offset, start + offset + templateText.length(), null, argument.getText()));
        }
        return result.size() != before;
    }

    private static PsiElement[] getJavaArguments(@NotNull PsiElement referenceElement) {
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiExpression.class, (boolean)false);
        if (expression == null) {
            return null;
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return null;
        }
        Object[] arguments = ((PsiExpressionList)parent).getExpressions();
        int i = ArrayUtil.indexOf((Object[])arguments, (Object)expression);
        if (i == -1) {
            return null;
        }
        return (PsiElement[])Arrays.copyOfRange(arguments, i + 1, arguments.length, PsiElement[].class);
    }

    private static PsiElement[] getKotlinArguments(@NotNull PsiElement referenceElement) {
        PsiElement expression = referenceElement.getParent();
        if (expression == null) {
            return null;
        }
        ArrayList<PsiElement> arguments = new ArrayList<PsiElement>();
        for (PsiElement e = expression.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiComment || e instanceof LeafPsiElement) continue;
            arguments.add(e);
        }
        if (arguments.isEmpty()) {
            return null;
        }
        return arguments.toArray(PsiElement.EMPTY_ARRAY);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return true;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        return null;
    }
}

