/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.i18n.folding.EditPropertyValueAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.FoldingPopupManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditPropertyValueTooltipManager
implements EditorMouseListener,
CaretListener {
    private static final Key<Boolean> INITIALIZED = Key.create((String)"PropertyEditTooltipManager");
    private static final long TOOLTIP_DELAY_MS = 500L;
    private final Alarm myAlarm = new Alarm();

    public static void initializeForDocument(@NotNull Document document) {
        EditorFactory.getInstance().editors(document).forEach(EditPropertyValueTooltipManager::initializeForEditor);
    }

    private static void initializeForEditor(@NotNull Editor editor) {
        if (editor.getUserData(INITIALIZED) != null) {
            return;
        }
        editor.putUserData(INITIALIZED, (Object)Boolean.TRUE);
        new EditPropertyValueTooltipManager(editor);
    }

    private EditPropertyValueTooltipManager(@NotNull Editor editor) {
        editor.getCaretModel().addCaretListener((CaretListener)this);
        editor.addEditorMouseListener((EditorMouseListener)this);
    }

    public void mouseReleased(@NotNull EditorMouseEvent event) {
        Editor editor = event.getEditor();
        if (event.getArea() == EditorMouseEventArea.EDITING_AREA && EditPropertyValueTooltipManager.shouldShowTooltip(editor)) {
            event.consume();
            this.myAlarm.cancelAllRequests();
            EditPropertyValueTooltipManager.showTooltip(editor);
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent event) {
        this.myAlarm.cancelAllRequests();
        Editor editor = event.getEditor();
        if (EditPropertyValueTooltipManager.shouldShowTooltip(editor)) {
            this.myAlarm.addRequest(() -> EditPropertyValueTooltipManager.showTooltip(editor), 500L);
        }
    }

    private static boolean shouldShowTooltip(@NotNull Editor editor) {
        return EditPropertyValueAction.isEnabled(editor);
    }

    private static void showTooltip(final @NotNull Editor editor) {
        String hintText = StringUtil.join(Arrays.asList(EditPropertyValueTooltipManager.createActionText("ExpandRegion", "expand"), EditPropertyValueTooltipManager.createActionText("EditPropertyValue", "edit")), (String)"&nbsp;&nbsp;&nbsp;&nbsp;");
        if (hintText.isEmpty()) {
            return;
        }
        JComponent component = HintUtil.createInformationLabel((String)("<html>" + hintText), (HyperlinkListener)new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AnAction action;
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String actionId = null;
                switch (e.getDescription()) {
                    case "expand": {
                        actionId = "ExpandRegion";
                        break;
                    }
                    case "edit": {
                        actionId = "EditPropertyValue";
                    }
                }
                if (actionId != null && (action = ActionManager.getInstance().getAction(actionId)) != null) {
                    ActionUtil.invokeAction((AnAction)action, (Component)editor.getContentComponent(), (String)"unknown", (InputEvent)e.getInputEvent(), null);
                }
            }
        }, null, null);
        EditPropertyValueTooltipManager.showTooltip(editor, component, false);
    }

    @Nullable
    private static String createActionText(@NotNull String actionId, @NotNull String href) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action == null) {
            return null;
        }
        String text = action.getTemplateText();
        if (text == null) {
            return null;
        }
        HtmlChunk.Element shortcut = HtmlChunk.span((String)("color:" + ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground()))).addText(KeymapUtil.getFirstKeyboardShortcutText((AnAction)action));
        return new HtmlBuilder().appendLink(href, text).append(" ").append((HtmlChunk)shortcut).toString();
    }

    public static LightweightHint showTooltip(@NotNull Editor editor, @NotNull JComponent component, boolean tenacious) {
        if (editor.isDisposed()) {
            return null;
        }
        FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(editor.getCaretModel().getOffset());
        if (foldRegion == null) {
            return null;
        }
        JComponent editorComponent = editor.getContentComponent();
        JRootPane rootPane = editorComponent.getRootPane();
        if (rootPane == null) {
            return null;
        }
        Point start = editor.offsetToXY(foldRegion.getStartOffset(), true, false);
        Point end = editor.offsetToXY(foldRegion.getEndOffset(), false, true);
        Point relativePoint = new Point((start.x + end.x) / 2, start.y);
        Point point = SwingUtilities.convertPoint(editorComponent, relativePoint, rootPane.getLayeredPane());
        LightweightHint hint = new LightweightHint(component);
        HintHint hintHint = HintManagerImpl.createHintHint((Editor)editor, (Point)point, (LightweightHint)hint, (short)1).setShowImmediately(true);
        int flags = 40;
        if (tenacious) {
            hintHint.setExplicitClose(true);
        } else {
            flags |= 2;
        }
        FoldingPopupManager.disableForEditor((Editor)editor);
        hint.addHintListener(e -> FoldingPopupManager.enableForEditor((Editor)editor));
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, flags, 0, false, hintHint);
        return hint;
    }
}

