/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.RestrictionInfo;
import com.intellij.codeInspection.restriction.RestrictionInfoFactory;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public abstract class NlsInfo
implements RestrictionInfo {
    static final String NLS_SAFE = "com.intellij.openapi.util.NlsSafe";
    @NotNull
    private static final String NLS_CONTEXT = "com.intellij.openapi.util.NlsContext";
    @NotNull
    private static final Set<String> ANNOTATION_NAMES = Set.of("org.jetbrains.annotations.Nls", "org.jetbrains.annotations.NonNls", "com.intellij.openapi.util.NlsSafe", "org.jetbrains.annotations.PropertyKey");
    @NotNull
    private final ThreeState myNls;

    private NlsInfo(@NotNull ThreeState nls) {
        this.myNls = nls;
    }

    public static NlsInfoFactory factory() {
        return NlsInfoFactory.INSTANCE;
    }

    @NotNull
    public ThreeState getNlsStatus() {
        return this.myNls;
    }

    public boolean canBeUsedInLocalizedContext() {
        return this instanceof Localized || this instanceof NlsSafe;
    }

    @NotNull
    public static Localized localized() {
        return Localized.NLS;
    }

    @NotNull
    public static NonLocalized nonLocalized() {
        return NonLocalized.INSTANCE;
    }

    @NotNull
    public static NlsInfo forExpression(@NotNull UExpression expression) {
        return NlsInfo.forExpression(expression, true);
    }

    @NotNull
    static NlsInfo forExpression(@NotNull UExpression expression, boolean allowStringModifications) {
        NlsInfo target = NlsInfo.fromEqualityCheck(expression = StringFlowUtil.goUp((UExpression)expression, (boolean)allowStringModifications, (RestrictionInfoFactory)NlsInfoFactory.INSTANCE), allowStringModifications);
        if (target != NlsUnspecified.UNKNOWN) {
            return target;
        }
        AnnotationContext context = AnnotationContext.fromExpression((UExpression)expression);
        return NlsInfo.fromAnnotationContext(expression.getUastParent(), context);
    }

    @NotNull
    private static NlsInfo fromEqualityCheck(@NotNull UExpression expression, boolean allowStringModifications) {
        UastBinaryOperator operator;
        UQualifiedReferenceExpression qualifiedCall;
        String name;
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (parent instanceof UCallExpression && (name = ((UCallExpression)parent).getMethodName()) != null && (name.equals("equals") || allowStringModifications && name.equals("startsWith") || name.equals("endsWith") || name.equals("equalsIgnoreCase") || name.equals("contains")) && (qualifiedCall = (UQualifiedReferenceExpression)ObjectUtils.tryCast((Object)parent.getUastParent(), UQualifiedReferenceExpression.class)) != null && parent.equals(qualifiedCall.getSelector())) {
            return NlsInfo.fromVariableReference(qualifiedCall.getReceiver());
        }
        if (parent instanceof UBinaryExpression && ((operator = ((UBinaryExpression)parent).getOperator()) == UastBinaryOperator.EQUALS || operator == UastBinaryOperator.NOT_EQUALS)) {
            UExpression left = ((UBinaryExpression)parent).getLeftOperand();
            UExpression right = ((UBinaryExpression)parent).getRightOperand();
            if (AnnotationContext.expressionsAreEquivalent((UExpression)left, (UExpression)expression)) {
                return NlsInfo.fromVariableReference(right);
            }
            if (AnnotationContext.expressionsAreEquivalent((UExpression)right, (UExpression)expression)) {
                return NlsInfo.fromVariableReference(left);
            }
        }
        return NlsUnspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromVariableReference(UExpression receiver) {
        PsiElement target;
        if (receiver instanceof UReferenceExpression && TypeUtils.isJavaLangString((PsiType)receiver.getExpressionType()) && (target = ((UReferenceExpression)receiver).resolve()) instanceof PsiVariable) {
            return NlsInfo.factory().fromModifierListOwner((PsiModifierListOwner)((PsiVariable)target));
        }
        return NlsUnspecified.UNKNOWN;
    }

    @NotNull
    public static NlsInfo forType(@NotNull PsiType type) {
        return NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)type);
    }

    @NotNull
    public static NlsInfo forModifierListOwner(@NotNull PsiModifierListOwner owner) {
        return NlsInfo.fromAnnotationContext(null, AnnotationContext.fromModifierListOwner((PsiModifierListOwner)owner));
    }

    @NotNull
    public static Nls.Capitalization getCapitalization(@NotNull PsiModifierListOwner owner) {
        NlsInfo info = NlsInfo.forModifierListOwner(owner);
        if (info instanceof Localized) {
            return ((Localized)info).getCapitalization();
        }
        return Nls.Capitalization.NotSpecified;
    }

    @NotNull
    private static NlsInfo fromAnnotationContext(UElement parent, AnnotationContext context) {
        PsiMember member;
        ULocalVariable uLocal;
        NlsInfo info = NlsInfo.fromType(context.getType());
        if (info != NlsUnspecified.UNKNOWN) {
            return info;
        }
        PsiModifierListOwner owner = context.getOwner();
        if (owner == null) {
            return NlsUnspecified.UNKNOWN;
        }
        info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)owner.getModifierList());
        if (info != NlsUnspecified.UNKNOWN) {
            return info;
        }
        if (owner instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)owner;
            if (parameter.isVarArgs() && context.getType() instanceof PsiEllipsisType) {
                info = NlsInfo.fromType(((PsiEllipsisType)context.getType()).getComponentType());
            }
        } else if (owner instanceof PsiVariable && (uLocal = (ULocalVariable)UastContextKt.toUElement((PsiElement)owner, ULocalVariable.class)) != null) {
            info = NlsInfo.fromUVariable((UVariable)uLocal);
        }
        if (info.getKind() != RestrictionInfo.RestrictionInfoKind.KNOWN) {
            info = context.secondaryItems().map(item -> NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)item.getModifierList())).filter(inf -> inf != NlsUnspecified.UNKNOWN).findFirst().orElse(info);
        }
        if (info == NlsUnspecified.UNKNOWN && (member = (PsiMember)ObjectUtils.tryCast((Object)(owner instanceof PsiParameter ? ((PsiParameter)owner).getDeclarationScope() : owner), PsiMember.class)) != null) {
            info = NlsInfo.fromContainer(member);
        }
        if (info == NlsUnspecified.UNKNOWN && (!(parent instanceof UCallExpression) || owner instanceof PsiParameter)) {
            info = new NlsUnspecified(owner);
        }
        return info;
    }

    @NotNull
    private static NlsInfo fromType(PsiType type) {
        if (type == null) {
            return NlsUnspecified.UNKNOWN;
        }
        Ref result = Ref.create((Object)NlsUnspecified.UNKNOWN);
        InheritanceUtil.processSuperTypes((PsiType)type, (boolean)true, eachType -> {
            NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)eachType);
            if (info != NlsUnspecified.UNKNOWN) {
                result.set((Object)info);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly((PsiType)eachType) instanceof PsiTypeParameter;
        });
        return (NlsInfo)result.get();
    }

    @NotNull
    static NlsInfo fromUVariable(@NotNull UVariable owner) {
        for (UAnnotation annotation : owner.getUAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation);
            if (info != NlsUnspecified.UNKNOWN) {
                return info;
            }
            info = NlsInfo.fromMetaAnnotation(annotation.resolve());
            if (info == NlsUnspecified.UNKNOWN) continue;
            return info;
        }
        return NlsUnspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromAnnotationOwner(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            return NlsUnspecified.UNKNOWN;
        }
        if (owner instanceof PsiModifierList) {
            return (NlsInfo)CachedValuesManager.getCachedValue((PsiElement)((PsiModifierList)owner), () -> CachedValueProvider.Result.create((Object)NlsInfo.computeFromAnnotationOwner(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return NlsInfo.computeFromAnnotationOwner(owner);
    }

    @NotNull
    private static NlsInfo computeFromAnnotationOwner(@NotNull PsiAnnotationOwner owner) {
        PsiAnnotation annotation;
        PsiElement parent;
        for (PsiAnnotation annotation2 : owner.getAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation2);
            if (info != NlsUnspecified.UNKNOWN) {
                return info;
            }
            UAnnotation uAnnotation = (UAnnotation)UastContextKt.toUElement((PsiElement)annotation2, UAnnotation.class);
            if (uAnnotation != null) {
                info = NlsInfo.fromMetaAnnotation(uAnnotation.resolve());
            } else {
                String name = annotation2.getQualifiedName();
                if (name != null) {
                    info = NlsInfo.fromMetaAnnotation(JavaPsiFacade.getInstance((Project)annotation2.getProject()).findClass(name, annotation2.getResolveScope()));
                }
            }
            if (info == NlsUnspecified.UNKNOWN) continue;
            return info;
        }
        if (owner instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)parent), ANNOTATION_NAMES, (boolean)false)) != null) {
            return NlsInfo.fromAnnotation(annotation);
        }
        return NlsUnspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromMetaAnnotation(@Nullable PsiClass annotationClass) {
        if (annotationClass == null) {
            return NlsUnspecified.UNKNOWN;
        }
        NlsInfo baseInfo = NlsUnspecified.UNKNOWN;
        String prefix = "";
        String suffix = "";
        for (PsiAnnotation metaAnno : annotationClass.getAnnotations()) {
            if (metaAnno.hasQualifiedName(NLS_CONTEXT)) {
                prefix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"prefix"));
                suffix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"suffix"));
                continue;
            }
            NlsInfo info = NlsInfo.fromAnnotation(metaAnno);
            if (info == NlsUnspecified.UNKNOWN) continue;
            baseInfo = info;
        }
        if (baseInfo instanceof Localized) {
            return ((Localized)baseInfo).withPrefixAndSuffix(prefix, suffix).withAnnotation(annotationClass.getQualifiedName());
        }
        return baseInfo;
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull PsiAnnotation annotation) {
        return NlsInfo.fromAnnotationInfo(annotation.getQualifiedName(), () -> (UExpression)UastContextKt.toUElement((PsiElement)annotation.findAttributeValue("capitalization"), UExpression.class));
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull UAnnotation annotation) {
        return NlsInfo.fromAnnotationInfo(annotation.getQualifiedName(), () -> annotation.findAttributeValue("capitalization"));
    }

    @NotNull
    private static NlsInfo fromAnnotationInfo(String qualifiedName, Supplier<? extends UExpression> capitalization) {
        if (qualifiedName == null) {
            return NlsUnspecified.UNKNOWN;
        }
        if (qualifiedName.equals("org.jetbrains.annotations.NonNls") || qualifiedName.equals("org.jetbrains.annotations.PropertyKey")) {
            return NonLocalized.INSTANCE;
        }
        if (qualifiedName.equals(NLS_SAFE) || qualifiedName.equals("org.intellij.lang.annotations.RegExp")) {
            return NlsSafe.INSTANCE;
        }
        if (qualifiedName.equals("org.jetbrains.annotations.Nls")) {
            UExpression value = capitalization.get();
            String name = null;
            if (value instanceof UReferenceExpression) {
                name = ((UReferenceExpression)value).getResolvedName();
            }
            if (name != null) {
                if (Nls.Capitalization.Title.name().equals(name)) {
                    return Localized.NLS_TITLE;
                }
                if (Nls.Capitalization.Sentence.name().equals(name)) {
                    return Localized.NLS_SENTENCE;
                }
            }
            return Localized.NLS;
        }
        return NlsUnspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromContainer(@NotNull PsiMember member) {
        for (PsiClass containingClass = member.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            NlsInfo classInfo = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)containingClass.getModifierList());
            if (classInfo == NlsUnspecified.UNKNOWN) continue;
            return classInfo;
        }
        PsiFile containingFile = member.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)member.getProject()).findPackage(packageName);
            if (aPackage != null) {
                NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)aPackage.getAnnotationList());
                if (info != NlsUnspecified.UNKNOWN) {
                    return info;
                }
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, ANNOTATION_NAMES, (boolean)false);
                if (annotation != null) {
                    return NlsInfo.fromAnnotation(annotation);
                }
            }
        }
        return NlsUnspecified.UNKNOWN;
    }

    public static final class NlsUnspecified
    extends NlsInfo {
        private static final NlsUnspecified UNKNOWN = new NlsUnspecified(null);
        @Nullable
        private final PsiModifierListOwner myCandidate;

        private NlsUnspecified(@Nullable PsiModifierListOwner candidate) {
            super(ThreeState.UNSURE);
            this.myCandidate = candidate;
        }

        @Nullable
        public PsiModifierListOwner getAnnotationCandidate() {
            return this.myCandidate;
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            return this == UNKNOWN ? RestrictionInfo.RestrictionInfoKind.UNKNOWN : RestrictionInfo.RestrictionInfoKind.UNSPECIFIED;
        }
    }

    public static final class NonLocalized
    extends NlsInfo {
        private static final NonLocalized INSTANCE = new NonLocalized();

        private NonLocalized() {
            super(ThreeState.NO);
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            return RestrictionInfo.RestrictionInfoKind.KNOWN;
        }
    }

    public static final class NlsSafe
    extends NlsInfo {
        private static final NlsSafe INSTANCE = new NlsSafe();

        private NlsSafe() {
            super(ThreeState.NO);
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            return RestrictionInfo.RestrictionInfoKind.KNOWN;
        }
    }

    public static final class Localized
    extends NlsInfo {
        private static final Localized NLS = new Localized(Nls.Capitalization.NotSpecified, "", "", null);
        private static final Localized NLS_TITLE = new Localized(Nls.Capitalization.Title, "", "", null);
        private static final Localized NLS_SENTENCE = new Localized(Nls.Capitalization.Sentence, "", "", null);
        @NotNull
        private final Nls.Capitalization myCapitalization;
        @NotNull
        @NonNls
        private final String myPrefix;
        @NotNull
        @NonNls
        private final String mySuffix;
        private final String myAnnotationName;

        private Localized(@NotNull Nls.Capitalization capitalization, @NotNull @NonNls String prefix, @NotNull @NonNls String suffix, @Nullable @NonNls String annotationName) {
            super(ThreeState.YES);
            this.myCapitalization = capitalization;
            this.myPrefix = prefix;
            this.mySuffix = suffix;
            this.myAnnotationName = annotationName;
        }

        @NotNull
        public Nls.Capitalization getCapitalization() {
            return this.myCapitalization;
        }

        @NotNull
        public String suggestAnnotation(PsiElement context) {
            if (this.myAnnotationName != null && JavaPsiFacade.getInstance((Project)context.getProject()).findClass(this.myAnnotationName, context.getResolveScope()) != null) {
                return this.myAnnotationName;
            }
            return "org.jetbrains.annotations.Nls";
        }

        @NotNull
        @NonNls
        public String getPrefix() {
            return this.myPrefix;
        }

        @NotNull
        @NonNls
        public String getSuffix() {
            return this.mySuffix;
        }

        @NotNull
        private Localized withPrefixAndSuffix(@NotNull String prefix, @NotNull String suffix) {
            if (prefix.equals(this.myPrefix) && suffix.equals(this.mySuffix)) {
                return this;
            }
            return new Localized(this.myCapitalization, prefix, suffix, this.myAnnotationName);
        }

        @NotNull
        private Localized withAnnotation(@Nullable String qualifiedName) {
            if (Objects.equals(qualifiedName, this.myAnnotationName)) {
                return this;
            }
            return new Localized(this.myCapitalization, this.myPrefix, this.mySuffix, qualifiedName);
        }

        @NotNull
        public RestrictionInfo.RestrictionInfoKind getKind() {
            return RestrictionInfo.RestrictionInfoKind.KNOWN;
        }
    }

    private static class NlsInfoFactory
    implements RestrictionInfoFactory<NlsInfo> {
        private static final NlsInfoFactory INSTANCE = new NlsInfoFactory();

        private NlsInfoFactory() {
        }

        @NotNull
        public NlsInfo fromAnnotationOwner(@Nullable PsiAnnotationOwner annotationOwner) {
            return NlsInfo.fromAnnotationOwner(annotationOwner);
        }

        @NotNull
        public NlsInfo fromModifierListOwner(@NotNull PsiModifierListOwner modifierListOwner) {
            return NlsInfo.fromAnnotationContext(null, AnnotationContext.fromModifierListOwner((PsiModifierListOwner)modifierListOwner));
        }
    }
}

