/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.RestrictionInfoFactory;
import com.intellij.codeInspection.restriction.StringFlowUtil;
import com.intellij.lang.Language;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.util.UastExpressionUtils;

public final class JavaI18nUtil {
    public static final PropertyCreationHandler DEFAULT_PROPERTY_CREATION_HANDLER = (project, propertiesFiles, key, value, parameters) -> I18nUtil.createProperty((Project)project, (Collection)propertiesFiles, (String)key, (String)value, (boolean)true);
    public static final PropertyCreationHandler EMPTY_CREATION_HANDLER = (project, propertiesFiles, key, value, parameters) -> {};

    private JavaI18nUtil() {
    }

    @Nullable
    public static TextRange getSelectedRange(Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        if (selectedText != null) {
            return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        }
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null || psiElement instanceof PsiWhiteSpace) {
            return null;
        }
        return psiElement.getTextRange();
    }

    public static boolean mustBePropertyKey(@NotNull PsiExpression expression, @Nullable Ref<? super PsiAnnotationMemberValue> resourceBundleRef) {
        UExpression value;
        Ref resourceBundleURef;
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)expression, UExpression.class);
        if (uExpression == null) {
            return false;
        }
        Ref ref = resourceBundleURef = resourceBundleRef == null ? null : Ref.create();
        if (!JavaI18nUtil.mustBePropertyKey(uExpression, (Ref<? super UExpression>)resourceBundleURef)) {
            return false;
        }
        if (resourceBundleURef != null && (value = (UExpression)resourceBundleURef.get()) != null) {
            resourceBundleRef.set(ObjectUtils.tryCast((Object)value.getSourcePsi(), PsiAnnotationMemberValue.class));
        }
        return true;
    }

    public static boolean mustBePropertyKey(@NotNull UExpression expression, @Nullable Ref<? super UExpression> resourceBundleRef) {
        expression = StringFlowUtil.goUp((UExpression)expression, (boolean)false, (RestrictionInfoFactory)NlsInfo.factory());
        AnnotationContext context = AnnotationContext.fromExpression((UExpression)expression);
        return context.allItems().anyMatch(owner -> {
            PsiAnnotation annotation = owner.findAnnotation("org.jetbrains.annotations.PropertyKey");
            if (annotation != null && resourceBundleRef != null) {
                PsiAnnotationMemberValue attributeValue = annotation.findAttributeValue("resourceBundle");
                resourceBundleRef.set((Object)UastContextKt.toUElement((PsiElement)attributeValue, UExpression.class));
            }
            return annotation != null;
        });
    }

    @NotNull
    static UExpression getTopLevelExpression(@NotNull UExpression expression, boolean stopAtCall) {
        UExpression parent;
        while (!(!(expression.getUastParent() instanceof UExpression) || (parent = (UExpression)expression.getUastParent()) instanceof UBlockExpression || parent instanceof UReturnExpression || parent instanceof UIfExpression && UastUtils.isPsiAncestor((UElement)((UIfExpression)parent).getCondition(), (UElement)expression) || UastExpressionUtils.isAssignment((UElement)(expression = parent)))) {
            UastCallKind kind;
            if (!(expression instanceof UCallExpression) || !stopAtCall || (kind = ((UCallExpression)expression).getKind()) != UastCallKind.METHOD_CALL) continue;
            if (!(expression.getUastParent() instanceof UQualifiedReferenceExpression)) break;
            expression = (UExpression)expression.getUastParent();
            break;
        }
        return expression;
    }

    static boolean isValidPropertyReference(@NotNull Project project, @NotNull PsiExpression expression, @NotNull String key, @NotNull Ref<? super String> outResourceBundle) {
        Ref resourceBundleRef = Ref.create();
        if (JavaI18nUtil.mustBePropertyKey(expression, (Ref<? super PsiAnnotationMemberValue>)resourceBundleRef)) {
            Object resourceBundleName = resourceBundleRef.get();
            if (!(resourceBundleName instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expr = (PsiExpression)resourceBundleName;
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
            Object value = constantEvaluationHelper.computeConstantExpression((PsiElement)expr);
            if (value == null) {
                PsiElement resolve;
                if (expr instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && (value = constantEvaluationHelper.computeConstantExpression((PsiElement)((PsiField)resolve).getInitializer())) == null) {
                    return false;
                }
                if (value == null) {
                    ResourceBundle resourceBundle = JavaI18nUtil.resolveResourceBundleByKey(key, project);
                    if (resourceBundle == null) {
                        return false;
                    }
                    PropertiesFile defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile();
                    String bundleName = BundleNameEvaluator.DEFAULT.evaluateBundleName(defaultPropertiesFile.getContainingFile());
                    if (bundleName == null) {
                        return false;
                    }
                    value = bundleName;
                }
            }
            String bundleName = value.toString();
            outResourceBundle.set((Object)bundleName);
            return JavaI18nUtil.isPropertyRef(expression, key, bundleName);
        }
        return true;
    }

    @Nullable
    private static ResourceBundle resolveResourceBundleByKey(@NotNull String key, @NotNull Project project) {
        Ref bundleRef = Ref.create();
        boolean r = PropertiesReferenceManager.getInstance((Project)project).processAllPropertiesFiles((baseName, propertiesFile) -> {
            if (propertiesFile.findPropertyByKey(key) != null) {
                if (bundleRef.get() == null) {
                    bundleRef.set((Object)propertiesFile.getResourceBundle());
                } else {
                    return ((ResourceBundle)bundleRef.get()).equals(propertiesFile.getResourceBundle());
                }
            }
            return true;
        });
        return r ? (ResourceBundle)bundleRef.get() : null;
    }

    private static boolean isPropertyRef(@NotNull PsiExpression expression, @NotNull String key, @Nullable String resourceBundleName) {
        if (resourceBundleName == null) {
            return !PropertiesImplUtil.findPropertiesByKey((Project)expression.getProject(), (String)key).isEmpty();
        }
        List propertiesFiles = I18nUtil.propertiesFilesByBundleName((String)resourceBundleName, (PsiElement)expression);
        boolean containedInPropertiesFile = false;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            containedInPropertiesFile |= propertiesFile.findPropertyByKey(key) != null;
        }
        return containedInPropertiesFile;
    }

    @NotNull
    public static Set<String> suggestExpressionOfType(PsiClassType type, PsiElement context) {
        PsiExpression[] expressions;
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt((PsiElement)context, (String)"");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PsiVariable var : variables) {
            PsiType varType = var.getType();
            PsiIdentifier identifier = var.getNameIdentifier();
            if (type != null && !type.isAssignableFrom(varType) || identifier == null) continue;
            result.add(identifier.getText());
        }
        for (PsiExpression expression : expressions = MacroUtil.getStandardExpressionsOfType((PsiElement)context, (PsiType)type)) {
            result.add(expression.getText());
        }
        if (type != null) {
            JavaI18nUtil.addAvailableMethodsOfType(type, context, result);
        }
        return result;
    }

    private static void addAvailableMethodsOfType(@NotNull PsiClassType type, @NotNull PsiElement context, @NotNull Collection<? super String> result) {
        PsiScopesUtil.treeWalkUp((element, state) -> {
            PsiMethod method;
            PsiType returnType;
            if (element instanceof PsiMethod && (returnType = (method = (PsiMethod)element).getReturnType()) != null && TypeConversionUtil.isAssignable((PsiType)type, (PsiType)returnType) && method.getParameterList().isEmpty()) {
                result.add(method.getName() + "()");
            }
            return true;
        }, (PsiElement)context, null);
    }

    public static int getPropertyValuePlaceholdersCount(@NotNull String propertyValue) {
        try {
            return JavaI18nUtil.countFormatParameters(new MessageFormat(propertyValue));
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    private static int countFormatParameters(@NotNull MessageFormat mf) {
        Format[] formats = mf.getFormatsByArgumentIndex();
        int maxLength = formats.length;
        for (Format format : formats) {
            if (!(format instanceof ChoiceFormat)) continue;
            for (Object o : ((ChoiceFormat)format).getFormats()) {
                maxLength = Math.max(maxLength, JavaI18nUtil.countFormatParameters(new MessageFormat((String)o)));
            }
        }
        return maxLength;
    }

    public static int getPropertyValueParamsMaxCount(@NotNull UExpression expression) {
        SortedSet<Integer> paramsCount = JavaI18nUtil.getPropertyValueParamsCount(expression, null);
        if (paramsCount.isEmpty()) {
            return -1;
        }
        return paramsCount.last();
    }

    @NotNull
    static SortedSet<Integer> getPropertyValueParamsCount(@NotNull PsiExpression expression, @Nullable String resourceBundleName) {
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)expression, UExpression.class);
        if (uExpression == null) {
            return new TreeSet<Integer>();
        }
        return JavaI18nUtil.getPropertyValueParamsCount(uExpression, resourceBundleName);
    }

    @NotNull
    private static SortedSet<Integer> getPropertyValueParamsCount(@NotNull UExpression expression, @Nullable String resourceBundleName) {
        ULiteralExpression literalExpression;
        if (expression instanceof ULiteralExpression) {
            literalExpression = (ULiteralExpression)expression;
        } else if (expression instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)expression).resolve();
            PsiField field = resolved == null ? null : (PsiField)resolved;
            literalExpression = field != null && field.hasModifierProperty("final") && field.getInitializer() instanceof PsiLiteralExpression ? (ULiteralExpression)UastContextKt.toUElement((PsiElement)field.getInitializer(), ULiteralExpression.class) : null;
        } else {
            literalExpression = null;
        }
        TreeSet<Integer> paramsCount = new TreeSet<Integer>();
        if (literalExpression == null) {
            return paramsCount;
        }
        for (PsiReference reference : UastLiteralUtils.getInjectedReferences((ULiteralExpression)literalExpression)) {
            if (!(reference instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                if (!result.isValidResult() || !(result.getElement() instanceof IProperty)) continue;
                try {
                    String propertyValue;
                    PsiFile file;
                    IProperty property = (IProperty)result.getElement();
                    if (resourceBundleName != null && !resourceBundleName.equals(BundleNameEvaluator.DEFAULT.evaluateBundleName(file = property.getPropertiesFile().getContainingFile())) || (propertyValue = property.getValue()) == null) continue;
                    paramsCount.add(JavaI18nUtil.getPropertyValuePlaceholdersCount(propertyValue));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return paramsCount;
    }

    @NotNull
    public static String buildUnescapedFormatString(@NotNull UStringConcatenationsFacade cf, @NotNull List<? super UExpression> formatParameters, @NotNull Project project) {
        return JavaI18nUtil.buildUnescapedFormatString(cf, formatParameters, project, false);
    }

    @NotNull
    private static String buildUnescapedFormatString(@NotNull UStringConcatenationsFacade cf, @NotNull List<? super UExpression> formatParameters, @NotNull Project project, boolean nested) {
        StringBuilder result = new StringBuilder();
        boolean noEscapingRequired = !nested && SequencesKt.all((Sequence)cf.getUastOperands(), expression -> expression instanceof ULiteralExpression);
        for (UExpression expression2 : SequencesKt.asIterable((Sequence)cf.getUastOperands())) {
            while (expression2 instanceof UParenthesizedExpression) {
                expression2 = ((UParenthesizedExpression)expression2).getExpression();
            }
            if (expression2 instanceof ULiteralExpression) {
                Object value = ((ULiteralExpression)expression2).getValue();
                if (value == null) continue;
                if (noEscapingRequired) {
                    result.append(value);
                    continue;
                }
                String formatString = PsiConcatenationUtil.formatString((String)value.toString(), (boolean)false);
                result.append(nested ? PsiConcatenationUtil.formatString((String)formatString, (boolean)false) : formatString);
                continue;
            }
            if (!nested && JavaI18nUtil.addChoicePattern(expression2, formatParameters, project, result)) continue;
            result.append("{").append(formatParameters.size()).append("}");
            formatParameters.add((UExpression)expression2);
        }
        return result.toString();
    }

    private static boolean addChoicePattern(@NotNull UExpression expression, @NotNull List<? super UExpression> formatParameters, @NotNull Project project, @NotNull StringBuilder result) {
        if (!(expression instanceof UIfExpression)) {
            return false;
        }
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return false;
        }
        UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)sourcePsi.getLanguage());
        if (generationPlugin == null) {
            return false;
        }
        UExpression thenExpression = ((UIfExpression)expression).getThenExpression();
        UExpression elseExpression = ((UIfExpression)expression).getElseExpression();
        if (!(thenExpression instanceof ULiteralExpression) && !(elseExpression instanceof ULiteralExpression)) {
            return false;
        }
        boolean nested = !(thenExpression instanceof ULiteralExpression) || !(elseExpression instanceof ULiteralExpression);
        String thenStr = JavaI18nUtil.getSideText(formatParameters, project, thenExpression, nested);
        String elseStr = JavaI18nUtil.getSideText(formatParameters, project, elseExpression, nested);
        result.append("{").append(formatParameters.size()).append(", choice, 0#").append(thenStr).append("|1#").append(elseStr).append("}");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        UIfExpression exCopy = (UIfExpression)UastContextKt.toUElement((PsiElement)sourcePsi.copy(), UIfExpression.class);
        assert (exCopy != null);
        generationPlugin.replace((UElement)Objects.requireNonNull(exCopy.getThenExpression()), (UElement)Objects.requireNonNull((ULiteralExpression)UastContextKt.toUElement((PsiElement)elementFactory.createExpressionFromText("0", null), ULiteralExpression.class)), ULiteralExpression.class);
        generationPlugin.replace((UElement)Objects.requireNonNull(exCopy.getElseExpression()), (UElement)Objects.requireNonNull((ULiteralExpression)UastContextKt.toUElement((PsiElement)elementFactory.createExpressionFromText("1", null), ULiteralExpression.class)), ULiteralExpression.class);
        formatParameters.add((UExpression)exCopy);
        return true;
    }

    @NotNull
    private static String getSideText(@NotNull List<? super UExpression> formatParameters, @NotNull Project project, UExpression expression, boolean nested) {
        Object elseStr;
        if (expression instanceof ULiteralExpression) {
            Object elseValue = ((ULiteralExpression)expression).getValue();
            if (elseValue != null) {
                elseStr = PsiConcatenationUtil.formatString((String)elseValue.toString(), (boolean)false);
                elseStr = nested ? PsiConcatenationUtil.formatString((String)elseStr, (boolean)false) : elseStr;
            } else {
                elseStr = "null";
            }
        } else {
            UStringConcatenationsFacade concatenation = UStringConcatenationsFacade.createFromTopConcatenation((UExpression)expression);
            if (concatenation != null) {
                elseStr = JavaI18nUtil.buildUnescapedFormatString(concatenation, formatParameters, project, true);
            } else {
                elseStr = "{" + formatParameters.size() + "}";
                formatParameters.add((UExpression)expression);
            }
        }
        return ((String)elseStr).replaceAll("([<>|#])", "'$1'");
    }

    @NotNull
    static String composeParametersText(@NotNull List<? extends UExpression> args) {
        return args.stream().map(UElement::getSourcePsi).filter(Objects::nonNull).map(psi -> psi.getText()).collect(Collectors.joining(","));
    }

    @Nullable
    public static Property resolveProperty(@NotNull UExpression expression) {
        PsiElement psi = expression.getSourcePsi();
        if (psi == null) {
            return null;
        }
        if (expression.equals(UastContextKt.toUElement((PsiElement)psi.getParent()))) {
            psi = psi.getParent();
        }
        return JavaI18nUtil.resolveProperty(psi);
    }

    @Nullable
    public static Property resolveProperty(PsiElement psi) {
        PsiReference[] references;
        for (PsiReference reference : references = psi.getReferences()) {
            PsiElement element;
            ResolveResult[] resolveResults;
            if (!(reference instanceof PropertyReference) || (resolveResults = ((PropertyReference)reference).multiResolve(false)).length != 1 || !resolveResults[0].isValidResult() || !((element = resolveResults[0].getElement()) instanceof Property)) continue;
            return (Property)element;
        }
        return null;
    }
}

