/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.io.IOUtil;
import com.intellij.xml.util.XmlUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertToBasicLatinInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            private void handle(@NotNull PsiElement element) {
                if (IOUtil.isAscii((String)element.getText())) {
                    return;
                }
                holder.registerProblem(element, JavaI18nBundle.message("inspection.non.basic.latin.character.display.name", new Object[0]), new LocalQuickFix[]{new ConvertToBasicLatinFix()});
            }

            public void visitComment(@NotNull PsiComment comment) {
                super.visitComment(comment);
                this.handle((PsiElement)comment);
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                super.visitLiteralExpression(expression);
                if (!(expression instanceof PsiLiteralExpressionImpl)) {
                    return;
                }
                if (!LITERALS.contains(((PsiLiteralExpressionImpl)expression).getLiteralElementType())) {
                    return;
                }
                this.handle((PsiElement)expression);
            }

            public void visitDocComment(PsiDocComment comment) {
                super.visitDocComment(comment);
                this.handle((PsiElement)comment);
            }
        };
    }

    private static class ConvertToBasicLatinFix
    implements LocalQuickFix {
        private ConvertToBasicLatinFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaI18nBundle.message("inspection.non.basic.latin.character.quickfix", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            Handler handler = element instanceof PsiLiteralExpression ? new LiteralHandler() : (element instanceof PsiDocComment ? new DocCommentHandler() : (element instanceof PsiComment ? new CommentHandler() : null));
            if (handler == null) {
                return;
            }
            PsiElement newElement = handler.getSubstitution(project, element);
            element.replace(newElement);
        }
    }

    private static class CommentHandler
    extends DocCommentHandler {
        private CommentHandler() {
        }
    }

    private static class DocCommentHandler
    extends Handler {
        private static Int2ObjectMap<String> ourEntities;

        private DocCommentHandler() {
        }

        @Override
        @NotNull
        PsiElement getSubstitution(@NotNull Project project, @NotNull PsiElement element) {
            DocCommentHandler.loadEntities(project);
            return ourEntities != null ? super.getSubstitution(project, element) : element;
        }

        @Override
        protected void convert(@NotNull StringBuilder sb, char ch) {
            String entity = (String)ourEntities.get((int)ch);
            if (entity != null) {
                sb.append('&').append(entity).append(';');
            } else {
                sb.append("&#x").append(Integer.toHexString(ch).toUpperCase(Locale.ENGLISH)).append(';');
            }
        }

        @Override
        @NotNull
        protected PsiElement getSubstitution(@NotNull PsiElementFactory factory, @NotNull PsiElement element, @NotNull String newText) {
            return factory.createCommentFromText(newText, element.getParent());
        }

        private static void loadEntities(@NotNull Project project) {
            XmlFile file;
            if (ourEntities != null) {
                return;
            }
            try {
                String url = ExternalResourceManager.getInstance().getResourceLocation("http://www.w3.org/TR/html4/loose.dtd", project);
                if (url == null) {
                    Logger.getInstance(ConvertToBasicLatinInspection.class).error("Namespace not found: http://www.w3.org/TR/html4/loose.dtd");
                    return;
                }
                VirtualFile vFile = VfsUtil.findFileByURL((URL)new URL(url));
                if (vFile == null) {
                    Logger.getInstance(ConvertToBasicLatinInspection.class).error("Resource not found: " + url);
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                if (!(psiFile instanceof XmlFile)) {
                    Logger.getInstance(ConvertToBasicLatinInspection.class).error("Unexpected resource: " + psiFile);
                    return;
                }
                file = (XmlFile)psiFile;
            }
            catch (MalformedURLException e) {
                Logger.getInstance(ConvertToBasicLatinInspection.class).error((Throwable)e);
                return;
            }
            Int2ObjectOpenHashMap entities = new Int2ObjectOpenHashMap();
            Pattern pattern = Pattern.compile("&#(\\d+);");
            XmlUtil.processXmlElements((XmlElement)file, arg_0 -> DocCommentHandler.lambda$loadEntities$0(pattern, (Int2ObjectMap)entities, arg_0), (boolean)true);
            ourEntities = entities;
        }

        private static /* synthetic */ boolean lambda$loadEntities$0(Pattern pattern, Int2ObjectMap entities, PsiElement element) {
            char i;
            XmlEntityDecl entity;
            Matcher m;
            if (element instanceof XmlEntityDecl && (m = pattern.matcher((entity = (XmlEntityDecl)element).getValueElement().getValue())).matches() && !DocCommentHandler.isBasicLatin(i = (char)Integer.parseInt(m.group(1)))) {
                entities.put((int)i, (Object)entity.getName());
            }
            return true;
        }
    }

    private static class LiteralHandler
    extends Handler {
        private LiteralHandler() {
        }

        @Override
        @NotNull
        protected PsiElement getSubstitution(@NotNull PsiElementFactory factory, @NotNull PsiElement element, @NotNull String newText) {
            return factory.createExpressionFromText(newText, element.getParent());
        }

        @Override
        protected void convert(@NotNull StringBuilder sb, char ch) {
            sb.append(String.format("\\u%04X", ch));
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        @NotNull
        PsiElement getSubstitution(@NotNull Project project, @NotNull PsiElement element) {
            String text = element.getText();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Handler.isBasicLatin(ch)) {
                    sb.append(ch);
                    continue;
                }
                this.convert(sb, ch);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            return this.getSubstitution(factory, element, sb.toString());
        }

        protected static boolean isBasicLatin(char ch) {
            return Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.BASIC_LATIN;
        }

        protected abstract void convert(@NotNull StringBuilder var1, char var2);

        @NotNull
        protected abstract PsiElement getSubstitution(@NotNull PsiElementFactory var1, @NotNull PsiElement var2, @NotNull String var3);
    }
}

