/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateStringLiteral;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicateStringLiteralInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final int MAX_FILES_TO_ON_THE_FLY_SEARCH = 10;
    public int MIN_STRING_LENGTH = 5;
    public boolean IGNORE_PROPERTY_KEYS;
    @NonNls
    private static final String BR = "<br>";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                DuplicateStringLiteralInspection.this.checkStringLiteralExpression(expression, holder, isOnTheFly);
            }
        };
    }

    @NotNull
    public String getShortName() {
        return "DuplicateStringLiteralInspection";
    }

    @NotNull
    private static List<PsiLiteralExpression> findDuplicateLiterals(final @NotNull StringLiteralSearchQuery query, final @NotNull Project project) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List words = ContainerUtil.filter((Collection)StringUtil.getWordsInStringLongestFirst((String)query.stringToFind), s -> s.length() >= query.minStringLength);
        if (words.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList foundExpressions = new SmartList();
        CacheManager.getInstance((Project)project).processVirtualFilesWithAllWords((Collection)words, (short)4, scope, true, (Processor)new Processor<VirtualFile>((List)foundExpressions){
            int filesWithLiterals;
            final /* synthetic */ List val$foundExpressions;
            {
                this.val$foundExpressions = list;
            }

            public boolean process(VirtualFile f) {
                List<PsiLiteralExpression> duplicateLiteralsInFile;
                FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(f);
                if (viewProvider == null || viewProvider.getPsi((Language)JavaLanguage.INSTANCE) == null) {
                    return true;
                }
                PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
                if (psiFile != null && !(duplicateLiteralsInFile = DuplicateStringLiteralInspection.findDuplicateLiteralsInFile(query.stringToFind, query.ignorePropertyKeys, psiFile)).isEmpty()) {
                    this.val$foundExpressions.addAll(duplicateLiteralsInFile);
                    if (query.isOnFlySearch && ++this.filesWithLiterals >= 10) {
                        return false;
                    }
                }
                return true;
            }
        });
        return foundExpressions;
    }

    @NotNull
    private static List<PsiLiteralExpression> findDuplicateLiteralsInFile(@NotNull String stringToFind, boolean ignorePropertyKeys, @NotNull PsiFile file) {
        ProgressManager.checkCanceled();
        CharSequence text = file.getViewProvider().getContents();
        StringSearcher searcher = new StringSearcher(stringToFind, true, true);
        SmartList foundExpr = new SmartList();
        LowLevelSearchUtil.processTexts((CharSequence)text, (int)0, (int)text.length(), (StringSearcher)searcher, arg_0 -> DuplicateStringLiteralInspection.lambda$findDuplicateLiteralsInFile$1(file, stringToFind, ignorePropertyKeys, (List)foundExpr, arg_0));
        return foundExpr;
    }

    private void checkStringLiteralExpression(@NotNull PsiLiteralExpression originalExpression, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiExpression[] foundExpr = this.getDuplicateLiterals(holder.getProject(), originalExpression, isOnTheFly);
        if (foundExpr.length == 0) {
            return;
        }
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        for (PsiExpression aClass2 : foundExpr) {
            if (aClass2 == originalExpression) continue;
            ProgressManager.checkCanceled();
            while ((aClass2 = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiClass.class)) != null && ((PsiClass)aClass2).getQualifiedName() == null) {
            }
            if (aClass2 == null) continue;
            classes.add((PsiClass)aClass2);
        }
        if (classes.isEmpty()) {
            return;
        }
        List tenClassesMost = ContainerUtil.getFirstItems(Arrays.asList(classes.toArray(PsiClass.EMPTY_ARRAY)), (int)10);
        Object classList = isOnTheFly ? StringUtil.join((Collection)tenClassesMost, aClass -> {
            boolean thisFile = aClass.getContainingFile() == originalExpression.getContainingFile();
            return "&nbsp;&nbsp;&nbsp;'<b>" + aClass.getQualifiedName() + "</b>'" + (String)(thisFile ? " " + JavaI18nBundle.message("inspection.duplicates.message.in.this.file", new Object[0]) : "");
        }, (String)", <br>") : StringUtil.join((Collection)tenClassesMost, aClass -> "'" + aClass.getQualifiedName() + "'", (String)", ");
        if (classes.size() > tenClassesMost.size()) {
            classList = (String)classList + BR + JavaI18nBundle.message("inspection.duplicates.message.more", classes.size() - 10);
        }
        String msg = JavaI18nBundle.message("inspection.duplicates.message", classList);
        SmartList fixes = new SmartList();
        if (isOnTheFly) {
            fixes.add(new IntroduceLiteralConstantFix(originalExpression));
            fixes.add(new NavigateToOccurrencesFix(originalExpression));
        }
        DuplicateStringLiteralInspection.createReplaceFixes(foundExpr, (PsiExpression)originalExpression, (Collection<? super LocalQuickFix>)fixes);
        LocalQuickFix[] array = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem((PsiElement)originalExpression, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, array);
    }

    private PsiExpression @NotNull [] getDuplicateLiterals(@NotNull Project project, @NotNull PsiLiteralExpression place, boolean isOnTheFly) {
        Object value = place.getValue();
        if (!(value instanceof String)) {
            return PsiExpression.EMPTY_ARRAY;
        }
        if (!DuplicateStringLiteralInspection.shouldCheck(place, this.IGNORE_PROPERTY_KEYS)) {
            return PsiExpression.EMPTY_ARRAY;
        }
        String stringToFind = (String)value;
        if (stringToFind.isEmpty()) {
            return PsiExpression.EMPTY_ARRAY;
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap duplicates = ConcurrentFactoryMap.createMap(q -> DuplicateStringLiteralInspection.findDuplicateLiterals(q, project).toArray(PsiExpression.EMPTY_ARRAY));
            return CachedValueProvider.Result.create((Object)duplicates, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (PsiExpression[])map.get(new StringLiteralSearchQuery(stringToFind, this.IGNORE_PROPERTY_KEYS, this.MIN_STRING_LENGTH, isOnTheFly));
    }

    private static boolean shouldCheck(@NotNull PsiLiteralExpression expression, boolean ignorePropertyKeys) {
        if (ignorePropertyKeys && JavaI18nUtil.mustBePropertyKey((PsiExpression)expression, null)) {
            return false;
        }
        return !SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)expression);
    }

    private static void createReplaceFixes(PsiExpression @NotNull [] foundExpr, @NotNull PsiExpression originalExpression, @NotNull Collection<? super LocalQuickFix> fixes) {
        for (PsiExpression expr : foundExpr) {
            boolean isAccessible;
            PsiClass containingClass;
            PsiField field;
            PsiElement parent;
            if (expr == originalExpression || !((parent = expr.getParent()) instanceof PsiField) || (field = (PsiField)parent).getInitializer() != expr || !field.hasModifierProperty("static") || (containingClass = field.getContainingClass()) == null || !(isAccessible = JavaPsiFacade.getInstance((Project)field.getProject()).getResolveHelper().isAccessible((PsiMember)field, (PsiElement)originalExpression, containingClass)) && containingClass.getQualifiedName() == null) continue;
            fixes.add((LocalQuickFix)new ReplaceFix(field, originalExpression));
        }
    }

    @Nullable
    private static PsiReferenceExpression createReferenceTo(@NotNull PsiField constant) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)constant.getProject()).getElementFactory();
        PsiReferenceExpression reference = (PsiReferenceExpression)factory.createExpressionFromText("XXX." + constant.getName(), null);
        PsiReferenceExpression classQualifier = (PsiReferenceExpression)reference.getQualifierExpression();
        PsiClass containingClass = constant.getContainingClass();
        if (containingClass.getQualifiedName() == null) {
            return null;
        }
        classQualifier.bindToElement((PsiElement)containingClass);
        if (reference.isReferenceTo((PsiElement)constant)) {
            return reference;
        }
        return null;
    }

    public JComponent createOptionsPanel() {
        final OptionsPanel optionsPanel = new OptionsPanel();
        optionsPanel.myIgnorePropertyKeyExpressions.addActionListener(e -> {
            this.IGNORE_PROPERTY_KEYS = optionsPanel.myIgnorePropertyKeyExpressions.isSelected();
        });
        optionsPanel.myMinStringLengthField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                try {
                    DuplicateStringLiteralInspection.this.MIN_STRING_LENGTH = Integer.parseInt(optionsPanel.myMinStringLengthField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        optionsPanel.myIgnorePropertyKeyExpressions.setSelected(this.IGNORE_PROPERTY_KEYS);
        optionsPanel.myMinStringLengthField.setText(Integer.toString(this.MIN_STRING_LENGTH));
        return optionsPanel.myPanel;
    }

    private PsiExpression @Nullable [] getDuplicateLiteralsUnderProgress(@NotNull PsiElement literalExpression) {
        if (!(literalExpression instanceof PsiLiteralExpression)) {
            return null;
        }
        Project project = literalExpression.getProject();
        return (PsiExpression[])ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (PsiExpression[])ReadAction.compute(() -> this.getDuplicateLiterals(project, (PsiLiteralExpression)literalExpression, false)), JavaI18nBundle.message("progress.title.searching.for.duplicates.of.0", ((PsiLiteralExpression)literalExpression).getValue()), true, project);
    }

    private static void introduceConstant(final PsiExpression @NotNull [] expressions, @NotNull Project project) {
        new IntroduceConstantHandler(){

            protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
                return new BaseOccurrenceManager(occurrence -> true){

                    protected PsiExpression @NotNull [] defaultOccurrences() {
                        return expressions;
                    }

                    protected PsiExpression @NotNull [] findOccurrences() {
                        return expressions;
                    }
                };
            }
        }.invoke(project, expressions);
    }

    private static /* synthetic */ boolean lambda$findDuplicateLiteralsInFile$1(PsiFile file, String stringToFind, boolean ignorePropertyKeys, List foundExpr, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null || !(element.getParent() instanceof PsiLiteralExpression)) {
            return true;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element.getParent();
        if (Comparing.equal((Object)stringToFind, (Object)expression.getValue()) && DuplicateStringLiteralInspection.shouldCheck(expression, ignorePropertyKeys)) {
            foundExpr.add(expression);
        }
        return true;
    }

    private static final class StringLiteralSearchQuery {
        @NotNull
        private final String stringToFind;
        private final boolean ignorePropertyKeys;
        private final int minStringLength;
        private final boolean isOnFlySearch;

        private StringLiteralSearchQuery(@NotNull String stringToFind, boolean ignorePropertyKeys, int minStringLength, boolean isOnFlySearch) {
            this.stringToFind = stringToFind;
            this.ignorePropertyKeys = ignorePropertyKeys;
            this.minStringLength = minStringLength;
            this.isOnFlySearch = isOnFlySearch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringLiteralSearchQuery query = (StringLiteralSearchQuery)o;
            return this.ignorePropertyKeys == query.ignorePropertyKeys && this.minStringLength == query.minStringLength && this.isOnFlySearch == query.isOnFlySearch && Objects.equals(this.stringToFind, query.stringToFind);
        }

        public int hashCode() {
            return Objects.hash(this.stringToFind, this.ignorePropertyKeys, this.minStringLength, this.isOnFlySearch);
        }
    }

    private class NavigateToOccurrencesFix
    extends LocalQuickFixOnPsiElement {
        NavigateToOccurrencesFix(PsiLiteralExpression representative) {
            super((PsiElement)representative);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, final @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiExpression[] literalExpressions = DuplicateStringLiteralInspection.this.getDuplicateLiteralsUnderProgress(startElement);
            if (literalExpressions == null) {
                return;
            }
            Usage[] usages = (Usage[])Stream.of(literalExpressions).map(UsageInfo::new).map(UsageInfo2UsageAdapter::new).toArray(Usage[]::new);
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = JavaI18nBundle.message("inspection.duplicates.occurrences.view.title", ((PsiLiteralExpression)startElement).getValue());
            presentation.setUsagesString(title);
            presentation.setTabName(title);
            presentation.setTabText(title);
            presentation.setShowCancelButton(true);
            UsageView view = UsageViewManager.getInstance((Project)project).showUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter(startElement){

                public String getPresentableText() {
                    return "String literal: '" + ((PsiLiteralExpression)startElement).getValue() + "'";
                }
            }}, usages, presentation);
            view.addButtonToLowerPane(() -> {
                DuplicateStringLiteralInspection.introduceConstant(literalExpressions, project);
                view.close();
            }, JavaI18nBundle.message("introduce.constant.across.the.project", new Object[0]));
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaI18nBundle.message("inspection.duplicates.navigate.to.occurrences", new Object[0]);
        }
    }

    private static final class ReplaceFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        @IntentionName
        private final String myText;
        @FileModifier.SafeFieldForPreview
        private final SmartPsiElementPointer<PsiField> myConst;

        private ReplaceFix(PsiField constant, PsiExpression originalExpression) {
            super((PsiElement)originalExpression);
            this.myText = JavaI18nBundle.message("inspection.duplicates.replace.quickfix", PsiFormatUtil.formatVariable((PsiVariable)constant, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            this.myConst = SmartPointerManager.getInstance((Project)constant.getProject()).createSmartPsiElementPointer((PsiElement)constant);
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiLiteralExpression myOriginalExpression = (PsiLiteralExpression)startElement;
            PsiField myConstant = (PsiField)this.myConst.getElement();
            if (myConstant == null) {
                return;
            }
            PsiExpression initializer = myConstant.getInitializer();
            if (!(initializer instanceof PsiLiteralExpression)) {
                return;
            }
            try {
                PsiReferenceExpression newReference;
                PsiReferenceExpression reference = DuplicateStringLiteralInspection.createReferenceTo(myConstant);
                if (reference != null && UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess((PsiJavaCodeReferenceElement)(newReference = (PsiReferenceExpression)myOriginalExpression.replace((PsiElement)reference)), (boolean)false, (boolean)false, (boolean)true)) {
                    newReference.getChildren()[0].delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            return JavaI18nBundle.message("inspection.duplicates.replace.family.quickfix", new Object[0]);
        }
    }

    private class IntroduceLiteralConstantFix
    extends LocalQuickFixOnPsiElement {
        IntroduceLiteralConstantFix(PsiLiteralExpression representative) {
            super((PsiElement)representative);
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @NotNull
        public String getFamilyName() {
            return JavaI18nBundle.message("introduce.constant.across.the.project", new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiExpression[] literalExpressions = DuplicateStringLiteralInspection.this.getDuplicateLiteralsUnderProgress(startElement);
            if (literalExpressions == null) {
                return;
            }
            DuplicateStringLiteralInspection.introduceConstant(literalExpressions, project);
        }
    }

    public static class OptionsPanel {
        private JTextField myMinStringLengthField;
        private JPanel myPanel;
        private JCheckBox myIgnorePropertyKeyExpressions;

        public OptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myMinStringLengthField = jTextField = new JTextField();
            jTextField.setColumns(3);
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(40, -1), null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaI18nBundle", OptionsPanel.class).getString("inspection.duplicates.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myIgnorePropertyKeyExpressions = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaI18nBundle", OptionsPanel.class).getString("inspection.duplicates.option.report.propertykey.expressions"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

