/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeProject;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.idea.lint.common.SuppressLintQuickFix;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.Project;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.plugins.groovy.GroovyLanguage;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintQuickFix;", "Lcom/intellij/codeInspection/SuppressQuickFix;", "id", "", "element", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "label", "addNoInspectionComment", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "applyFix", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "handleFile", "handleGroovy", "handleJava", "handleKotlin", "handleXml", "isAvailable", "", "context", "isSuppressAll", "startInWriteAction", "Companion", "intellij.lint"})
public final class SuppressLintQuickFix
implements SuppressQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String label;
    @NotNull
    private static final String NO_INSPECTION_PREFIX = "//noinspection ";

    public SuppressLintQuickFix(@NotNull String id, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.label = Companion.displayName(element, this.id);
    }

    public /* synthetic */ SuppressLintQuickFix(String string, PsiElement psiElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            psiElement = null;
        }
        this(string, psiElement);
    }

    public boolean isAvailable(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    public boolean isSuppressAll() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.label;
    }

    @NotNull
    public String getFamilyName() {
        return "Suppress";
    }

    public void applyFix(@NotNull com.intellij.openapi.project.Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        this.applyFix(element);
    }

    public final void applyFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = element.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            this.handleJava(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) {
            this.handleXml(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)GroovyLanguage.INSTANCE)) {
            this.handleGroovy(element);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            this.handleKotlin(element);
        } else {
            PsiFile psiFile;
            if (element instanceof PsiFile) {
                psiFile = (PsiFile)element;
            } else {
                psiFile = element.getContainingFile();
                if (psiFile == null) {
                    return;
                }
            }
            PsiFile file = psiFile;
            this.handleFile(file);
        }
    }

    private final void handleXml(PsiElement element) throws IncorrectOperationException {
        XmlFile xmlFile;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        if (!LintIdeUtilsKt.preparedToWrite((PsiElement)tag)) {
            return;
        }
        if (tag instanceof XmlFile) {
            xmlFile = (XmlFile)tag;
        } else {
            PsiFile psiFile = tag.getContainingFile();
            xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
            if (xmlFile == null) {
                return;
            }
        }
        XmlFile file = xmlFile;
        String lintId = Companion.getLintId(this.id);
        SuppressLintQuickFix.Companion.addSuppressAttribute(file, tag, lintId);
    }

    private final void handleJava(PsiElement element) throws IncorrectOperationException {
        PsiElement psiElement = SuppressLintQuickFix.Companion.findJavaSuppressElement(element);
        if (psiElement == null) {
            return;
        }
        PsiElement container = psiElement;
        if (!LintIdeUtilsKt.preparedToWrite(container)) {
            return;
        }
        com.intellij.openapi.project.Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        com.intellij.openapi.project.Project project2 = project;
        if (container instanceof PsiImportStatementBase) {
            int offset = element.getTextOffset();
            com.intellij.openapi.project.Project project3 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"element.project");
            PsiFile psiFile = ((PsiImportStatementBase)container).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"container.containingFile");
            this.addNoInspectionComment(project3, psiFile, offset);
        } else if (container instanceof PsiModifierListOwner) {
            String lintId = StringsKt.removePrefix((String)this.id, (CharSequence)"AndroidLint");
            SuppressLintQuickFix.Companion.addSuppressAnnotation(project2, container, (PsiModifierListOwner)container, lintId);
        }
    }

    private final void handleGroovy(PsiElement element) throws IncorrectOperationException {
        PsiFile psiFile;
        if (element instanceof PsiFile) {
            psiFile = (PsiFile)element;
        } else {
            psiFile = element.getContainingFile();
            if (psiFile == null) {
                return;
            }
        }
        PsiFile file = psiFile;
        if (!LintIdeUtilsKt.preparedToWrite((PsiElement)file)) {
            return;
        }
        com.intellij.openapi.project.Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        com.intellij.openapi.project.Project project2 = project;
        int offset = element.getTextOffset();
        this.addNoInspectionComment(project2, file, offset);
    }

    private final void addNoInspectionComment(com.intellij.openapi.project.Project project, PsiFile file, int offset) {
        int nonSpace;
        Document document = PsiDocumentManager.getInstance((com.intellij.openapi.project.Project)project).getDocument(file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        int line = document2.getLineNumber(offset);
        int lineStart = document2.getLineStartOffset(line);
        if (lineStart > 0) {
            int prevLineStart = document2.getLineStartOffset(line - 1);
            int prevLineEnd = document2.getLineEndOffset(line - 1);
            String string = document2.getText(new TextRange(prevLineStart, prevLineEnd));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026vLineStart, prevLineEnd))");
            String prevLine = string;
            int index = StringsKt.indexOf$default((CharSequence)prevLine, (String)NO_INSPECTION_PREFIX, (int)0, (boolean)false, (int)6, null);
            if (index != -1) {
                document2.insertString(prevLineStart + index + NO_INSPECTION_PREFIX.length(), (CharSequence)(Companion.getLintId(this.id) + ","));
                return;
            }
        }
        String string = document2.getText(new TextRange(lineStart, offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRange(lineStart, offset))");
        String linePrefix = string;
        for (nonSpace = 0; nonSpace < linePrefix.length() && Character.isWhitespace(linePrefix.charAt(nonSpace)); ++nonSpace) {
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        String string2 = Companion.getLintId(this.id);
        String string3 = linePrefix.substring(0, nonSpace);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        document2.insertString(lineStart + nonSpace, (CharSequence)(NO_INSPECTION_PREFIX + string2 + "\n" + string3));
    }

    private final void handleFile(PsiFile file) throws IncorrectOperationException {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            File dir;
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(virtualFile)");
            File binaryFile = file2;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)file));
            if (module != null && (dir = LintIdeProject.getLintProjectDirectory(module)) != null) {
                com.intellij.openapi.project.Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                com.intellij.openapi.project.Project project2 = project;
                LintIdeClient client = LintIdeSupport.createClient$default(LintIdeSupport.Companion.get(), project2, null, 2, null);
                Project lintProject = client.getProject(dir, dir);
                Configuration configuration = client.getConfiguration(lintProject, null);
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"client.getConfiguration(lintProject, null)");
                Configuration configuration2 = configuration;
                configuration2.ignore(this.id, binaryFile);
            }
        }
    }

    private final void handleKotlin(PsiElement element) throws IncorrectOperationException {
        PsiElement psiElement = SuppressLintQuickFix.Companion.findKotlinSuppressElement(element);
        if (psiElement == null) {
            return;
        }
        PsiElement target = psiElement;
        if (!LintIdeUtilsKt.preparedToWrite(target)) {
            return;
        }
        if (target instanceof KtModifierListOwner) {
            String argument = "\"" + Companion.getLintId(this.id) + "\"";
            ModifierListModifactorKt.addAnnotation((KtModifierListOwner)((KtModifierListOwner)target), (FqName)new FqName(SuppressLintQuickFix.Companion.getAnnotationClass(element)), (String)argument, (String)(AnnotateQuickFixKt.isNewLineNeededForAnnotation((KtElement)target) ? "\n" : " "), (Function1)((Function1)new Function1<KtAnnotationEntry, Boolean>(argument){
                final /* synthetic */ String $argument;
                {
                    this.$argument = $argument;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtAnnotationEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    return com.android.tools.idea.lint.common.SuppressLintQuickFix$Companion.access$addArgumentToAnnotation(SuppressLintQuickFix.Companion, entry, this.$argument);
                }
            }));
        } else {
            int offset = element.getTextOffset();
            PsiFile file = target.getContainingFile();
            com.intellij.openapi.project.Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            this.addNoInspectionComment(project, file, offset);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J,\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u0004J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\f\u0010#\u001a\u00020\u0006*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/lint/common/SuppressLintQuickFix$Companion;", "", "()V", "NO_INSPECTION_PREFIX", "", "addArgumentToAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "argument", "addSuppressAnnotation", "", "project", "Lcom/intellij/openapi/project/Project;", "container", "Lcom/intellij/psi/PsiElement;", "modifierOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "id", "addSuppressAttribute", "file", "Lcom/intellij/psi/xml/XmlFile;", "element", "Lcom/intellij/psi/xml/XmlTag;", "createNewAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "annotation", "displayName", "inspectionId", "findJavaSuppressElement", "findKotlinSuppressElement", "getAnnotationClass", "context", "getLintId", "intentionId", "isSuppressLintTarget", "intellij.lint"})
    public static final class Companion {
        private Companion() {
        }

        private final String getAnnotationClass(PsiElement context) {
            Module module;
            com.intellij.openapi.project.Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
            com.intellij.openapi.project.Project project2 = project;
            Module module2 = module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
            GlobalSearchScope scope = module2 != null ? module2.getModuleWithDependenciesAndLibrariesScope(false) : null;
            return scope != null && JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project2).findClass("android.annotation.SuppressLint", scope) != null ? "android.annotation.SuppressLint" : (Intrinsics.areEqual((Object)context.getLanguage(), (Object)KotlinLanguage.INSTANCE) ? "kotlin.Suppress" : "java.lang.SuppressWarnings");
        }

        @NotNull
        public final String getLintId(@NotNull String intentionId) {
            Intrinsics.checkNotNullParameter((Object)intentionId, (String)"intentionId");
            return StringsKt.removePrefix((String)intentionId, (CharSequence)"AndroidLint");
        }

        private final void addSuppressAttribute(XmlFile file, XmlTag element, String id) throws IncorrectOperationException {
            String string;
            XmlAttribute attribute = element.getAttribute("ignore", "http://schemas.android.com/tools");
            if (attribute == null || attribute.getValue() == null) {
                string = id;
            } else {
                ArrayList<String> ids = new ArrayList<String>();
                Splitter splitter = Splitter.on((char)',').trimResults();
                String string2 = attribute.getValue();
                Intrinsics.checkNotNull((Object)string2);
                for (String existing : splitter.split((CharSequence)string2)) {
                    if (Intrinsics.areEqual((Object)existing, (Object)id)) continue;
                    ids.add(existing);
                }
                ids.add(id);
                CollectionsKt.sort((List)ids);
                String string3 = Joiner.on((char)',').join((Iterable)ids);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n        val ids = Arra\u2026on(',').join(ids)\n      }");
                string = string3;
            }
            String value = string;
            LintIdeSupport.Companion.get().ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
            element.setAttribute("ignore", "http://schemas.android.com/tools", value);
        }

        private final void addSuppressAnnotation(com.intellij.openapi.project.Project project, PsiElement container, PsiModifierListOwner modifierOwner, String id) throws IncorrectOperationException {
            String annotationName = this.getAnnotationClass(container);
            String[] stringArray = new String[]{annotationName};
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])stringArray);
            PsiAnnotation newAnnotation = this.createNewAnnotation(project, container, annotation, id);
            if (newAnnotation != null) {
                if (annotation != null && annotation.isPhysical()) {
                    annotation.replace((PsiElement)newAnnotation);
                } else {
                    PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                    new AddAnnotationFix(annotationName, modifierOwner, attributes, new String[0]).invoke(project, null, container.getContainingFile());
                }
            }
        }

        private final PsiAnnotation createNewAnnotation(com.intellij.openapi.project.Project project, PsiElement container, PsiAnnotation annotation, String id) {
            if (annotation != null) {
                String currentSuppressedId = "\"" + id + "\"";
                String annotationText = annotation.getText();
                Intrinsics.checkNotNullExpressionValue((Object)annotationText, (String)"annotationText");
                if (!StringsKt.contains$default((CharSequence)annotationText, (CharSequence)"{", (boolean)false, (int)2, null)) {
                    PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                    if (attributes.length == 1) {
                        String suppressedWarnings = attributes[0].getText();
                        Intrinsics.checkNotNullExpressionValue((Object)suppressedWarnings, (String)"suppressedWarnings");
                        return StringsKt.contains$default((CharSequence)suppressedWarnings, (CharSequence)currentSuppressedId, (boolean)false, (int)2, null) ? null : JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText("@" + this.getAnnotationClass(container) + "({" + suppressedWarnings + ", " + currentSuppressedId + "})", container);
                    }
                } else {
                    int curlyBraceIndex = StringsKt.lastIndexOf$default((CharSequence)annotationText, (char)'}', (int)0, (boolean)false, (int)6, null);
                    if (curlyBraceIndex > 0) {
                        String string = annotationText.substring(0, curlyBraceIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        String oldSuppressWarning = string;
                        return StringsKt.contains$default((CharSequence)oldSuppressWarning, (CharSequence)currentSuppressedId, (boolean)false, (int)2, null) ? null : JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText(oldSuppressWarning + ", " + currentSuppressedId + "})", container);
                    }
                }
            } else {
                return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText("@" + this.getAnnotationClass(container) + "(\"" + id + "\")", container);
            }
            return null;
        }

        private final boolean addArgumentToAnnotation(KtAnnotationEntry entry, String argument) {
            KtValueArgumentList args = entry.getValueArgumentList();
            KtPsiFactory psiFactory = new KtPsiFactory((KtElement)entry, false, 2, null);
            KtValueArgumentList newArgList = psiFactory.createCallArguments("(" + argument + ")");
            if (args == null) {
                entry.addAfter((PsiElement)newArgList, entry.getLastChild());
            } else if (args.getArguments().isEmpty()) {
                args.replace((PsiElement)newArgList);
            } else {
                boolean bl;
                block8: {
                    List list = args.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"args.arguments");
                    Iterable $this$none$iv = list;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            KtValueArgument it = (KtValueArgument)element$iv;
                            boolean bl2 = false;
                            if (!it.textMatches((CharSequence)argument)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    args.addArgument((KtValueArgument)newArgList.getArguments().get(0));
                }
            }
            return true;
        }

        private final PsiElement findJavaSuppressElement(PsiElement element) {
            PsiElement psiElement;
            PsiModifierListOwner psiModifierListOwner = AnnotateQuickFixKt.findJavaAnnotationTarget(element);
            if (psiModifierListOwner != null) {
                psiElement = (PsiElement)psiModifierListOwner;
            } else {
                PsiElement $this$getParentOfType$iv;
                PsiElement psiElement2 = element;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                PsiImportStatementBase psiImportStatementBase = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiImportStatementBase.class, (boolean)strict$iv);
                if (psiImportStatementBase != null) {
                    psiElement = (PsiElement)psiImportStatementBase;
                } else {
                    $this$getParentOfType$iv = element;
                    strict$iv = false;
                    $i$f$getParentOfType = false;
                    psiElement = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiPackageStatement.class, (boolean)strict$iv);
                }
            }
            return psiElement;
        }

        private final PsiElement findKotlinSuppressElement(PsiElement element) {
            return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, (Condition)findKotlinSuppressElement.1.INSTANCE);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSuppressLintTarget(PsiElement $this$isSuppressLintTarget) {
            if ($this$isSuppressLintTarget instanceof KtDeclaration) {
                KtProperty ktProperty = $this$isSuppressLintTarget instanceof KtProperty ? (KtProperty)$this$isSuppressLintTarget : null;
                if ((ktProperty != null ? LintIdeUtilsKt.hasBackingField(ktProperty) : true) && !($this$isSuppressLintTarget instanceof KtFunctionLiteral) && !($this$isSuppressLintTarget instanceof KtDestructuringDeclaration)) {
                    if (!($this$isSuppressLintTarget instanceof KtClassInitializer)) return true;
                }
            }
            if ($this$isSuppressLintTarget instanceof KtImportDirective) return true;
            if (!($this$isSuppressLintTarget instanceof KtPackageDirective)) return false;
            return true;
        }

        @NotNull
        public final String displayName(@Nullable PsiElement element, @NotNull String inspectionId) {
            Object object;
            Language language;
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            String id = this.getLintId(inspectionId);
            PsiElement psiElement = element;
            Object object2 = language = psiElement != null ? psiElement.getLanguage() : null;
            if (Intrinsics.areEqual((Object)language, (Object)XMLLanguage.INSTANCE)) {
                Object[] objectArray = new Object[]{id};
                object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.attr", objectArray);
            } else if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
                PsiElement target = this.findJavaSuppressElement(element);
                if (target instanceof PsiModifierListOwner) {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.annotation", objectArray);
                } else {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
                }
            } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
                PsiElement target = this.findKotlinSuppressElement(element);
                if (target instanceof KtDeclaration) {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.annotation", objectArray);
                } else {
                    Object[] objectArray = new Object[]{id};
                    object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
                }
            } else if (Intrinsics.areEqual((Object)language, (Object)GroovyLanguage.INSTANCE)) {
                Object[] objectArray = new Object[]{id};
                object = LintBundle.Companion.message("android.lint.fix.suppress.lint.api.comment", objectArray);
            } else {
                object = "Suppress " + id;
            }
            return object;
        }

        public static final /* synthetic */ boolean access$addArgumentToAnnotation(Companion $this, KtAnnotationEntry entry, String argument) {
            return $this.addArgumentToAnnotation(entry, argument);
        }

        public static final /* synthetic */ boolean access$isSuppressLintTarget(Companion $this, PsiElement $receiver) {
            return $this.isSuppressLintTarget($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

