/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetAttributeQuickFix
extends DefaultLintQuickFix {
    private final String myAttributeName;
    private final String myValue;
    private final String myNamespace;
    private final int myDot;
    private final int myMark;

    public SetAttributeQuickFix(@NotNull String name, @Nullable String familyName, @NotNull String attributeName, @Nullable String namespace, @Nullable String value) {
        this(name, familyName, attributeName, namespace, value, value != null ? 0 : Integer.MIN_VALUE, value != null ? value.length() : Integer.MIN_VALUE);
    }

    public SetAttributeQuickFix(@NotNull String name, @Nullable String familyName, @NotNull String attributeName, @Nullable String namespace, @Nullable String value, int dot, int mark) {
        super(name, familyName);
        this.myAttributeName = attributeName;
        this.myValue = value;
        this.myNamespace = namespace;
        this.myDot = dot;
        this.myMark = mark;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute;
        XmlFile file;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return;
        }
        String value = this.myValue;
        if (value == null && context instanceof AndroidQuickfixContexts.DesignerContext && (value = LintIdeSupport.get().askForAttributeValue(this.myAttributeName, (PsiElement)tag)) == null) {
            return;
        }
        if (this.myNamespace != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlFile.class)) != null) {
            LintIdeSupport.get().ensureNamespaceImported(file, this.myNamespace, null);
        }
        if ((attribute = (XmlAttribute)ApplicationManager.getApplication().runWriteAction(() -> this.myNamespace != null ? tag.setAttribute(this.myAttributeName, this.myNamespace, "") : tag.setAttribute(this.myAttributeName, ""))) != null) {
            if (value != null && !value.isEmpty()) {
                String finalValue = value;
                ApplicationManager.getApplication().runWriteAction(() -> attribute.setValue(finalValue));
            }
            if (context instanceof AndroidQuickfixContexts.EditorContext) {
                Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                XmlAttributeValue valueElement = attribute.getValueElement();
                TextRange valueTextRange = attribute.getValueTextRange();
                if (valueElement != null) {
                    int valueElementStart = valueElement.getTextRange().getStartOffset();
                    if (this.myDot != Integer.MIN_VALUE) {
                        int end = valueElementStart + valueTextRange.getStartOffset() + this.myDot;
                        if (this.myMark != Integer.MIN_VALUE && this.myMark != this.myDot) {
                            int start = valueElementStart + valueTextRange.getStartOffset() + this.myMark;
                            editor.getCaretModel().moveToOffset(end);
                            editor.getSelectionModel().setSelection(start, end);
                        } else {
                            editor.getCaretModel().moveToOffset(end);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (this.myValue == null && contextType == AndroidQuickfixContexts.BatchContext.TYPE) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        XmlAttribute attribute = this.myNamespace != null ? tag.getAttribute(this.myAttributeName, this.myNamespace) : tag.getAttribute(this.myAttributeName);
        return attribute == null || !StringUtil.notNullize((String)this.myValue).equals(StringUtil.notNullize((String)attribute.getValue()));
    }
}

