/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.CreateFileQuickFix;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.util.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;

public class ReplaceStringQuickFix
extends DefaultLintQuickFix {
    @RegExp
    private final String myRegexp;
    private final String myNewValue;
    private boolean myShortenNames;
    private boolean myFormat;
    private List<String> myImports;
    private SmartPsiFileRange myRange;
    private String myExpandedNewValue;
    private String mySelectPattern;

    public ReplaceStringQuickFix(@Nullable String name, @Nullable String familyName, @Nullable @RegExp String regexp, @NotNull String newValue) {
        super(name, familyName);
        this.myNewValue = newValue;
        if (regexp != null && ((String)regexp).indexOf(40) == -1 && !((String)regexp).equals("_lint_insert_begin_") && !((String)regexp).equals("_lint_insert_end_")) {
            regexp = "(" + Pattern.quote((String)regexp) + ")";
        }
        this.myRegexp = regexp;
    }

    public static DefaultLintQuickFix create(@Nullable PsiFile file, LintFix.ReplaceString lintFix) {
        String pattern = lintFix.getOldPattern();
        String oldString = lintFix.getOldString();
        Object regexp = pattern != null ? pattern : (oldString != null ? ("_lint_insert_begin_".equals(oldString) || "_lint_insert_end_".equals(oldString) ? oldString : "(" + Pattern.quote(oldString) + ")") : null);
        String displayName = lintFix.getDisplayName();
        String familyName = lintFix.getFamilyName();
        String replacement = lintFix.getReplacement();
        String selectPattern = lintFix.getSelectPattern();
        Location range = lintFix.getRange();
        ReplaceStringQuickFix fix = new ReplaceStringQuickFix(displayName, familyName, (String)regexp, replacement);
        fix.myShortenNames = lintFix.getShortenNames();
        fix.myFormat = lintFix.getReformat();
        fix.mySelectPattern = selectPattern;
        fix.myImports = lintFix.getImports();
        if (range != null && file != null) {
            PsiFile rangeFile = file;
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)range.getFile(), (boolean)false);
            if (virtualFile != null) {
                PsiFile psiFile = file.getManager().findFile(virtualFile);
                if (psiFile != null) {
                    rangeFile = psiFile;
                }
            } else {
                File path = range.getFile();
                return new CreateFileQuickFix(path, replacement, null, null, false, lintFix.getDisplayName(), familyName);
            }
            Position start = range.getStart();
            Position end = range.getEnd();
            if (start != null && end != null) {
                SmartPointerManager manager = SmartPointerManager.getInstance((Project)rangeFile.getProject());
                int startOffset = start.getOffset();
                int endOffset = end.getOffset();
                if (endOffset > startOffset) {
                    TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
                    fix.myRange = manager.createSmartPsiFileRangePointer(rangeFile, textRange);
                }
            }
        }
        return fix;
    }

    public ReplaceStringQuickFix setShortenNames(boolean shortenNames) {
        this.myShortenNames = shortenNames;
        return this;
    }

    public ReplaceStringQuickFix setFormat(boolean format) {
        this.myFormat = format;
        return this;
    }

    public ReplaceStringQuickFix setSelectPattern(String selectPattern) {
        this.mySelectPattern = selectPattern;
        return this;
    }

    public void setRange(SmartPsiFileRange range) {
        this.myRange = range;
    }

    @Override
    @Nullable
    public SmartPsiFileRange getRange() {
        return this.myRange;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            if (this.myNewValue.isEmpty()) {
                return "Delete";
            }
            return "Replace with " + this.myNewValue;
        }
        return this.myName;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Nullable
    protected String getNewValue() {
        return this.myExpandedNewValue != null ? this.myExpandedNewValue : this.myNewValue;
    }

    protected void editBefore(@NotNull Document document) {
    }

    protected void editAfter(@NotNull Document document) {
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiFile file = startElement.getContainingFile();
        if (this.myRange != null && (file = this.myRange.getContainingFile()) == null) {
            return;
        }
        Project project = startElement.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = context.getDocument(file);
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            this.editBefore(document);
            TextRange range = this.getRange(startElement, endElement, true);
            if (range != null) {
                Pattern pattern;
                Matcher matcher;
                SmartPsiElementPointer endPointer;
                String newValue = this.getNewValue();
                if (newValue == null) {
                    newValue = "";
                }
                if (ReplaceStringQuickFix.whitespaceOnly(newValue)) {
                    range = ReplaceStringQuickFix.includeFullLineIfOnlySpace(document, range);
                }
                int startOffset = range.getStartOffset();
                int endOffset = range.getEndOffset();
                document.replaceString(startOffset, endOffset, (CharSequence)newValue);
                endOffset = startOffset + newValue.length();
                this.editAfter(document);
                documentManager.commitDocument(document);
                PsiElement element = file.findElementAt(startOffset);
                if (element == null) {
                    return;
                }
                startOffset = element.getTextOffset();
                PsiElement end = file.findElementAt(endOffset);
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
                SmartPsiElementPointer elementPointer = pointerManager.createSmartPsiElementPointer(element);
                SmartPsiElementPointer smartPsiElementPointer = endPointer = end != null ? pointerManager.createSmartPsiElementPointer(end) : null;
                if (this.myImports != null && !this.myImports.isEmpty()) {
                    PsiElement importSymbol;
                    if (file instanceof PsiJavaFile) {
                        PsiJavaFile javaFile = (PsiJavaFile)file;
                        for (String symbol : this.myImports) {
                            if (ReplaceStringQuickFix.alreadyImported(javaFile, symbol)) continue;
                            importSymbol = ReplaceStringQuickFix.findSymbol(symbol, (PsiFile)javaFile);
                            if (importSymbol instanceof PsiClass) {
                                ImportHelper importHelper = new ImportHelper(JavaCodeStyleSettings.getInstance((PsiFile)file));
                                importHelper.addImport(javaFile, (PsiClass)importSymbol);
                                continue;
                            }
                            if (!(importSymbol instanceof PsiMember)) continue;
                            PsiMember member = (PsiMember)importSymbol;
                            AddSingleMemberStaticImportAction.bindAllClassRefs((PsiFile)file, (PsiElement)member, (String)member.getName(), (PsiClass)member.getContainingClass());
                        }
                    } else if (file instanceof KtFile) {
                        KtFile ktFile = (KtFile)file;
                        for (String symbol : this.myImports) {
                            if (ReplaceStringQuickFix.alreadyImported(ktFile, symbol)) continue;
                            importSymbol = ReplaceStringQuickFix.findSymbol(symbol, (PsiFile)ktFile);
                            DeclarationDescriptor descriptor = null;
                            if (importSymbol instanceof KtDeclaration) {
                                descriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)importSymbol));
                            } else if (importSymbol instanceof PsiClass) {
                                descriptor = JavaResolutionUtils.getJavaClassDescriptor((PsiClass)((PsiClass)importSymbol));
                            } else if (importSymbol instanceof PsiMember) {
                                descriptor = JavaResolutionUtils.getJavaMemberDescriptor((PsiMember)((PsiMember)importSymbol));
                            }
                            if (descriptor == null) continue;
                            ImportInsertHelper.getInstance((Project)project).importDescriptor(ktFile, descriptor, false);
                        }
                    }
                }
                if ((this.myShortenNames || this.myFormat) && (element = elementPointer.getElement()) != null) {
                    Object parent;
                    end = endPointer != null ? endPointer.getElement() : null;
                    PsiElement psiElement = parent = end != null ? PsiTreeUtil.findCommonParent((PsiElement)element.getParent(), (PsiElement)end) : element.getParent();
                    if (parent == null) {
                        parent = element.getParent();
                    }
                    if (this.myShortenNames) {
                        parent = element.getLanguage() == JavaLanguage.INSTANCE ? JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(parent) : (element.getLanguage() == KotlinLanguage.INSTANCE && parent instanceof KtElement ? ShortenReferences.DEFAULT.process((KtElement)parent) : null);
                    }
                    if (this.myFormat) {
                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                        if (parent != null) {
                            codeStyleManager.reformat(parent);
                        } else {
                            codeStyleManager.reformatRange(element, startOffset, endOffset);
                        }
                    }
                }
                if (this.mySelectPattern != null && context instanceof AndroidQuickfixContexts.EditorContext && file.isPhysical() && (matcher = (pattern = Pattern.compile(this.mySelectPattern)).matcher(document.getText())).find(startOffset)) {
                    int selectEnd;
                    int selectStart;
                    if (matcher.groupCount() > 0) {
                        selectStart = matcher.start(1);
                        selectEnd = matcher.end(1);
                    } else {
                        selectStart = matcher.start();
                        selectEnd = matcher.end();
                    }
                    Editor editor = context.getEditor(file);
                    if (editor != null) {
                        editor.getSelectionModel().setSelection(selectStart, selectEnd);
                    }
                }
            }
        }
    }

    private static PsiElement findSymbol(String symbol, PsiFile file) {
        GlobalSearchScope scope;
        Project project = file.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass cls = facade.findClass(symbol, scope = GlobalSearchScope.allScope((Project)project));
        if (cls != null) {
            if (cls instanceof KtLightClass) {
                return ((KtLightClass)cls).getKotlinOrigin();
            }
            return cls;
        }
        int index = symbol.lastIndexOf(46);
        String className = symbol.substring(0, index);
        String name = symbol.substring(index + 1);
        cls = facade.findClass(className, scope);
        if (cls != null) {
            return ReplaceStringQuickFix.findSymbolMember(cls, name);
        }
        PsiPackage pkg = facade.findPackage(className);
        if (pkg != null) {
            for (PsiClass pkgCls : pkg.getClasses()) {
                PsiElement member = ReplaceStringQuickFix.findSymbolMember(pkgCls, name);
                if (member == null) continue;
                return member;
            }
        }
        Logger.getInstance(ReplaceStringQuickFix.class).warn("Couldn't find and import " + symbol);
        return null;
    }

    @Nullable
    private static PsiElement findSymbolMember(PsiClass cls, String name) {
        PsiMethod[] methods = cls.findMethodsByName(name, true);
        if (methods.length > 0) {
            PsiMethod method = methods[0];
            if (method instanceof KtLightMethod) {
                return ((KtLightMethod)method).getKotlinOrigin();
            }
            return method;
        }
        PsiField field = cls.findFieldByName(name, false);
        if (field != null) {
            if (field instanceof KtLightField) {
                return ((KtLightField)field).getKotlinOrigin();
            }
            return field;
        }
        return null;
    }

    private static boolean alreadyImported(PsiJavaFile javaFile, String symbol) {
        PsiImportList importList = javaFile.getImportList();
        if (importList != null) {
            for (PsiImportStatementBase statement : importList.getAllImportStatements()) {
                if (statement instanceof PsiImportStaticStatement) {
                    PsiImportStaticStatement s = (PsiImportStaticStatement)statement;
                    PsiClass aClass = s.resolveTargetClass();
                    if (aClass == null) {
                        String t;
                        String text = statement.getText();
                        if (!text.contains(symbol) || !(t = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)text, (CharSequence)"import").trim(), (CharSequence)"static").trim(), (CharSequence)";").trim()).equals(symbol)) continue;
                        return true;
                    }
                    String referenceName = s.getReferenceName();
                    if (!symbol.equals(aClass.getQualifiedName() + "." + referenceName)) continue;
                    return true;
                }
                if (!(statement instanceof PsiImportStatement) || !symbol.equals(((PsiImportStatement)statement).getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean alreadyImported(KtFile ktFile, String symbol) {
        KtImportList importList = ktFile.getImportList();
        if (importList != null) {
            for (KtImportDirective statement : importList.getImports()) {
                String imported;
                FqName fqName = statement.getImportedFqName();
                if (fqName == null || !symbol.equals(imported = fqName.asString())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean whitespaceOnly(@NotNull String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static TextRange includeFullLineIfOnlySpace(@NotNull Document document, @NotNull TextRange range) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int lineStart = DocumentUtil.getLineStartOffset((int)startOffset, (Document)document);
        int lineEnd = DocumentUtil.getLineEndOffset((int)startOffset, (Document)document);
        if (lineEnd < endOffset) {
            return range;
        }
        String prefix = document.getText(new TextRange(lineStart, startOffset));
        String suffix = document.getText(new TextRange(endOffset, lineEnd));
        if (ReplaceStringQuickFix.whitespaceOnly(prefix) && ReplaceStringQuickFix.whitespaceOnly(suffix)) {
            return new TextRange(lineStart, lineEnd + 1);
        }
        return range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private TextRange getRange(PsiElement startElement, PsiElement endElement, boolean computeReplacement) {
        int end;
        int start;
        if (!startElement.isValid() || !endElement.isValid()) {
            return null;
        }
        if (this.myRange != null) {
            PsiFile file = this.myRange.getContainingFile();
            if (file == null) {
                return null;
            }
            Segment segment = this.myRange.getRange();
            if (segment == null) return null;
            start = segment.getStartOffset();
            end = segment.getEndOffset();
            if (this.myRegexp != null && !"_lint_insert_begin_".equals(this.myRegexp) && !"_lint_insert_end_".equals(this.myRegexp)) {
                startElement = file.findElementAt(start);
                endElement = file.findElementAt(end);
                if (startElement == null || endElement == null) {
                    return null;
                }
            }
        } else {
            start = startElement.getTextOffset();
            end = endElement.getTextOffset() + endElement.getTextLength();
        }
        if (this.myRegexp == null) return new TextRange(start, end);
        if ("_lint_insert_begin_".equals(this.myRegexp)) {
            return new TextRange(start, start);
        }
        if ("_lint_insert_end_".equals(this.myRegexp)) {
            return new TextRange(end, end);
        }
        try {
            String sequence;
            Pattern pattern = Pattern.compile(this.myRegexp, 8);
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            if (parent != null && parent.getTextRange().containsRange(start, end)) {
                TextRange parentRange = parent.getTextRange();
                int offset = parentRange.getStartOffset();
                sequence = parent.getText().substring(start - offset, end - offset);
            } else {
                String text = startElement.getContainingFile().getText();
                sequence = text.substring(start, end);
            }
            Matcher matcher = pattern.matcher(sequence);
            if (!matcher.find()) return null;
            end = start;
            if (matcher.groupCount() > 0) {
                if (this.myRegexp.contains("target")) {
                    try {
                        start += matcher.start("target");
                        end += matcher.end("target");
                    }
                    catch (IllegalArgumentException ignore) {
                        start += matcher.start(1);
                        end += matcher.end(1);
                    }
                } else {
                    start += matcher.start(1);
                    end += matcher.end(1);
                }
            } else {
                start += matcher.start();
                end += matcher.end();
            }
            if (!computeReplacement || this.myExpandedNewValue != null) return new TextRange(start, end);
            this.myExpandedNewValue = LintFix.ReplaceString.expandBackReferences((String)this.myNewValue, (Matcher)matcher);
            return new TextRange(start, end);
        }
        catch (Exception e) {
            Logger.getInstance(ReplaceStringQuickFix.class).warn("Invalid regular expression " + this.myRegexp);
            return null;
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return this.getRange(startElement, endElement, false) != null;
    }
}

