/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class LintIdeIssueRegistry
extends BuiltinIssueRegistry {
    private static List<Issue> ourFilteredIssues;

    public static IssueRegistry get() {
        return LintIdeSupport.get().getIssueRegistry();
    }

    public List<Issue> getIssues() {
        if (ourFilteredIssues == null) {
            List issues = super.getIssues();
            ArrayList<Issue> result = new ArrayList<Issue>(issues.size());
            for (Issue issue : issues) {
                if (!this.isRelevant(issue)) continue;
                result.add(issue);
            }
            ourFilteredIssues = result;
        }
        return ourFilteredIssues;
    }

    public boolean isRelevant(Issue issue) {
        Implementation implementation = issue.getImplementation();
        EnumSet scope = implementation.getScope();
        if (scope.contains(Scope.CLASS_FILE) || scope.contains(Scope.ALL_CLASS_FILES) || scope.contains(Scope.JAVA_LIBRARIES)) {
            for (EnumSet analysisScope : implementation.getAnalysisScopes()) {
                if (analysisScope.contains(Scope.CLASS_FILE) || analysisScope.contains(Scope.ALL_CLASS_FILES) || analysisScope.contains(Scope.JAVA_LIBRARIES)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

