/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.AnnotateQuickFix;
import com.android.tools.idea.lint.common.CreateFileQuickFix;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintGlobalInspectionContext;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFixProvider;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.idea.lint.common.ReplaceStringQuickFix;
import com.android.tools.idea.lint.common.SetAttributeQuickFix;
import com.android.tools.idea.lint.common.ShowUrlQuickFix;
import com.android.tools.idea.lint.common.SuppressLintQuickFix;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.siyeh.ig.InspectionGadgetsFix;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinFileType;

public abstract class AndroidLintInspectionBase
extends GlobalInspectionTool {
    public static final String LINT_INSPECTION_PREFIX = "AndroidLint";
    private static final Logger LOG;
    private static final Object ISSUE_MAP_LOCK;
    private static final Key<Map<Issue, String>> ISSUE_MAP_KEY;
    private static final Key<List<Tools>> DYNAMIC_TOOLS_KEY;
    private static boolean ourRegisterDynamicToolsFromTests;
    protected final Issue myIssue;
    private String[] myGroupPath;
    private final String myDisplayName;

    protected AndroidLintInspectionBase(@NotNull String displayName, @NotNull Issue issue) {
        this.myIssue = issue;
        this.myDisplayName = displayName;
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        LintIdeQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message);
        if (fixData != null && fixes.length == 0) {
            return AndroidLintInspectionBase.createFixes(startElement.getContainingFile(), fixData);
        }
        return fixes;
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        return this.getQuickFixes(message);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull String message) {
        return LintIdeQuickFix.EMPTY_ARRAY;
    }

    @NotNull
    public IntentionAction[] getIntentions(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return IntentionAction.EMPTY_ARRAY;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    @NotNull
    public LintIdeQuickFix[] getAllFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData, @NotNull LintIdeQuickFixProvider[] fixProviders, @NotNull Issue issue) {
        ArrayList result = new ArrayList(4);
        PsiFile file = startElement.getContainingFile();
        if (file != null && file.getFileType() == KotlinFileType.INSTANCE) {
            for (LintIdeQuickFixProvider provider : fixProviders) {
                LintIdeQuickFix[] fixes = provider.getQuickFixes(issue, startElement, endElement, message, fixData);
                Collections.addAll(result, fixes);
            }
        }
        LintIdeQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message, fixData);
        Collections.addAll(result, fixes);
        return result.toArray(LintIdeQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    public LocalQuickFix[] getLocalQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData, @NotNull LintIdeQuickFixProvider[] fixProviders, @NotNull Issue issue) {
        LintIdeSupport ideSupport = LintIdeSupport.get();
        boolean includeFeedbackFix = ideSupport.canRequestFeedback();
        LintIdeQuickFix[] fixes = this.getAllFixes(startElement, endElement, message, fixData, fixProviders, issue);
        if (fixes.length == 0) {
            if (includeFeedbackFix) {
                return new LocalQuickFix[]{ideSupport.requestFeedbackFix(issue)};
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<MyLocalQuickFix> result = new ArrayList<MyLocalQuickFix>(fixes.length);
        for (LintIdeQuickFix fix : fixes) {
            if (!fix.isApplicable(startElement, endElement, AndroidQuickfixContexts.BatchContext.TYPE)) continue;
            result.add(new MyLocalQuickFix(fix));
        }
        if (includeFeedbackFix) {
            result.add((MyLocalQuickFix)ideSupport.requestFeedbackFix(issue));
        }
        return result.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        LintGlobalInspectionContext androidLintContext = (LintGlobalInspectionContext)globalContext.getExtension(LintGlobalInspectionContext.ID);
        if (androidLintContext == null) {
            return;
        }
        Map<Issue, Map<File, List<LintProblemData>>> problemMap = androidLintContext.getResults();
        if (problemMap == null) {
            return;
        }
        Map<File, List<LintProblemData>> file2ProblemList = problemMap.get(this.myIssue);
        if (file2ProblemList == null) {
            return;
        }
        for (Map.Entry<File, List<LintProblemData>> entry : file2ProblemList.entrySet()) {
            File file = entry.getKey();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) continue;
            ApplicationManager.getApplication().runReadAction(() -> {
                ProblemDescriptor[] descriptors;
                PsiDirectory psiDirectory;
                PsiManager psiManager = PsiManager.getInstance((Project)globalContext.getProject());
                PsiFile psiFile = psiManager.findFile(vFile);
                if (psiFile != null) {
                    ProblemDescriptor[] descriptors2 = this.computeProblemDescriptors((PsiElement)psiFile, manager, (List)entry.getValue());
                    if (descriptors2.length > 0) {
                        problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiFile), (CommonProblemDescriptor[])descriptors2);
                    }
                } else if (vFile.isDirectory() && (psiDirectory = psiManager.findDirectory(vFile)) != null && (descriptors = this.computeProblemDescriptors((PsiElement)psiDirectory, manager, (List)entry.getValue())).length > 0) {
                    problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiDirectory), (CommonProblemDescriptor[])descriptors);
                }
            });
        }
    }

    @NotNull
    private ProblemDescriptor[] computeProblemDescriptors(@NotNull PsiElement psiFile, @NotNull InspectionManager manager, @NotNull List<LintProblemData> problems) {
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        LintIdeQuickFixProvider[] fixProviders = (LintIdeQuickFixProvider[])LintIdeQuickFixProvider.EP_NAME.getExtensions();
        for (LintProblemData problemData : problems) {
            String originalMessage = problemData.getMessage();
            String formattedMessage = "<html>" + TextFormat.RAW.convertTo(originalMessage, TextFormat.HTML_WITH_UNICODE) + "</html>";
            LintFix quickfixData = problemData.getQuickfixData();
            TextRange range = problemData.getTextRange();
            Issue issue = problemData.getIssue();
            if (range.getStartOffset() == range.getEndOffset()) {
                if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiDirectory) {
                    LocalQuickFix[] fixes = this.getLocalQuickFixes(psiFile, psiFile, originalMessage, quickfixData, fixProviders, issue);
                    result.add(new NonTextFileProblemDescriptor((PsiFileSystemItem)psiFile, formattedMessage, fixes));
                    continue;
                }
                if (this.isSuppressedFor(psiFile)) continue;
                result.add(manager.createProblemDescriptor(psiFile, formattedMessage, false, this.getLocalQuickFixes(psiFile, psiFile, originalMessage, quickfixData, fixProviders, issue), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiElement startElement = psiFile.findElementAt(range.getStartOffset());
            PsiElement endElement = psiFile.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || this.isSuppressedFor(startElement)) continue;
            result.add(manager.createProblemDescriptor(startElement, endElement, formattedMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getLocalQuickFixes(startElement, endElement, originalMessage, quickfixData, fixProviders, issue)));
        }
        return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressLintQuickFix suppressLintQuickFix = new SuppressLintQuickFix(this.myIssue.getId(), element);
        return new SuppressQuickFix[]{suppressLintQuickFix};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void setRegisterDynamicToolsFromTests(boolean registerDynamicToolsFromTests) {
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            ourRegisterDynamicToolsFromTests = registerDynamicToolsFromTests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static List<Tools> getDynamicTools(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            List tools = (List)project.getUserData(DYNAMIC_TOOLS_KEY);
            return tools != null ? Collections.unmodifiableList(tools) : null;
        }
    }

    @Nullable
    public static Issue findIssueByShortName(@Nullable Project project, @NotNull String name) {
        Object inspectionName = name.startsWith(LINT_INSPECTION_PREFIX) ? name : LINT_INSPECTION_PREFIX + name;
        Issue issue = null;
        List<Tools> tools = AndroidLintInspectionBase.getDynamicTools(project);
        if (tools != null) {
            for (Tools tools2 : tools) {
                InspectionProfileEntry e;
                if (!((String)inspectionName).equals(tools2.getShortName()) || !((e = tools2.getTool().getTool()) instanceof AndroidLintInspectionBase)) continue;
                issue = ((AndroidLintInspectionBase)e).getIssue();
                break;
            }
        }
        if (issue == null && project != null) {
            for (InspectionToolWrapper inspectionToolWrapper : AndroidLintInspectionBase.getInspectionTools(project)) {
                InspectionProfileEntry entry;
                if (!((String)inspectionName).equals(inspectionToolWrapper.getShortName()) || !((entry = inspectionToolWrapper.getTool()) instanceof AndroidLintInspectionBase)) continue;
                issue = ((AndroidLintInspectionBase)entry).getIssue();
            }
        }
        return issue;
    }

    @NotNull
    private static List<InspectionToolWrapper<?, ?>> getInspectionTools(@NotNull Project project) {
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        try {
            return profile.getInspectionTools(null);
        }
        catch (Throwable t) {
            LOG.warn("Couldn't look up inspection tools", t);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInspectionShortNameByIssue(@NotNull Project project, @NotNull Issue issue) {
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            String name;
            HashMap<Issue, String> issue2InspectionShortName = (HashMap<Issue, String>)project.getUserData(ISSUE_MAP_KEY);
            if (issue2InspectionShortName == null) {
                issue2InspectionShortName = new HashMap<Issue, String>();
                project.putUserData(ISSUE_MAP_KEY, issue2InspectionShortName);
                for (InspectionToolWrapper<?, ?> e : AndroidLintInspectionBase.getInspectionTools(project)) {
                    InspectionProfileEntry entry;
                    String shortName = e.getShortName();
                    if (!shortName.startsWith(LINT_INSPECTION_PREFIX) || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                    Issue s = ((AndroidLintInspectionBase)entry).getIssue();
                    issue2InspectionShortName.put(s, shortName);
                }
            }
            if ((name = (String)issue2InspectionShortName.get(issue)) == null && (!ApplicationManager.getApplication().isUnitTestMode() || ourRegisterDynamicToolsFromTests && !new BuiltinIssueRegistry().getIssues().contains(issue))) {
                AndroidLintInspectionBase tool = AndroidLintInspectionBase.createInspection(issue);
                LintInspectionFactory factory = new LintInspectionFactory(tool);
                InspectionProfileImpl base = InspectionProfileKt.getBASE_PROFILE();
                InspectionProfileImpl current = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                base.addTool(project, (InspectionToolWrapper)factory, (Map)new THashMap());
                current.addTool(project, (InspectionToolWrapper)factory, (Map)new THashMap());
                name = tool.getShortName();
                issue2InspectionShortName.put(issue, name);
                ToolsImpl tools = current.getToolsOrNull(name, project);
                if (tools != null) {
                    ArrayList<ToolsImpl> ourDynamicTools = (ArrayList<ToolsImpl>)project.getUserData(DYNAMIC_TOOLS_KEY);
                    if (ourDynamicTools == null) {
                        ourDynamicTools = new ArrayList<ToolsImpl>();
                        project.putUserData(DYNAMIC_TOOLS_KEY, ourDynamicTools);
                    }
                    ourDynamicTools.add(tools);
                }
            }
            return name;
        }
    }

    private static AndroidLintInspectionBase createInspection(Issue issue) {
        return new AndroidLintInspectionBase(issue.getBriefDescription(TextFormat.TEXT), issue){};
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        Category category = this.myIssue.getCategory();
        while (category.getParent() != null) {
            category = category.getParent();
        }
        return LintBundle.message("android.lint.inspections.group.name", new Object[0]) + ": " + category.getName();
    }

    @NotNull
    public String[] getGroupPath() {
        if (this.myGroupPath == null) {
            Category category = this.myIssue.getCategory();
            int count = 2;
            for (Category curr = category; curr != null; curr = curr.getParent()) {
                ++count;
            }
            String[] path = new String[count];
            while (category != null) {
                path[--count] = category.getName();
                category = category.getParent();
            }
            assert (count == 2);
            path[0] = LintBundle.message("android.inspections.group.name", new Object[0]);
            path[1] = LintBundle.message("android.lint.inspections.subgroup.name", new Object[0]);
            this.myGroupPath = path;
        }
        return this.myGroupPath;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getStaticDescription() {
        List urls;
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html><body>");
        sb.append(this.myIssue.getBriefDescription(TextFormat.HTML));
        sb.append("<br><br>");
        sb.append(this.myIssue.getExplanation(TextFormat.HTML));
        sb.append("<br><br>Issue id: ").append(this.myIssue.getId());
        List options = this.myIssue.getOptions();
        if (!options.isEmpty()) {
            sb.append("<br><br>");
            String optionsHtml = Option.Companion.describe(options, TextFormat.HTML, true);
            sb.append(optionsHtml);
        }
        if (!(urls = this.myIssue.getMoreInfo()).isEmpty()) {
            boolean separated = false;
            for (String url : urls) {
                if (this.myIssue.getExplanation(TextFormat.RAW).contains(url)) continue;
                if (!separated) {
                    sb.append("<br><br>");
                    separated = true;
                } else {
                    sb.append("<br>");
                }
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\">");
                sb.append(url);
                sb.append("</a>");
            }
        }
        Vendor vendor = this.myIssue.getVendor();
        IssueRegistry registry = this.myIssue.getRegistry();
        if (vendor == null && registry != null) {
            vendor = registry.getVendor();
        }
        if (vendor != null && vendor != IssueRegistry.Companion.getAOSP_VENDOR()) {
            sb.append("<br/><br/>\n");
            vendor.describeInto(sb, TextFormat.HTML, "");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEnabledByDefault() {
        return this.myIssue.isEnabledByDefault();
    }

    @NotNull
    public String getShortName() {
        return LINT_INSPECTION_PREFIX + this.myIssue.getId();
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        Severity defaultSeverity = this.myIssue.getDefaultSeverity();
        HighlightDisplayLevel displayLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(defaultSeverity);
        return displayLevel != null ? displayLevel : HighlightDisplayLevel.WARNING;
    }

    @Nullable
    static HighlightDisplayLevel toHighlightDisplayLevel(@NotNull Severity severity) {
        switch (severity) {
            case ERROR: 
            case FATAL: {
                return HighlightDisplayLevel.ERROR;
            }
            case WARNING: {
                return HighlightDisplayLevel.WARNING;
            }
            case INFORMATIONAL: {
                return HighlightDisplayLevel.WEAK_WARNING;
            }
            case IGNORE: {
                return null;
            }
        }
        LOG.error("Unknown severity " + severity);
        return null;
    }

    private static boolean isSingleFileScope(EnumSet<Scope> scopes) {
        if (scopes.size() != 1) {
            return false;
        }
        Scope scope = (Scope)scopes.iterator().next();
        return scope == Scope.JAVA_FILE || scope == Scope.RESOURCE_FILE || scope == Scope.MANIFEST || scope == Scope.PROGUARD_FILE || scope == Scope.OTHER;
    }

    public boolean worksInBatchModeOnly() {
        Implementation implementation = this.myIssue.getImplementation();
        if (AndroidLintInspectionBase.isSingleFileScope(implementation.getScope())) {
            return false;
        }
        for (EnumSet scopes : implementation.getAnalysisScopes()) {
            if (!AndroidLintInspectionBase.isSingleFileScope(scopes)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Issue getIssue() {
        return this.myIssue;
    }

    public static LintIdeQuickFix[] createFixes(@Nullable PsiFile file, @Nullable LintFix lintFix) {
        if (lintFix instanceof LintFix.ReplaceString) {
            DefaultLintQuickFix fix = ReplaceStringQuickFix.create(file, (LintFix.ReplaceString)lintFix);
            return new LintIdeQuickFix[]{fix};
        }
        if (lintFix instanceof LintFix.SetAttribute) {
            LintFix.SetAttribute data = (LintFix.SetAttribute)lintFix;
            if (data.getValue() == null) {
                return new LintIdeQuickFix[]{new RemoteAttributeFix(data)};
            }
            return new LintIdeQuickFix[]{new SetAttributeQuickFix(data.getDisplayName(), data.getFamilyName(), data.getAttribute(), data.getNamespace(), data.getValue(), data.getDot(), data.getMark())};
        }
        if (lintFix instanceof LintFix.CreateFileFix) {
            LintFix.CreateFileFix fix = (LintFix.CreateFileFix)lintFix;
            return new LintIdeQuickFix[]{new CreateFileQuickFix(fix.getFile(), fix.getText(), fix.getBinary(), fix.getSelectPattern(), fix.getReformat(), fix.getDisplayName(), fix.getFamilyName())};
        }
        if (lintFix instanceof LintFix.AnnotateFix) {
            LintFix.AnnotateFix fix = (LintFix.AnnotateFix)lintFix;
            return new LintIdeQuickFix[]{new AnnotateQuickFix(fix.getDisplayName(), fix.getFamilyName(), fix.getAnnotation(), fix.getReplace())};
        }
        if (lintFix instanceof LintFix.LintFixGroup) {
            LintFix.LintFixGroup group = (LintFix.LintFixGroup)lintFix;
            ArrayList fixList = new ArrayList();
            for (LintFix fix : group.getFixes()) {
                Collections.addAll(fixList, AndroidLintInspectionBase.createFixes(file, fix));
            }
            LintIdeQuickFix[] fixes = fixList.toArray(LintIdeQuickFix.EMPTY_ARRAY);
            switch (group.getType()) {
                case COMPOSITE: {
                    return new LintIdeQuickFix[]{new CompositeLintFix(lintFix.getDisplayName(), lintFix.getFamilyName(), fixes)};
                }
                case ALTERNATIVES: {
                    if (fixes.length > 1) {
                        fixes[0].setPriority(PriorityAction.Priority.TOP);
                    }
                    return fixes;
                }
            }
        } else if (lintFix instanceof LintFix.ShowUrl) {
            return new LintIdeQuickFix[]{new ShowUrlQuickFix((LintFix.ShowUrl)lintFix)};
        }
        return LintIdeQuickFix.EMPTY_ARRAY;
    }

    static {
        LintClient.setClientName((String)"studio");
        LOG = Logger.getInstance((String)"#com.android.tools.idea.lint.common.AndroidLintInspectionBase");
        ISSUE_MAP_LOCK = new Object();
        ISSUE_MAP_KEY = Key.create((String)(AndroidLintInspectionBase.class.getName() + ".ISSUE_MAP"));
        DYNAMIC_TOOLS_KEY = Key.create((String)(AndroidLintInspectionBase.class.getName() + ".DYNAMIC_TOOLS"));
    }

    private static class NonTextFileProblemDescriptor
    implements ProblemDescriptor {
        private final PsiFileSystemItem myFile;
        private final String myMessage;
        private final LocalQuickFix[] myFixes;
        private ProblemGroup myGroup;

        private NonTextFileProblemDescriptor(@NotNull PsiFileSystemItem file, @NotNull String message, @NotNull LocalQuickFix[] fixes) {
            this.myFile = file;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myFile;
        }

        public PsiElement getStartElement() {
            return this.myFile;
        }

        public PsiElement getEndElement() {
            return this.myFile;
        }

        public TextRange getTextRangeInElement() {
            return new TextRange(0, 0);
        }

        public int getLineNumber() {
            return 0;
        }

        @NotNull
        public ProblemHighlightType getHighlightType() {
            return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        @Nullable
        public ProblemGroup getProblemGroup() {
            return this.myGroup;
        }

        public void setProblemGroup(@Nullable ProblemGroup problemGroup) {
            this.myGroup = problemGroup;
        }

        public boolean showTooltip() {
            return false;
        }

        @NotNull
        public String getDescriptionTemplate() {
            return this.myMessage;
        }

        @Nullable
        public QuickFix[] getFixes() {
            return this.myFixes;
        }
    }

    static class MyLocalQuickFix
    extends InspectionGadgetsFix {
        private final LintIdeQuickFix myLintQuickFix;

        MyLocalQuickFix(@NotNull LintIdeQuickFix lintQuickFix) {
            this.myLintQuickFix = lintQuickFix;
        }

        @NotNull
        public String getName() {
            return this.myLintQuickFix.getName();
        }

        @NotNull
        public String getFamilyName() {
            String familyName = this.myLintQuickFix.getFamilyName();
            if (familyName != null) {
                return familyName;
            }
            return this.myLintQuickFix.getName();
        }

        protected void doFix(Project project, ProblemDescriptor descriptor) {
            this.myLintQuickFix.apply(descriptor.getStartElement(), descriptor.getEndElement(), AndroidQuickfixContexts.BatchContext.getInstance());
        }

        public boolean startInWriteAction() {
            return this.myLintQuickFix.startInWriteAction();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            return currentFile;
        }
    }

    static class RemoteAttributeFix
    extends DefaultLintQuickFix {
        private final LintFix.SetAttribute myData;

        RemoteAttributeFix(LintFix.SetAttribute data) {
            super(data.getDisplayName(), data.getFamilyName());
            this.myData = data;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            XmlAttribute attribute = this.findAttribute(startElement);
            if (attribute != null && attribute.isValid()) {
                attribute.delete();
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            XmlAttribute attribute = this.findAttribute(startElement);
            return attribute != null && attribute.isValid();
        }

        @Nullable
        private XmlAttribute findAttribute(@NotNull PsiElement startElement) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            if (tag == null) {
                return null;
            }
            return this.myData.getNamespace() != null ? tag.getAttribute(this.myData.getAttribute(), this.myData.getNamespace()) : tag.getAttribute(this.myData.getAttribute());
        }
    }

    static class CompositeLintFix
    extends DefaultLintQuickFix {
        private final LintIdeQuickFix[] myFixes;

        CompositeLintFix(String displayName, String familyName, LintIdeQuickFix[] myFixes) {
            super(displayName != null ? displayName : "Fix", familyName);
            this.myFixes = myFixes;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            for (LintIdeQuickFix fix : this.myFixes) {
                fix.apply(startElement, endElement, context);
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            for (LintIdeQuickFix fix : this.myFixes) {
                if (fix.isApplicable(startElement, endElement, contextType)) continue;
                return false;
            }
            return true;
        }
    }

    private static class LintInspectionFactory
    extends GlobalInspectionToolWrapper {
        private final AndroidLintInspectionBase myInspection;

        private LintInspectionFactory(AndroidLintInspectionBase inspection) {
            super((GlobalInspectionTool)inspection);
            this.myInspection = inspection;
        }

        public boolean isEnabledByDefault() {
            return this.myInspection.isEnabledByDefault();
        }

        @NotNull
        public GlobalInspectionToolWrapper createCopy() {
            return new LintInspectionFactory(AndroidLintInspectionBase.createInspection(this.myInspection.myIssue));
        }
    }
}

