/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.ui;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.ui.TerminalWidgetListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalView;

public class TerminalContainer {
    private static final Logger LOG = Logger.getInstance(TerminalContainer.class);
    private final Content myContent;
    private final JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final TerminalView myTerminalView;
    private JPanel myPanel;
    private boolean myForceHideUiWhenSessionEnds = false;
    private final TerminalWidgetListener myListener;

    public TerminalContainer(@NotNull Project project, @NotNull Content content, @NotNull JBTerminalWidget terminalWidget, @NotNull TerminalView terminalView) {
        this.myProject = project;
        this.myContent = content;
        this.myTerminalWidget = terminalWidget;
        this.myTerminalView = terminalView;
        this.myPanel = TerminalContainer.createPanel(terminalWidget);
        this.myListener = widget -> ApplicationManager.getApplication().invokeLater(() -> this.processSessionCompleted(), this.myProject.getDisposed());
        terminalWidget.addListener(this.myListener);
        terminalView.register(this);
        Disposer.register((Disposable)content, () -> this.cleanup());
    }

    @NotNull
    public JBTerminalWidget getTerminalWidget() {
        return this.myTerminalWidget;
    }

    @NotNull
    public Content getContent() {
        return this.myContent;
    }

    public void closeAndHide() {
        this.myForceHideUiWhenSessionEnds = true;
        if (this.myTerminalWidget.getTtyConnector().isConnected()) {
            this.myTerminalWidget.close();
        } else {
            this.processSessionCompleted();
        }
    }

    @NotNull
    private static JPanel createPanel(@NotNull JBTerminalWidget terminalWidget) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(null);
        panel.setFocusable(false);
        panel.add((Component)terminalWidget.getComponent(), "Center");
        return panel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    public void split(boolean vertically, @NotNull JBTerminalWidget newTerminalWidget) {
        boolean hasFocus = this.myTerminalWidget.getTerminalPanel().hasFocus();
        JPanel parent = this.myPanel;
        parent.remove(this.myTerminalWidget.getComponent());
        this.myPanel = TerminalContainer.createPanel(this.myTerminalWidget);
        Splitter splitter = TerminalContainer.createSplitter(vertically);
        splitter.setFirstComponent((JComponent)this.myPanel);
        TerminalContainer newContainer = new TerminalContainer(this.myProject, this.myContent, newTerminalWidget, this.myTerminalView);
        splitter.setSecondComponent(newContainer.getComponent());
        parent.add((Component)splitter, "Center");
        parent.revalidate();
        if (hasFocus) {
            this.requestFocus(this.myTerminalWidget);
        }
    }

    @NotNull
    private static Splitter createSplitter(boolean vertically) {
        OnePixelSplitter splitter = new OnePixelSplitter(vertically, 0.5f, 0.1f, 0.9f);
        splitter.setDividerWidth(JBUI.scale((int)1));
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color color = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        if (color != null) {
            splitter.getDivider().setBackground(color);
        }
        return splitter;
    }

    private void processSessionCompleted() {
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            JBTerminalWidget nextToFocus = null;
            if (this.myTerminalWidget.getTerminalPanel().hasFocus()) {
                nextToFocus = this.getNextSplitTerminal(true);
            }
            Splitter splitter = (Splitter)parent;
            parent = parent.getParent();
            JComponent otherComponent = this.myPanel.equals(splitter.getFirstComponent()) ? splitter.getSecondComponent() : splitter.getFirstComponent();
            Component realComponent = TerminalContainer.unwrapComponent(otherComponent);
            if (realComponent instanceof JBTerminalWidget) {
                TerminalContainer otherContainer = this.myTerminalView.getContainer((JBTerminalWidget)realComponent);
                otherContainer.myPanel = (JPanel)parent;
            }
            realComponent.getParent().remove(realComponent);
            parent.remove((Component)splitter);
            parent.add(realComponent, "Center");
            parent.revalidate();
            if (nextToFocus != null) {
                this.requestFocus(nextToFocus);
            }
            this.cleanup();
            Disposer.dispose((Disposable)this.myTerminalWidget);
        } else {
            this.processSingleTerminalCompleted();
        }
    }

    private void cleanup() {
        this.myTerminalWidget.removeListener(this.myListener);
        this.myTerminalView.unregister(this);
    }

    private void processSingleTerminalCompleted() {
        if (this.myForceHideUiWhenSessionEnds || TerminalOptionsProvider.getInstance().getCloseSessionOnLogout()) {
            this.myTerminalView.closeTab(this.myContent);
        } else {
            String text = TerminalContainer.getSessionCompletedMessage(this.myTerminalWidget);
            this.myTerminalWidget.writePlainMessage("\n" + text + "\n");
            this.myTerminalWidget.getTerminalPanel().setCursorVisible(false);
        }
    }

    @NotNull
    @Nls
    private static String getSessionCompletedMessage(@NotNull JBTerminalWidget widget) {
        String text = "[" + TerminalBundle.message("session.terminated.text", new Object[0]) + "]";
        ProcessTtyConnector connector = ShellTerminalWidget.getProcessTtyConnector(widget.getTtyConnector());
        if (connector != null) {
            Integer exitCode = null;
            try {
                exitCode = connector.getProcess().exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            return text + "\n[" + IdeCoreBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{exitCode != null ? exitCode : "unknown"}) + "]";
        }
        return text;
    }

    public boolean isSplitTerminal() {
        return this.findRootSplitter() != null;
    }

    @Nullable
    public JBTerminalWidget getNextSplitTerminal(boolean forward) {
        List<JBTerminalWidget> terminals = this.listTerminals();
        int ind = terminals.indexOf(this.myTerminalWidget);
        if (ind < 0) {
            LOG.error("All split terminal list (" + terminals.size() + ") doesn't contain this terminal");
            return null;
        }
        if (terminals.size() == 1) {
            return null;
        }
        int newInd = (ind + (forward ? 1 : terminals.size() - 1)) % terminals.size();
        return terminals.get(newInd);
    }

    @NotNull
    private List<JBTerminalWidget> listTerminals() {
        Splitter rootSplitter = this.findRootSplitter();
        if (rootSplitter == null) {
            return Collections.singletonList(this.myTerminalWidget);
        }
        ArrayList<JBTerminalWidget> terminals = new ArrayList<JBTerminalWidget>();
        this.traverseSplitters(rootSplitter, terminals);
        return terminals;
    }

    private void traverseSplitters(@NotNull Splitter splitter, @NotNull List<JBTerminalWidget> terminals) {
        this.traverseParentPanel(splitter.getFirstComponent(), terminals);
        this.traverseParentPanel(splitter.getSecondComponent(), terminals);
    }

    private void traverseParentPanel(@NotNull JComponent parentPanel, @NotNull List<JBTerminalWidget> terminals) {
        Component[] components = parentPanel.getComponents();
        if (components.length == 1) {
            Component c = components[0];
            if (c instanceof Splitter) {
                this.traverseSplitters((Splitter)c, terminals);
            } else if (c instanceof JBTerminalWidget) {
                terminals.add((JBTerminalWidget)c);
            }
        }
    }

    @Nullable
    private Splitter findRootSplitter() {
        Splitter splitter = (Splitter)ObjectUtils.tryCast((Object)this.myPanel.getParent(), Splitter.class);
        while (splitter != null) {
            Splitter parentSplitter;
            Container panel = splitter.getParent();
            Splitter splitter2 = parentSplitter = panel != null ? (Splitter)ObjectUtils.tryCast((Object)panel.getParent(), Splitter.class) : null;
            if (parentSplitter != null) {
                splitter = parentSplitter;
                continue;
            }
            return splitter;
        }
        return null;
    }

    @NotNull
    private static Component unwrapComponent(@NotNull JComponent component) {
        Component c;
        Object[] components = component.getComponents();
        if (components.length == 1 && ((c = components[0]) instanceof JBTerminalWidget || c instanceof Splitter)) {
            return c;
        }
        LOG.error("Cannot unwrap " + component + ", children: " + Arrays.toString(components));
        return component;
    }

    public void requestFocus(@NotNull JBTerminalWidget terminal) {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)terminal.getTerminalPanel(), true);
    }
}

