/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalWidget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalRunner;

public class TerminalHandlerImpl
extends TerminalHandlerBase {
    private final JBTerminalWidget myTerminalWidget;
    private final JBTerminalPanel myTerminalPanel;
    private final KeyAdapter myCopyActionKeyListener;

    public TerminalHandlerImpl(@NotNull String presentableName, @NotNull Project project, @NotNull InputStream terminalOutput, @NotNull OutputStream terminalInput, boolean deferTerminalSessionUntilFirstShown) {
        super(presentableName);
        CloudTerminalProcess process = new CloudTerminalProcess(terminalInput, terminalOutput);
        TerminalListener.TtyResizeHandler handlerBoundLater = (w, h) -> this.getResizeHandler().onTtyResizeRequest(w, h);
        CloudTerminalRunner terminalRunner = new CloudTerminalRunner(project, presentableName, process, handlerBoundLater, deferTerminalSessionUntilFirstShown);
        this.myTerminalWidget = terminalRunner.createTerminalWidget((Disposable)project, (String)null);
        this.myTerminalPanel = this.myTerminalWidget.getTerminalPanel();
        this.myCopyActionKeyListener = new MyCopyActionKeyListener();
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getPreferredFocusableComponent();
    }

    public void dispose() {
        super.dispose();
        this.myTerminalPanel.removeCustomKeyListener((KeyListener)this.myCopyActionKeyListener);
    }

    public void close() {
        this.myTerminalWidget.getTerminalDisplay().setCursorVisible(false);
        this.myTerminalWidget.stop();
        this.myTerminalPanel.addCustomKeyListener((KeyListener)this.myCopyActionKeyListener);
        super.close();
    }

    private class MyCopyActionKeyListener
    extends KeyAdapter {
        private MyCopyActionKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            String copyActionName = TerminalHandlerImpl.this.myTerminalWidget.getSettingsProvider().getCopyActionPresentation().getName();
            TerminalHandlerImpl.this.myTerminalPanel.getActions().stream().filter(a -> a.getName().equals(copyActionName)).findFirst().ifPresent(a -> {
                if (a.matches(e) && a.isEnabled(e)) {
                    a.actionPerformed(e);
                }
            });
        }
    }
}

