/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.jediterm.terminal.ProcessTtyConnector;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.ProcessInfoUtil;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;

public class TerminalWorkingDirectoryManager {
    private static final Logger LOG = Logger.getInstance(TerminalWorkingDirectoryManager.class);
    private static final int MERGE_WAIT_MILLIS = 500;
    private static final int FETCH_WAIT_MILLIS = 2000;
    private static final Key<String> INITIAL_CWD_KEY = Key.create((String)"initial cwd");
    private final Map<Content, Data> myDataByContentMap = new HashMap<Content, Data>();

    TerminalWorkingDirectoryManager() {
    }

    @Nullable
    String getWorkingDirectory(@NotNull Content content) {
        Data data = this.getData(content);
        return data != null ? data.myWorkingDirectory : null;
    }

    void init(@NotNull ToolWindow terminalToolWindow) {
        ContentManager contentManager = terminalToolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            this.watchTab(content);
        }
        contentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                TerminalWorkingDirectoryManager.this.watchTab(event.getContent());
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                TerminalWorkingDirectoryManager.this.unwatchTab(event.getContent());
            }
        });
    }

    private void watchTab(final @NotNull Content content) {
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)content);
        final AtomicReference<Data> dataRef = new AtomicReference<Data>();
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && TerminalArrangementManager.isAvailable()) {
                    alarm.cancelAllRequests();
                    if (!alarm.isDisposed()) {
                        alarm.addRequest(() -> TerminalWorkingDirectoryManager.updateWorkingDirectory(content, (Data)dataRef.get()), 500);
                    }
                }
            }
        };
        Data data = new Data(listener, content.getDisplayName());
        data.myWorkingDirectory = (String)content.getUserData(INITIAL_CWD_KEY);
        content.putUserData(INITIAL_CWD_KEY, null);
        dataRef.set(data);
        JBTerminalWidget widget = Objects.requireNonNull(TerminalView.getWidgetByContent(content));
        widget.getTerminalPanel().addCustomKeyListener((KeyListener)listener);
        Disposer.register((Disposable)content, () -> widget.getTerminalPanel().removeCustomKeyListener((KeyListener)listener));
        this.myDataByContentMap.put(content, data);
    }

    private static void updateWorkingDirectory(@NotNull Content content, @NotNull Data data) {
        JBTerminalWidget widget = TerminalView.getWidgetByContent(content);
        if (widget != null) {
            data.myWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget, data.myContentName);
        }
    }

    @Nullable
    public static String getWorkingDirectory(@NotNull JBTerminalWidget widget, @Nullable String name) {
        ProcessTtyConnector connector = ShellTerminalWidget.getProcessTtyConnector(widget.getTtyConnector());
        if (connector == null) {
            return null;
        }
        try {
            long startNano = System.nanoTime();
            Future<String> cwd = ProcessInfoUtil.getCurrentWorkingDirectory(connector.getProcess());
            String result = cwd.get(2000L, TimeUnit.MILLISECONDS);
            boolean exists = TerminalWorkingDirectoryManager.checkDirectory(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cwd (" + result + ", exists=" + exists + ") fetched in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
            }
            return exists ? result : null;
        }
        catch (InterruptedException startNano) {
        }
        catch (ExecutionException e) {
            String message = "Failed to fetch cwd for " + name;
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            } else {
                LOG.warn(message + ": " + e.getCause().getMessage());
            }
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout fetching cwd for " + name, (Throwable)e);
        }
        return null;
    }

    private static boolean checkDirectory(@Nullable String directory) {
        if (directory == null) {
            return false;
        }
        try {
            Path path = Path.of(directory, new String[0]);
            return path.isAbsolute() && Files.isDirectory(path, new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    private void unwatchTab(@NotNull Content content) {
        Data data = this.getData(content);
        if (data != null) {
            this.myDataByContentMap.remove(content);
            JBTerminalWidget widget = TerminalView.getWidgetByContent(content);
            if (widget != null) {
                widget.getTerminalPanel().removeCustomKeyListener(data.myKeyListener);
            }
        }
    }

    @Nullable
    private Data getData(@NotNull Content content) {
        Data data = this.myDataByContentMap.get(content);
        if (data == null) {
            LOG.error("No associated data");
        }
        return data;
    }

    public static void setInitialWorkingDirectory(@NotNull Content content, @Nullable String directory) {
        content.putUserData(INITIAL_CWD_KEY, (Object)directory);
    }

    private static final class Data {
        private final KeyListener myKeyListener;
        private final String myContentName;
        private volatile String myWorkingDirectory;

        private Data(@NotNull KeyListener keyListener, @Nullable String contentName) {
            this.myKeyListener = keyListener;
            this.myContentName = contentName;
        }

        public String toString() {
            return this.myContentName + ", cwd: " + this.myWorkingDirectory;
        }
    }
}

