/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.google.common.util.concurrent.Futures;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.pty4j.windows.WinPtyProcess;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessInfoUtil {
    private static final Logger LOG = Logger.getInstance(ProcessInfoUtil.class);
    private static final int TIMEOUT_MILLIS = 2000;
    private static final ExecutorService POOL = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Terminal CWD", (int)1);

    private ProcessInfoUtil() {
    }

    @NotNull
    public static Future<String> getCurrentWorkingDirectory(@NotNull Process process) {
        if (process.isAlive()) {
            return POOL.submit(() -> ProcessInfoUtil.doGetCwd(process));
        }
        return Futures.immediateFuture(null);
    }

    @Nullable
    private static String doGetCwd(@NotNull Process process) throws Exception {
        if (SystemInfo.isUnix) {
            int pid = OSProcessUtil.getProcessID((Process)process);
            String result = ProcessInfoUtil.tryGetCwdFastOnUnix(pid);
            if (result != null) {
                return result;
            }
            return ProcessInfoUtil.getCwdOnUnix(pid);
        }
        if (SystemInfo.isWindows) {
            if (process instanceof WinPtyProcess) {
                return ((WinPtyProcess)process).getWorkingDirectory();
            }
            if (process instanceof WinConPtyProcess) {
                return ((WinConPtyProcess)process).getWorkingDirectory();
            }
            throw new IllegalStateException("Cwd cannot be fetched for " + process.getClass());
        }
        throw new IllegalStateException("Unsupported OS: " + SystemInfo.OS_NAME);
    }

    @Nullable
    private static String tryGetCwdFastOnUnix(int pid) {
        block3: {
            String procPath = "/proc/" + pid + "/cwd";
            try {
                File dir = Paths.get(procPath, new String[0]).toRealPath(new LinkOption[0]).toFile();
                if (dir.isDirectory()) {
                    return dir.getAbsolutePath();
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Cannot resolve cwd from " + procPath + ", fallback to lsof -a -d cwd -p " + pid, (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static String getCwdOnUnix(int pid) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"lsof", "-a", "-d", "cwd", "-p", String.valueOf(pid), "-Fn"});
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)new OSProcessHandler(commandLine));
        ProcessOutput output = runner.runProcess(2000);
        if (output.isTimeout()) {
            throw new ExecutionException("Timeout running " + commandLine.getCommandLineString());
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException("Exit code " + output.getExitCode() + " for " + commandLine.getCommandLineString());
        }
        String workingDir = ProcessInfoUtil.parseWorkingDirectory(output.getStdoutLines(), pid);
        if (workingDir == null) {
            throw new ExecutionException("Cannot parse working directory from " + commandLine.getCommandLineString());
        }
        return workingDir;
    }

    @Nullable
    private static String parseWorkingDirectory(@NotNull List<String> stdoutLines, int pid) {
        boolean pidEncountered = false;
        for (String line : stdoutLines) {
            if (line.startsWith("p")) {
                int p = StringUtil.parseInt((String)line.substring(1), (int)-1);
                pidEncountered |= p == pid;
                continue;
            }
            if (!pidEncountered || !line.startsWith("n")) continue;
            return line.substring(1);
        }
        return null;
    }
}

