/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsConfigurable;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.ui.OpenPredefinedTerminalActionProvider;

public class TerminalNewPredefinedSessionAction
extends DumbAwareAction {
    private final PopupState<JBPopup> myPopupState = PopupState.forPopup();

    public TerminalNewPredefinedSessionAction() {
        super(TerminalBundle.messagePointer("action.NewPredefinedSession.label", new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.Toolbar.Expand);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || this.myPopupState.isRecentlyHidden()) {
            return;
        }
        RelativePoint popupPoint = TerminalNewPredefinedSessionAction.getPreferredPopupPoint(e);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<OpenShellAction> shells = TerminalNewPredefinedSessionAction.detectShells();
            List<OpenShellAction> wsl = TerminalNewPredefinedSessionAction.listOpenWslShellActions();
            List<AnAction> customActions = OpenPredefinedTerminalActionProvider.collectAll(project);
            ApplicationManager.getApplication().invokeLater(() -> {
                ListPopup popup = TerminalNewPredefinedSessionAction.createPopup(shells, wsl, customActions, e.getDataContext());
                if (popupPoint != null) {
                    popup.show(popupPoint);
                } else {
                    popup.showInFocusCenter();
                }
                this.myPopupState.prepareToShow((Object)popup);
            }, project.getDisposed());
        });
    }

    @Nullable
    private static RelativePoint getPreferredPopupPoint(@NotNull AnActionEvent e) {
        Component comp;
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent && (comp = inputEvent.getComponent()) instanceof AnActionHolder) {
            return new RelativePoint((Component)comp.getParent(), new Point(comp.getX() + JBUI.scale((int)3), comp.getY() + comp.getHeight() + JBUI.scale((int)3)));
        }
        return null;
    }

    @NotNull
    private static ListPopup createPopup(@NotNull List<OpenShellAction> shells, @NotNull List<OpenShellAction> wsl, @NotNull List<AnAction> customActions, @NotNull DataContext dataContext) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.addAll(shells);
        group.addAll(wsl);
        group.addAll(customActions);
        if (shells.size() + wsl.size() + customActions.size() > 0) {
            group.addSeparator();
        }
        group.add((AnAction)new TerminalSettingsAction());
        return JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, false, true, true, null, -1, null);
    }

    @NotNull
    private static List<OpenShellAction> listOpenWslShellActions() {
        if (WSLDistribution.findWslExe() == null) {
            return List.of();
        }
        List distributions = WslDistributionManager.getInstance().getInstalledDistributions();
        return ContainerUtil.map((Collection)distributions, d -> new OpenShellAction(() -> d.getMsId(), List.of("wsl.exe", "-d", d.getMsId()), AllIcons.RunConfigurations.Wsl));
    }

    @NotNull
    private static List<OpenShellAction> detectShells() {
        ArrayList<OpenShellAction> actions = new ArrayList<OpenShellAction>();
        if (SystemInfo.isUnix) {
            ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create("/bin/bash", List.of(), "bash")));
            if (Files.exists(Path.of("/usr/local/bin/zsh", new String[0]), new LinkOption[0])) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create("/usr/local/bin/zsh", List.of(), "zsh")));
            } else {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create("/usr/bin/zsh", List.of(), "zsh")));
            }
            ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create("/usr/bin/fish", List.of(), "fish")));
        } else if (SystemInfo.isWindows) {
            File cmderInitBat;
            String cmderRoot;
            File gitBash;
            File pwsh;
            File cmd;
            File powershell = PathEnvironmentVariableUtil.findInPath((String)"powershell.exe");
            if (powershell != null && StringUtil.startsWithIgnoreCase((String)powershell.getAbsolutePath(), (String)"C:\\Windows\\System32\\WindowsPowerShell\\")) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(powershell.getAbsolutePath(), List.of(), "Windows PowerShell")));
            }
            if ((cmd = PathEnvironmentVariableUtil.findInPath((String)"cmd.exe")) != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(cmd.getAbsolutePath(), List.of(), "Command Prompt")));
            }
            if ((pwsh = PathEnvironmentVariableUtil.findInPath((String)"pwsh.exe")) != null && StringUtil.startsWithIgnoreCase((String)pwsh.getAbsolutePath(), (String)"C:\\Program Files\\PowerShell\\")) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(pwsh.getAbsolutePath(), List.of(), "PowerShell")));
            }
            if ((gitBash = new File("C:\\Program Files\\Git\\bin\\bash.exe")).isFile()) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(gitBash.getAbsolutePath(), List.of(), "Git Bash")));
            }
            if ((cmderRoot = EnvironmentUtil.getValue((String)"CMDER_ROOT")) != null && cmd != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\") && (cmderInitBat = new File(cmderRoot, "vendor\\init.bat")).isFile()) {
                ContainerUtil.addIfNotNull(actions, (Object)((Object)TerminalNewPredefinedSessionAction.create(cmd.getAbsolutePath(), List.of("/k", cmderInitBat.getAbsolutePath()), "Cmder")));
            }
        }
        return actions;
    }

    @Nullable
    private static OpenShellAction create(@NotNull String shellPath2, @NotNull List<String> shellOptions, @NlsSafe String presentableName) {
        if (Files.exists(Path.of(shellPath2, new String[0]), new LinkOption[0])) {
            return new OpenShellAction(() -> presentableName, ContainerUtil.concat(List.of(shellPath2), shellOptions), null);
        }
        return null;
    }

    private static class OpenShellAction
    extends DumbAwareAction {
        private final List<String> myCommand;
        private final Supplier<@NlsActions.ActionText String> myPresentableName;

        private OpenShellAction(@NotNull Supplier<@NlsActions.ActionText String> presentableName, @NotNull List<String> command, @Nullable Icon icon) {
            super(presentableName, icon);
            this.myPresentableName = presentableName;
            this.myCommand = command;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project != null) {
                LocalTerminalDirectRunner runner = new LocalTerminalDirectRunner(project){

                    @Override
                    @NotNull
                    public List<String> getInitialCommand(@NotNull Map<String, String> envs) {
                        return myCommand;
                    }
                };
                TerminalTabState tabState = new TerminalTabState();
                tabState.myTabName = this.myPresentableName.get();
                TerminalView.getInstance(project).createNewSession(runner, tabState);
            }
        }
    }

    private static class TerminalSettingsAction
    extends DumbAwareAction {
        private TerminalSettingsAction() {
            super(IdeBundle.message((String)"action.text.settings", (Object[])new Object[0]), null, AllIcons.General.Settings);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = e.getProject();
            if (project != null) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, TerminalOptionsConfigurable.class);
            }
        }
    }
}

