/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.ui.content.Content;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;
import org.jetbrains.plugins.terminal.vfs.TerminalEditorWidgetListener;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/action/MoveTerminalSessionToEditorAction;", "Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformedInTerminalToolWindow", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "updateInTerminalToolWindow", "intellij.terminal"})
final class MoveTerminalSessionToEditorAction
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    @Override
    public void updateInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content) {
        TerminalView terminalView = TerminalView.getInstance(project);
        JBTerminalWidget jBTerminalWidget = TerminalView.getWidgetByContent(content);
        Intrinsics.checkNotNull((Object)jBTerminalWidget);
        JBTerminalWidget terminalWidget = jBTerminalWidget;
        if (terminalView.isSplitTerminal(terminalWidget)) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Override
    public void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content) {
        TerminalView terminalView = TerminalView.getInstance(project);
        JBTerminalWidget jBTerminalWidget = TerminalView.getWidgetByContent(content);
        Intrinsics.checkNotNull((Object)jBTerminalWidget);
        JBTerminalWidget terminalWidget = jBTerminalWidget;
        TerminalSessionVirtualFileImpl file = new TerminalSessionVirtualFileImpl(content.getDisplayName(), terminalWidget, (SettingsProvider)terminalView.getTerminalRunner().getSettingsProvider());
        file.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, Boolean.TRUE);
        ArraysKt.first((Object[])FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, true));
        terminalWidget.setListener((JBTerminalWidgetListener)new TerminalEditorWidgetListener(project, file));
        terminalView.detachWidgetAndRemoveContent(content);
        file.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
    }
}

