/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.Sets;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.ui.TerminalPanelListener;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.DefaultTerminalRunnerFactory;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabLeftAction;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolWindowTabRightAction;
import org.jetbrains.plugins.terminal.action.RenameTerminalSessionAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.ui.TerminalContainer;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public final class TerminalView
implements Disposable {
    private static final Key<JBTerminalWidget> TERMINAL_WIDGET_KEY = new Key("TerminalWidget");
    private static final Logger LOG = Logger.getInstance(TerminalView.class);
    private static final Key<AbstractTerminalRunner<?>> RUNNER_KEY = Key.create((String)"RUNNER_KEY");
    private ToolWindow myToolWindow;
    private final Project myProject;
    private final AbstractTerminalRunner<?> myTerminalRunner;
    private TerminalDockContainer myDockContainer;
    private final Map<JBTerminalWidget, TerminalContainer> myContainerByWidgetMap = new HashMap<JBTerminalWidget, TerminalContainer>();
    private final List<Consumer<JBTerminalWidget>> myTerminalSetupHandlers = new CopyOnWriteArrayList<Consumer<JBTerminalWidget>>();

    @NotNull
    public AbstractTerminalRunner<?> getTerminalRunner() {
        return this.myTerminalRunner;
    }

    public ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    public TerminalView(@NotNull Project project) {
        this.myProject = project;
        this.myTerminalRunner = ((DefaultTerminalRunnerFactory)ApplicationManager.getApplication().getService(DefaultTerminalRunnerFactory.class)).create(project);
    }

    public void dispose() {
    }

    public Set<JBTerminalWidget> getWidgets() {
        return this.myContainerByWidgetMap.keySet();
    }

    public void addNewTerminalSetupHandler(@NotNull Consumer<JBTerminalWidget> listener, @NotNull Disposable parentDisposable) {
        this.myTerminalSetupHandlers.add(listener);
        if (!Disposer.tryRegister((Disposable)parentDisposable, () -> this.myTerminalSetupHandlers.remove(listener))) {
            this.myTerminalSetupHandlers.remove(listener);
        }
    }

    public static TerminalView getInstance(@NotNull Project project) {
        return (TerminalView)project.getService(TerminalView.class);
    }

    void initToolWindow(@NotNull ToolWindowEx toolWindow) {
        if (this.myToolWindow != null) {
            LOG.error("Terminal tool window already initialized");
            return;
        }
        this.myToolWindow = toolWindow;
        toolWindow.setTabActions(new AnAction[]{ActionManager.getInstance().getAction("TerminalToolwindowActionGroup")});
        toolWindow.setTabDoubleClickActions(Collections.singletonList(new RenameTerminalSessionAction()));
        this.myProject.getMessageBus().connect(toolWindow.getDisposable()).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                if ("Terminal".equals(toolWindow.getId()) && TerminalView.this.myToolWindow == toolWindow && toolWindow.isVisible() && toolWindow.getContentManager().isEmpty()) {
                    TerminalView.this.createNewSession(TerminalView.this.myTerminalRunner, null, true, true);
                }
            }
        });
        if (this.myDockContainer == null) {
            this.myDockContainer = new TerminalDockContainer();
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer, toolWindow.getDisposable());
        }
    }

    void restoreTabs(@Nullable TerminalArrangementState arrangementState) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        if (arrangementState != null) {
            for (TerminalTabState tabState : arrangementState.myTabStates) {
                this.createNewSession(this.myTerminalRunner, tabState, false, true);
            }
            Content content = contentManager.getContent(arrangementState.mySelectedTabIndex);
            if (content != null) {
                contentManager.setSelectedContent(content);
            }
        }
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner) {
        this.createNewSession(terminalRunner, null);
    }

    public void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState) {
        this.createNewSession(terminalRunner, tabState, true);
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName) {
        return this.createLocalShellWidget(workingDirectory, tabName, true, true);
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus) {
        return this.createLocalShellWidget(workingDirectory, tabName, requestFocus, true);
    }

    @NotNull
    public ShellTerminalWidget createLocalShellWidget(@Nullable String workingDirectory, @Nullable @Nls String tabName, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        TerminalTabState tabState = new TerminalTabState();
        tabState.myTabName = tabName;
        tabState.myWorkingDirectory = workingDirectory;
        JBTerminalWidget widget = this.createNewSession(this.myTerminalRunner, tabState, requestFocus, deferSessionStartUntilUiShown);
        return (ShellTerminalWidget)Objects.requireNonNull(widget);
    }

    private void createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, boolean requestFocus) {
        this.createNewSession(terminalRunner, tabState, requestFocus, true);
    }

    @NotNull
    private JBTerminalWidget createNewSession(@NotNull AbstractTerminalRunner<?> terminalRunner, @Nullable TerminalTabState tabState, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        ToolWindow toolWindow = this.getOrInitToolWindow();
        Content content = this.createNewTab(null, terminalRunner, toolWindow, tabState, requestFocus, deferSessionStartUntilUiShown);
        return Objects.requireNonNull(TerminalView.getWidgetByContent(content));
    }

    @NotNull
    private ToolWindow getOrInitToolWindow() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Terminal");
            Objects.requireNonNull(toolWindow).getContentManager();
            LOG.assertTrue(toolWindow == this.myToolWindow);
        }
        return toolWindow;
    }

    @NotNull
    public Content newTab(@NotNull ToolWindow toolWindow, @Nullable JBTerminalWidget terminalWidget) {
        return this.createNewTab(terminalWidget, this.myTerminalRunner, toolWindow, null, true, true);
    }

    @NotNull
    private Content createNewTab(@Nullable JBTerminalWidget terminalWidget, @NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable TerminalTabState tabState, boolean requestFocus, boolean deferSessionStartUntilUiShown) {
        Content content = this.createTerminalContent(terminalRunner, toolWindow, terminalWidget, tabState, deferSessionStartUntilUiShown);
        content.putUserData(RUNNER_KEY, terminalRunner);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
        new TerminalTabCloseListener(content, this.myProject, this);
        Runnable selectRunnable = () -> contentManager.setSelectedContent(content, requestFocus);
        if (requestFocus && !toolWindow.isActive()) {
            LOG.info("Activating " + toolWindow.getId() + " tool window");
            toolWindow.activate(selectRunnable, true, true);
        } else {
            selectRunnable.run();
        }
        return content;
    }

    @Nls
    private static String generateUniqueName(@Nls String suggestedName, List<@Nls String> tabs) {
        HashSet names = Sets.newHashSet(tabs);
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !names.contains(o));
    }

    @NotNull
    private Content createTerminalContent(@NotNull AbstractTerminalRunner<?> terminalRunner, @NotNull ToolWindow toolWindow, @Nullable JBTerminalWidget terminalWidget, final @Nullable TerminalTabState tabState, boolean deferSessionStartUntilUiShown) {
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel(PropertiesComponent.getInstance((Project)this.myProject), toolWindow);
        String tabName = (String)ObjectUtils.notNull((Object)(tabState != null ? tabState.myTabName : null), (Object)TerminalOptionsProvider.getInstance().getTabName());
        Content content = ContentFactory.getInstance().createContent((JComponent)((Object)panel), tabName, false);
        if (terminalWidget == null) {
            String currentWorkingDir = terminalRunner.getCurrentWorkingDir(tabState);
            terminalWidget = terminalRunner.createTerminalWidget((Disposable)content, currentWorkingDir, deferSessionStartUntilUiShown);
            TerminalArrangementManager.getInstance(this.myProject).assignCommandHistoryFile(terminalWidget, tabState);
            TerminalWorkingDirectoryManager.setInitialWorkingDirectory(content, currentWorkingDir);
        } else {
            terminalWidget.moveDisposable((Disposable)content);
        }
        if (tabState != null && tabState.myTabName != null && tabState.myIsUserDefinedTabTitle) {
            terminalWidget.getTerminalTitle().change((Function1)new Function1<TerminalTitle.State, Unit>(){

                public Unit invoke(TerminalTitle.State state) {
                    state.setUserDefinedTitle(tabState.myTabName);
                    return null;
                }
            });
        }
        this.setupTerminalWidget(toolWindow, terminalWidget, tabState, content, true);
        content.setCloseable(true);
        content.putUserData(TERMINAL_WIDGET_KEY, (Object)terminalWidget);
        TerminalContainer container = new TerminalContainer(this.myProject, content, terminalWidget, this);
        panel.setContent(container.getComponent());
        panel.addFocusListener(TerminalView.createFocusListener(toolWindow));
        JBTerminalWidget finalTerminalWidget = terminalWidget;
        this.myTerminalSetupHandlers.forEach(consumer -> consumer.accept(finalTerminalWidget));
        panel.updateDFState();
        TerminalView.updatePreferredFocusableComponent(content, terminalWidget);
        return content;
    }

    private void setupTerminalWidget(final @NotNull ToolWindow toolWindow, final @NotNull JBTerminalWidget terminalWidget, final @Nullable TerminalTabState tabState, final @NotNull Content content, final boolean updateContentDisplayName) {
        final MoveTerminalToolWindowTabLeftAction moveTabLeftAction = new MoveTerminalToolWindowTabLeftAction();
        final MoveTerminalToolWindowTabRightAction moveTabRightAction = new MoveTerminalToolWindowTabRightAction();
        terminalWidget.getTerminalTitle().addTitleListener(new TerminalTitleListener(){

            public void onTitleChanged(@NotNull TerminalTitle terminalTitle) {
                ApplicationManager.getApplication().invokeLater(() -> TerminalView.updateTabTitle(terminalTitle, toolWindow, content), TerminalView.this.myProject.getDisposed());
            }
        }, (Disposable)content);
        terminalWidget.setTerminalPanelListener(new TerminalPanelListener(){

            public void onPanelResize(@NotNull RequestOrigin origin) {
            }

            public void onTitleChanged(@NlsSafe String title) {
                if (AdvancedSettings.getBoolean((String)"terminal.show.application.title")) {
                    TerminalTitle terminalTitle = terminalWidget.getTerminalTitle();
                    terminalTitle.change(terminalTitleState -> {
                        terminalTitleState.setApplicationTitle(title);
                        return null;
                    });
                }
            }
        });
        terminalWidget.setListener(new JBTerminalWidgetListener(){

            public void onNewSession() {
                TerminalView.this.newTab(toolWindow, null);
            }

            public void onTerminalStarted() {
                if (updateContentDisplayName && (tabState == null || StringUtil.isEmpty((String)tabState.myTabName))) {
                    TerminalView.updateTabTitle(terminalWidget.getTerminalTitle(), toolWindow, content);
                }
            }

            public void onPreviousTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectPreviousContent();
                }
            }

            public void onNextTabSelected() {
                if (toolWindow.getContentManager().getContentCount() > 1) {
                    toolWindow.getContentManager().selectNextContent();
                }
            }

            public void onSessionClosed() {
                TerminalView.this.getContainer(terminalWidget).closeAndHide();
            }

            public void showTabs() {
                ShowContentAction action = new ShowContentAction(toolWindow, toolWindow.getComponent(), (Disposable)toolWindow.getContentManager());
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)toolWindow.getComponent());
                KeyEvent fakeKeyEvent = new KeyEvent(toolWindow.getComponent(), 1001, System.currentTimeMillis(), 0, 0, '\u0000');
                AnActionEvent event = AnActionEvent.createFromInputEvent((InputEvent)fakeKeyEvent, (String)"unknown", null, (DataContext)dataContext);
                action.actionPerformed(event);
            }

            public void moveTabRight() {
                moveTabRightAction.move(content, TerminalView.this.myProject);
            }

            public void moveTabLeft() {
                moveTabLeftAction.move(content, TerminalView.this.myProject);
            }

            public boolean canMoveTabRight() {
                return moveTabRightAction.isAvailable(content);
            }

            public boolean canMoveTabLeft() {
                return moveTabLeftAction.isAvailable(content);
            }

            public boolean canSplit(boolean vertically) {
                return true;
            }

            public void split(boolean vertically) {
                TerminalView.this.split(terminalWidget, vertically);
            }

            public boolean isGotoNextSplitTerminalAvailable() {
                return TerminalView.this.isSplitTerminal(terminalWidget);
            }

            public void gotoNextSplitTerminal(boolean forward) {
                TerminalView.this.gotoNextSplitTerminal(terminalWidget, forward);
            }
        });
        terminalWidget.getTerminalPanel().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TerminalView.updatePreferredFocusableComponent(content, terminalWidget);
            }
        });
    }

    private static void updateTabTitle(@NotNull TerminalTitle terminalTitle, @NotNull ToolWindow toolWindow, @NotNull Content content) {
        String title = terminalTitle.buildTitle();
        ArrayList contents = ContainerUtil.newArrayList((Object[])toolWindow.getContentManager().getContents());
        contents.remove(content);
        content.setDisplayName(TerminalView.generateUniqueName(title, ContainerUtil.map((Collection)contents, c -> c.getDisplayName())));
    }

    private static void updatePreferredFocusableComponent(@NotNull Content content, @NotNull JBTerminalWidget terminalWidget) {
        content.setPreferredFocusableComponent(terminalWidget.getPreferredFocusableComponent());
    }

    public boolean isSplitTerminal(@NotNull JBTerminalWidget widget) {
        TerminalContainer container = this.getContainer(widget);
        return container.isSplitTerminal();
    }

    public void gotoNextSplitTerminal(@NotNull JBTerminalWidget widget, boolean forward) {
        TerminalContainer container = this.getContainer(widget);
        JBTerminalWidget next = container.getNextSplitTerminal(forward);
        if (next != null) {
            container.requestFocus(next);
        }
    }

    public void split(@NotNull JBTerminalWidget widget, boolean vertically) {
        TerminalContainer container = this.getContainer(widget);
        String workingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget, container.getContent().getDisplayName());
        JBTerminalWidget newWidget = this.myTerminalRunner.createTerminalWidget((Disposable)container.getContent(), workingDirectory, true);
        this.setupTerminalWidget(this.myToolWindow, newWidget, null, container.getContent(), false);
        container.split(!vertically, newWidget);
    }

    public void register(@NotNull TerminalContainer terminalContainer) {
        this.myContainerByWidgetMap.put(terminalContainer.getTerminalWidget(), terminalContainer);
    }

    public void unregister(@NotNull TerminalContainer terminalContainer) {
        this.myContainerByWidgetMap.remove(terminalContainer.getTerminalWidget());
        if (TerminalView.getWidgetByContent(terminalContainer.getContent()) == terminalContainer.getTerminalWidget()) {
            terminalContainer.getContent().putUserData(TERMINAL_WIDGET_KEY, (Object)this.findWidgetForContent(terminalContainer.getContent()));
        }
    }

    @Nullable
    private JBTerminalWidget findWidgetForContent(@NotNull Content content) {
        JBTerminalWidget any = null;
        for (Map.Entry<JBTerminalWidget, TerminalContainer> entry : this.myContainerByWidgetMap.entrySet()) {
            JBTerminalWidget terminalWidget;
            if (entry.getValue().getContent() != content) continue;
            any = terminalWidget = entry.getKey();
            if (!terminalWidget.getTerminalPanel().hasFocus()) continue;
            return terminalWidget;
        }
        return any;
    }

    @NotNull
    public TerminalContainer getContainer(@NotNull JBTerminalWidget terminalWidget) {
        return Objects.requireNonNull(this.myContainerByWidgetMap.get(terminalWidget));
    }

    public void closeTab(@NotNull Content content) {
        this.myToolWindow.getContentManager().removeContent(content, true, true, true);
    }

    @NotNull
    private static FocusListener createFocusListener(final @NotNull ToolWindow toolWindow) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = TerminalView.getComponentToFocus(toolWindow);
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    @Nullable
    private static JComponent getComponentToFocus(@NotNull ToolWindow toolWindow) {
        Content selectedContent = toolWindow.getContentManager().getSelectedContent();
        if (selectedContent != null) {
            return selectedContent.getPreferredFocusableComponent();
        }
        return toolWindow.getComponent();
    }

    public void openTerminalIn(@Nullable VirtualFile fileToOpen) {
        VirtualFile parentDirectory;
        TerminalTabState state = new TerminalTabState();
        VirtualFile virtualFile = parentDirectory = fileToOpen != null && !fileToOpen.isDirectory() ? fileToOpen.getParent() : fileToOpen;
        if (parentDirectory != null) {
            state.myWorkingDirectory = parentDirectory.getPath();
        }
        this.createNewSession(this.myTerminalRunner, state);
    }

    @Nullable
    public static JBTerminalWidget getWidgetByContent(@NotNull Content content) {
        return (JBTerminalWidget)content.getUserData(TERMINAL_WIDGET_KEY);
    }

    @Nullable
    public static AbstractTerminalRunner<?> getRunnerByContent(@NotNull Content content) {
        return (AbstractTerminalRunner)content.getUserData(RUNNER_KEY);
    }

    public void detachWidgetAndRemoveContent(@NotNull Content content) {
        ContentManager contentManager = this.myToolWindow.getContentManager();
        LOG.assertTrue(contentManager.getIndexOfContent(content) >= 0, (Object)"Not a terminal content");
        TerminalTabCloseListener.Companion.executeContentOperationSilently(content, (Function0<Unit>)((Function0)() -> {
            contentManager.removeContent(content, true);
            return Unit.INSTANCE;
        }));
        content.putUserData(TERMINAL_WIDGET_KEY, null);
    }

    public static boolean isInTerminalToolWindow(@NotNull JBTerminalWidget widget) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)widget.getTerminalPanel());
        ToolWindow toolWindow = (ToolWindow)dataContext.getData(PlatformDataKeys.TOOL_WINDOW);
        return toolWindow != null && "Terminal".equals(toolWindow.getId());
    }

    private final class TerminalDockContainer
    implements DockContainer {
        private TerminalDockContainer() {
        }

        @NotNull
        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(TerminalView.this.myToolWindow.getComponent());
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
            return this.isTerminalSessionContent(content) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
        }

        public JComponent getContainerComponent() {
            return TerminalView.this.myToolWindow.getComponent();
        }

        public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
            if (this.isTerminalSessionContent(content)) {
                TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)((Object)content.getKey());
                String name = terminalFile.getName();
                Content newContent = TerminalView.this.newTab(TerminalView.this.myToolWindow, terminalFile.getTerminalWidget());
                newContent.setDisplayName(name);
            }
        }

        private boolean isTerminalSessionContent(@NotNull DockableContent<?> content) {
            return content.getKey() instanceof TerminalSessionVirtualFileImpl;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }
    }
}

