/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jediterm.terminal.ProcessTtyConnector;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.windows.WinPtyProcess;
import com.pty4j.windows.conpty.WinConPtyProcess;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TerminalUtil {
    private static final Logger LOG = Logger.getInstance(TerminalUtil.class);

    private TerminalUtil() {
    }

    public static boolean hasRunningCommands(@NotNull ProcessTtyConnector connector) throws IllegalStateException {
        Process process = connector.getProcess();
        if (!process.isAlive()) {
            return false;
        }
        if (process instanceof RemoteSshProcess) {
            return true;
        }
        if (SystemInfo.isUnix && process instanceof UnixPtyProcess) {
            int shellPid = OSProcessUtil.getProcessID((Process)process);
            MultiMap pidToChildPidsMap = MultiMap.create();
            UnixProcessManager.processPSOutput((String[])UnixProcessManager.getPSCmd((boolean)false, (boolean)false), s -> {
                StringTokenizer st = new StringTokenizer((String)s, " ");
                int parentPid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                pidToChildPidsMap.putValue((Object)parentPid, (Object)pid);
                return false;
            });
            return !pidToChildPidsMap.get((Object)shellPid).isEmpty();
        }
        if (SystemInfo.isWindows && process instanceof WinPtyProcess) {
            WinPtyProcess winPty = (WinPtyProcess)process;
            try {
                String executable = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)TerminalUtil.getExecutable(winPty)));
                int consoleProcessCount = winPty.getConsoleProcessCount();
                if (executable.endsWith("/Git/bin/bash.exe")) {
                    return consoleProcessCount > 3;
                }
                return consoleProcessCount > 2;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (process instanceof WinConPtyProcess) {
            WinConPtyProcess conPtyProcess = (WinConPtyProcess)process;
            try {
                String executable = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)conPtyProcess.getCommand()))));
                int consoleProcessCount = conPtyProcess.getConsoleProcessCount();
                if (executable.endsWith("/Git/bin/bash.exe")) {
                    return consoleProcessCount > 2;
                }
                return consoleProcessCount > 1;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        LOG.warn("Cannot determine if there are running processes: " + SystemInfo.OS_NAME + ", " + process.getClass().getName());
        return false;
    }

    @Nullable
    private static String getExecutable(@NotNull WinPtyProcess process) {
        return (String)ContainerUtil.getFirstItem((List)process.getCommand());
    }
}

