/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;

public final class TerminalToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NonNls
    public static final String TOOL_WINDOW_ID = "Terminal";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        TerminalView terminalView = TerminalView.getInstance(project);
        terminalView.initToolWindow((ToolWindowEx)toolWindow);
        final TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions options = new TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions(project);
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new DumbAwareToggleAction(TerminalBundle.message("settings.terminal.smart.command.handling", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return options.getEnabled();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                options.setEnabled(state);
            }
        }}));
        TerminalArrangementManager terminalArrangementManager = TerminalArrangementManager.getInstance(project);
        terminalView.restoreTabs(terminalArrangementManager.getArrangementState());
        terminalArrangementManager.setToolWindow(toolWindow);
    }
}

