/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalShellCommandHandler;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J2\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J8\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0014\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00040\u0012H\u0002J*\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u001a\u0010\u0014\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/OpenFileShellCommandHandler;", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "()V", "checkRegisteredFileType", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "execute", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "localSession", "command", "executor", "Lcom/intellij/execution/Executor;", "handleCommand", "block", "Lkotlin/Function1;", "matches", "openFileEditor", "intellij.terminal"})
final class OpenFileShellCommandHandler
implements TerminalShellCommandHandler {
    public boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command) {
        return this.handleCommand(command, localSession, workingDirectory, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(this){
            final /* synthetic */ OpenFileShellCommandHandler this$0;

            public final boolean invoke(@Nullable VirtualFile file) {
                return OpenFileShellCommandHandler.access$checkRegisteredFileType(this.this$0, file);
            }
            {
                this.this$0 = openFileShellCommandHandler;
                super(1);
            }
        }));
    }

    public boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor) {
        return this.handleCommand(command, localSession, workingDirectory, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(this, project){
            final /* synthetic */ OpenFileShellCommandHandler this$0;
            final /* synthetic */ Project $project;

            public final boolean invoke(@Nullable VirtualFile file) {
                return OpenFileShellCommandHandler.access$openFileEditor(this.this$0, this.$project, file);
            }
            {
                this.this$0 = openFileShellCommandHandler;
                this.$project = project;
                super(1);
            }
        }));
    }

    private final boolean checkRegisteredFileType(VirtualFile file) {
        return file != null && Intrinsics.areEqual((Object)FileTypeRegistry.getInstance().getFileTypeByFile(file), (Object)UnknownFileType.INSTANCE) ^ true;
    }

    private final boolean openFileEditor(Project project, VirtualFile file) {
        FileEditor[] fileEditorArray;
        return file != null && !((fileEditorArray = FileEditorManager.getInstance((Project)project).openFile(file, true)).length == 0);
    }

    private final boolean handleCommand(String command, boolean localSession, String workingDirectory, Function1<? super VirtualFile, Boolean> block) {
        String prefix = "open ";
        if (!StringsKt.startsWith$default((String)command, (String)prefix, (boolean)false, (int)2, null)) {
            return false;
        }
        String string = command;
        int n = prefix.length();
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String path = string2;
        if (!localSession) {
            return false;
        }
        string = path;
        path = ((Object)StringsKt.trim((CharSequence)string)).toString();
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        if (file != null && !file.isDirectory() && file.exists()) {
            return (Boolean)block.invoke((Object)file);
        }
        if (workingDirectory != null) {
            Object object;
            VirtualFile it;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByIoFile(new File(workingDirectory, path));
            if (virtualFile2 != null) {
                it = virtualFile = virtualFile2;
                boolean bl = false;
                object = it.exists() && !it.isDirectory() ? virtualFile : null;
            } else {
                object = null;
            }
            it = virtualFile = object;
            boolean bl = false;
            return (Boolean)block.invoke((Object)it);
        }
        return false;
    }

    public static final /* synthetic */ boolean access$checkRegisteredFileType(OpenFileShellCommandHandler $this, VirtualFile file) {
        return $this.checkRegisteredFileType(file);
    }

    public static final /* synthetic */ boolean access$openFileEditor(OpenFileShellCommandHandler $this, Project project, VirtualFile file) {
        return $this.openFileEditor(project, file);
    }
}

