/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.JediTermWidget;
import com.pty4j.windows.WinPtyException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalProcessOptions;
import org.jetbrains.plugins.terminal.TerminalTabState;

public abstract class AbstractTerminalRunner<T extends Process> {
    private static final Logger LOG = Logger.getInstance(AbstractTerminalRunner.class);
    @NotNull
    protected final Project myProject;
    private final JBTerminalSystemSettingsProvider mySettingsProvider;

    public JBTerminalSystemSettingsProvider getSettingsProvider() {
        return this.mySettingsProvider;
    }

    public AbstractTerminalRunner(@NotNull Project project) {
        this.myProject = project;
        this.mySettingsProvider = new JBTerminalSystemSettingsProvider();
    }

    public void run() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, TerminalBundle.message("progress.title.running.terminal", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText(TerminalBundle.message("progress.text.running.terminal", new Object[0]));
                try {
                    AbstractTerminalRunner.this.doRun();
                }
                catch (Exception e) {
                    LOG.warn("Error running terminal", (Throwable)e);
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)AbstractTerminalRunner.this.getProject(), (String)e.getMessage(), (String)this.getTitle()));
                }
            }
        });
    }

    private void doRun() {
        try {
            T process = this.createProcess(new TerminalProcessOptions(null, null, null), null);
            UIUtil.invokeLaterIfNeeded(() -> this.initConsoleUI(process));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @NotNull
    public T createProcess(@NotNull TerminalProcessOptions options, @Nullable JBTerminalWidget widget) throws ExecutionException {
        return this.createProcess(options.getWorkingDirectory(), null);
    }

    @Deprecated(forRemoval=true)
    protected T createProcess(@Nullable String directory) throws ExecutionException {
        throw new AssertionError((Object)"Call createProcess(TerminalProcessOptions, JBTerminalWidget)");
    }

    @Deprecated(forRemoval=true)
    protected T createProcess(@Nullable String directory, @Nullable String commandHistoryFilePath) throws ExecutionException {
        return this.createProcess(directory);
    }

    protected abstract ProcessHandler createProcessHandler(T var1);

    @Deprecated(forRemoval=true)
    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory) {
        return this.createTerminalWidget(parent, currentWorkingDirectory, true);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    protected JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory, boolean deferSessionStartUntilUiShown) {
        return this.createTerminalWidget(parent, AbstractTerminalRunner.getParentDirectoryPath(currentWorkingDirectory), deferSessionStartUntilUiShown);
    }

    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable String currentWorkingDirectory, boolean deferSessionStartUntilUiShown) {
        ShellTerminalWidget terminalWidget = new ShellTerminalWidget(this.myProject, this.mySettingsProvider, parent);
        this.scheduleOpenSessionInDirectory(terminalWidget, currentWorkingDirectory, deferSessionStartUntilUiShown);
        return terminalWidget;
    }

    protected void scheduleOpenSessionInDirectory(@NotNull JBTerminalWidget terminalWidget, @Nullable String currentWorkingDirectory, boolean deferSessionStartUntilUiShown) {
        if (deferSessionStartUntilUiShown) {
            UiNotifyConnector.doWhenFirstShown((JComponent)terminalWidget, () -> this.openSessionInDirectory(terminalWidget, currentWorkingDirectory));
        } else {
            this.openSessionInDirectory(terminalWidget, currentWorkingDirectory);
        }
    }

    private void initConsoleUI(T process) {
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TerminalRunner", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        actionToolbar.setTargetComponent((JComponent)panel);
        ProcessHandler processHandler = this.createProcessHandler(process);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, processHandler, (JComponent)panel, this.getTerminalConnectionName(process));
        contentDescriptor.setAutoFocusContent(true);
        toolbarActions.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        JBTerminalSystemSettingsProvider provider = new JBTerminalSystemSettingsProvider();
        JBTerminalWidget widget = new JBTerminalWidget(this.myProject, (JBTerminalSystemSettingsProviderBase)provider, (Disposable)contentDescriptor);
        AbstractTerminalRunner.createAndStartSession(widget, this.createTtyConnector(process));
        panel.add((Component)widget.getComponent(), "Center");
        this.showConsole(defaultExecutor, contentDescriptor, widget.getComponent());
        processHandler.startNotify();
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        String dir = state != null ? state.myWorkingDirectory : null;
        VirtualFile result = dir == null ? null : LocalFileSystem.getInstance().findFileByPath(dir);
        return result == null ? null : result.getPath();
    }

    private static void createAndStartSession(@NotNull JBTerminalWidget terminal, @NotNull TtyConnector ttyConnector) {
        JediTermWidget session = terminal.createTerminalSession(ttyConnector);
        session.start();
    }

    protected abstract String getTerminalConnectionName(T var1);

    protected abstract TtyConnector createTtyConnector(T var1);

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor myDescriptor, Component toFocus) {
        RunContentManager.getInstance((Project)this.myProject).showRunContent(defaultExecutor, myDescriptor);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(defaultExecutor.getId());
        if (toolWindow != null) {
            toolWindow.activate(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true));
        }
    }

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    public abstract String runningTargetName();

    public boolean isTerminalSessionPersistent() {
        return true;
    }

    @Nullable
    private static String getParentDirectoryPath(@Nullable VirtualFile file) {
        VirtualFile dir = file != null && !file.isDirectory() ? file.getParent() : file;
        return dir != null ? dir.getPath() : null;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public void openSessionInDirectory(@NotNull JBTerminalWidget terminalWidget, @Nullable String directory) {
        ModalityState modalityState = ModalityState.stateForComponent((Component)terminalWidget.getComponent());
        Dimension size = terminalWidget.getTerminalPanel().getTerminalSizeFromComponent();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            try {
                T process = this.createProcess(new TerminalProcessOptions(directory, size != null ? Integer.valueOf(size.width) : null, size != null ? Integer.valueOf(size.height) : null), terminalWidget);
                TtyConnector connector = this.createTtyConnector(process);
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        terminalWidget.createTerminalSession(connector);
                    }
                    catch (Exception e) {
                        this.printError(terminalWidget, "Cannot create terminal session for " + this.runningTargetName(), e);
                    }
                    try {
                        terminalWidget.start();
                        terminalWidget.getComponent().revalidate();
                        terminalWidget.notifyStarted();
                    }
                    catch (RuntimeException e) {
                        this.printError(terminalWidget, "Cannot open " + this.runningTargetName(), e);
                    }
                }, modalityState, this.myProject.getDisposed());
            }
            catch (Exception e) {
                this.printError(terminalWidget, "Cannot open " + this.runningTargetName(), e);
            }
        });
    }

    private void printError(@NotNull JBTerminalWidget terminalWidget, @NotNull String errorMessage, @NotNull Exception e) {
        LOG.info(errorMessage, (Throwable)e);
        @Nls StringBuilder message = new StringBuilder();
        if (terminalWidget.getTerminal().getCursorX() > 1) {
            message.append("\n");
        }
        message.append(errorMessage).append("\n").append(e.getMessage()).append("\n\n");
        WinPtyException winptyException = (WinPtyException)ExceptionUtil.findCause((Throwable)e, WinPtyException.class);
        if (winptyException != null) {
            message.append(winptyException.getMessage()).append("\n\n");
        }
        terminalWidget.writePlainMessage(message.toString());
        terminalWidget.writePlainMessage("\n" + TerminalBundle.message("see.ide.log.error.description", ShowLogAction.getActionName()) + "\n");
        ApplicationManager.getApplication().invokeLater(() -> terminalWidget.getTerminalPanel().setCursorVisible(false), this.myProject.getDisposed());
    }
}

