/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.kpmsearch;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.kpmsearch.DefaultPackageServiceConfig;
import org.jetbrains.idea.kpmsearch.PackageSearchEndpointConfig;
import org.jetbrains.idea.kpmsearch.PackageSearchResultModel;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

public final class PackageSearchService
implements DependencySearchProvider {
    private final PackageSearchEndpointConfig packageServiceConfig;

    public PackageSearchService() {
        this.packageServiceConfig = (PackageSearchEndpointConfig)ApplicationManager.getApplication().getService(DefaultPackageServiceConfig.class);
    }

    public PackageSearchService(PackageSearchEndpointConfig config) {
        this.packageServiceConfig = config;
    }

    @Override
    public void fulltextSearch(@NotNull String searchString, @NotNull Consumer<RepositoryArtifactData> consumer) {
        searchString = PackageSearchService.normalize(searchString);
        ProgressManager.checkCanceled();
        if (searchString != null) {
            this.doRequest(consumer, this.createUrlFullTextSearch(searchString));
        }
    }

    @Nullable
    private static String normalize(@Nullable String string) {
        if (Strings.isEmpty((String)string)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (!PackageSearchService.isAcceptable(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean isAcceptable(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ':' || c == '-' || c == '.' || c == '_';
    }

    @Override
    public void suggestPrefix(@Nullable String groupId, @Nullable String artifactId, @NotNull Consumer<RepositoryArtifactData> consumer) {
        artifactId = PackageSearchService.normalize(artifactId);
        groupId = PackageSearchService.normalize(groupId);
        ProgressManager.checkCanceled();
        this.doRequest(consumer, this.createUrlSuggestPrefix(groupId, artifactId));
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    private void doRequest(@NotNull Consumer<RepositoryArtifactData> consumer, @Nullable String url) {
        if (Strings.isEmpty((String)url)) {
            return;
        }
        try {
            HttpRequests.request((String)url).userAgent(this.packageServiceConfig.getUserAgent()).forceHttps(this.packageServiceConfig.forceHttps()).connectTimeout(this.packageServiceConfig.getReadTimeout()).readTimeout(this.packageServiceConfig.getConnectTimeout()).connect(request -> PackageSearchService.process(consumer, request));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object process(@NotNull Consumer<RepositoryArtifactData> consumer, HttpRequests.Request request) {
        try {
            JsonReader reader = new Gson().newJsonReader((Reader)request.getReader());
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("items".equals(name)) {
                    PackageSearchService.readVariants(reader, consumer);
                    continue;
                }
                reader.nextString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String createUrlFullTextSearch(@NotNull String coord) {
        String url = this.packageServiceConfig.getFullTextUrl();
        if (Strings.isEmpty((String)url)) {
            return null;
        }
        if (Strings.isEmpty((String)coord)) {
            return url;
        }
        return url + "?query=" + PackageSearchService.encode(coord.trim());
    }

    private String createUrlSuggestPrefix(@Nullable String groupId, @Nullable String artifactId) {
        String url = this.packageServiceConfig.getSuggestUrl();
        if (Strings.isEmpty((String)url)) {
            return null;
        }
        String groupParam = Strings.isEmpty((String)groupId) ? "" : "groupId=" + PackageSearchService.encode(groupId.trim());
        String artifactParam = Strings.isEmpty((String)artifactId) ? "" : "artifactId=" + PackageSearchService.encode(artifactId.trim());
        StringBuilder sb = new StringBuilder(url);
        if (Strings.isNotEmpty((String)groupParam)) {
            sb.append('?');
            sb.append(groupParam);
            if (Strings.isNotEmpty((String)artifactParam)) {
                sb.append('&');
            }
        }
        if (Strings.isNotEmpty((String)artifactParam)) {
            if (Strings.isEmpty((String)groupParam)) {
                sb.append('?');
            }
            sb.append(artifactParam);
        }
        return sb.toString();
    }

    private static void readVariants(JsonReader reader, Consumer<RepositoryArtifactData> consumer) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            PackageSearchResultModel resultModel = (PackageSearchResultModel)new Gson().fromJson(reader, PackageSearchResultModel.class);
            ProgressManager.checkCanceled();
            if (resultModel.versions == null || resultModel.versions.length < 1 || StringUtil.isEmpty((String)resultModel.groupId) || StringUtil.isEmpty((String)resultModel.artifactId)) continue;
            HashSet<String> versions = new HashSet<String>();
            ArrayList<MavenDependencyCompletionItem> itemList = new ArrayList<MavenDependencyCompletionItem>();
            for (int i = 0; i < resultModel.versions.length; ++i) {
                if (!versions.add(resultModel.versions[i])) continue;
                itemList.add(new MavenDependencyCompletionItem(resultModel.groupId, resultModel.artifactId, resultModel.versions[i], MavenDependencyCompletionItem.Type.REMOTE));
            }
            MavenDependencyCompletionItem[] items = itemList.toArray(new MavenDependencyCompletionItem[0]);
            String groupId = items[0].getGroupId();
            String artifactId = items[0].getArtifactId();
            if (groupId == null || artifactId == null) continue;
            consumer.accept(new MavenRepositoryArtifactInfo(groupId, artifactId, items));
        }
    }

    @NotNull
    private static String encode(@NotNull String s) {
        return URLEncoder.encode(s.trim(), StandardCharsets.UTF_8);
    }
}

