/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpsPathUtil {
    public static final String FILE_URL_PREFIX = "file://";
    public static final String JAR_URL_PREFIX = "jar://";
    public static final String JAR_SEPARATOR = "!/";
    private static final String UNNAMED_PROJECT = "<unnamed>";

    public static boolean isUnder(Set<File> ancestors, File file) {
        if (ancestors.isEmpty()) {
            return false;
        }
        File current = file;
        while (current != null) {
            if (ancestors.contains(current)) {
                return true;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return false;
    }

    public static File urlToFile(String url) {
        return new File(JpsPathUtil.urlToOsPath(url));
    }

    @NotNull
    public static String urlToOsPath(@NotNull String url) {
        return FileUtilRt.toSystemDependentName((String)JpsPathUtil.urlToPath(url));
    }

    @Contract(value="null -> null; !null -> !null")
    @NlsSafe
    public static String urlToPath(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith(FILE_URL_PREFIX)) {
            return url.substring(FILE_URL_PREFIX.length());
        }
        if (url.startsWith(JAR_URL_PREFIX)) {
            url = url.substring(JAR_URL_PREFIX.length());
            url = Strings.trimEnd((String)url, (String)JAR_SEPARATOR);
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        int idx = url.indexOf(":/");
        if (idx >= 0 && idx + 2 < url.length() && url.charAt(idx + 2) != '/') {
            String prefix = url.substring(0, idx);
            String suffix = url.substring(idx + 2);
            url = SystemInfoRt.isWindows ? prefix + "://" + suffix : prefix + ":///" + suffix;
        }
        return url;
    }

    public static String pathToUrl(String path) {
        return FILE_URL_PREFIX + path;
    }

    public static String getLibraryRootUrl(File file) {
        String path = FileUtilRt.toSystemIndependentName((String)file.getAbsolutePath());
        return file.isDirectory() ? FILE_URL_PREFIX + path : JAR_URL_PREFIX + path + JAR_SEPARATOR;
    }

    public static boolean isJrtUrl(@NotNull String url) {
        return url.startsWith("jrt://");
    }

    @Nullable
    public static String readProjectName(@NotNull Path projectDir) {
        String string;
        block8: {
            Stream<String> stream = Files.lines(projectDir.resolve(".name"));
            try {
                string = stream.findFirst().map(String::trim).orElse(null);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException e) {
                    return null;
                }
            }
            stream.close();
        }
        return string;
    }

    @NotNull
    public static String getDefaultProjectName(@NotNull Path projectDir) {
        Path parent = projectDir.getParent();
        if (parent != null) {
            Path name = parent.getFileName();
            return name != null ? name.toString() : parent.toString();
        }
        return UNNAMED_PROJECT;
    }
}

