/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsPathMacroContributor;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;
import org.jetbrains.jps.model.serialization.JpsProjectSerializationDataExtension;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsPathVariablesConfigurationImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.module.JpsModuleSerializationDataExtension;
import org.jetbrains.jps.service.JpsServiceManager;

public final class JpsModelSerializationDataService {
    public static Map<String, String> computeAllPathVariables(JpsGlobal global) {
        HashMap<String, String> pathVariables = new HashMap<String, String>(PathMacroUtil.getGlobalSystemMacros(false));
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        if (configuration != null) {
            pathVariables.putAll(configuration.getAllUserVariables());
        }
        for (JpsPathMacroContributor extension : JpsServiceManager.getInstance().getExtensions(JpsPathMacroContributor.class)) {
            pathVariables.putAll(extension.getPathMacros());
        }
        return pathVariables;
    }

    @Nullable
    public static JpsPathVariablesConfiguration getPathVariablesConfiguration(JpsGlobal global) {
        return global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
    }

    @NotNull
    public static JpsPathVariablesConfiguration getOrCreatePathVariablesConfiguration(JpsGlobal global) {
        JpsPathVariablesConfiguration child = global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
        if (child == null) {
            return global.getContainer().setChild(JpsGlobalLoader.PATH_VARIABLES_ROLE, new JpsPathVariablesConfigurationImpl());
        }
        return child;
    }

    @Nullable
    public static JpsProjectSerializationDataExtension getProjectExtension(@NotNull JpsProject project) {
        return project.getContainer().getChild(JpsProjectSerializationDataExtensionImpl.ROLE);
    }

    @Nullable
    public static File getBaseDirectory(@NotNull JpsProject project) {
        JpsProjectSerializationDataExtension extension = JpsModelSerializationDataService.getProjectExtension(project);
        return extension != null ? extension.getBaseDirectory() : null;
    }

    @Nullable
    public static JpsModuleSerializationDataExtension getModuleExtension(@NotNull JpsModule project) {
        return project.getContainer().getChild(JpsModuleSerializationDataExtensionImpl.ROLE);
    }

    @Nullable
    public static File getBaseDirectory(@NotNull JpsModule module) {
        JpsModuleSerializationDataExtension extension = JpsModelSerializationDataService.getModuleExtension(module);
        return extension != null ? extension.getBaseDirectory() : null;
    }

    @Nullable
    public static String getPathVariableValue(@NotNull JpsGlobal global, @NotNull String name) {
        String value = PathMacroUtil.getGlobalSystemMacroValue(name, false);
        if (value != null) {
            return value;
        }
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        return configuration != null ? configuration.getUserVariableValue(name) : null;
    }
}

