/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.module.impl.JpsDependencyElementBase;

public class JpsSdkDependencyImpl
extends JpsDependencyElementBase<JpsSdkDependencyImpl>
implements JpsSdkDependency {
    private final JpsSdkType<?> mySdkType;

    public JpsSdkDependencyImpl(@NotNull JpsSdkType<?> sdkType) {
        this.mySdkType = sdkType;
    }

    public JpsSdkDependencyImpl(JpsSdkDependencyImpl original) {
        super(original);
        this.mySdkType = original.mySdkType;
    }

    @Override
    @NotNull
    public JpsSdkDependencyImpl createCopy() {
        return new JpsSdkDependencyImpl(this);
    }

    @Override
    @NotNull
    public JpsSdkType<?> getSdkType() {
        return this.mySdkType;
    }

    @Override
    public JpsLibrary resolveSdk() {
        JpsSdkReference<?> reference = this.getSdkReference();
        if (reference == null) {
            return null;
        }
        return (JpsLibrary)reference.resolve();
    }

    @Override
    @Nullable
    public JpsSdkReference<?> getSdkReference() {
        return this.getContainingModule().getSdkReference(this.mySdkType);
    }

    @Override
    public boolean isInherited() {
        return false;
    }

    public String toString() {
        return "sdk dep [" + this.mySdkType + "]";
    }
}

