/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsExcludePatternImpl;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.module.impl.JpsDependenciesListImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleReferenceImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;

public class JpsModuleImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsModuleImpl<P>>
implements JpsTypedModule<P> {
    private static final JpsUrlListRole CONTENT_ROOTS_ROLE = new JpsUrlListRole("content roots");
    private static final JpsUrlListRole EXCLUDED_ROOTS_ROLE = new JpsUrlListRole("excluded roots");
    private static final JpsElementChildRole<JpsDependenciesListImpl> DEPENDENCIES_LIST_CHILD_ROLE = JpsElementChildRoleBase.create("dependencies");
    private static final JpsElementCollectionRole<JpsExcludePattern> EXCLUDE_PATTERNS_ROLE = JpsElementCollectionRole.create(JpsElementChildRoleBase.create("exclude patterns"));
    private final JpsModuleType<P> myModuleType;
    private final JpsLibraryCollection myLibraryCollection;

    public JpsModuleImpl(JpsModuleType<P> type, @NotNull String name, @NotNull P properties) {
        super(name);
        this.myModuleType = type;
        this.myContainer.setChild(this.myModuleType.getPropertiesRole(), properties);
        this.myContainer.setChild(CONTENT_ROOTS_ROLE);
        this.myContainer.setChild(EXCLUDED_ROOTS_ROLE);
        this.myContainer.setChild(DEPENDENCIES_LIST_CHILD_ROLE, new JpsDependenciesListImpl());
        this.getDependenciesList().addModuleSourceDependency();
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE));
        this.myContainer.setChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        this.myContainer.setChild(JpsSdkReferencesTableImpl.ROLE);
    }

    private JpsModuleImpl(JpsModuleImpl<P> original) {
        super(original);
        this.myModuleType = original.myModuleType;
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @Override
    @NotNull
    public JpsModuleImpl<P> createCopy() {
        return new JpsModuleImpl<P>(this);
    }

    @Override
    public JpsElementType<P> getType() {
        return this.myModuleType;
    }

    @Override
    @NotNull
    public P getProperties() {
        return this.myContainer.getChild(this.myModuleType.getPropertiesRole());
    }

    @Override
    public <P extends JpsElement> JpsTypedModule<P> asTyped(@NotNull JpsModuleType<P> type) {
        return this.myModuleType.equals(type) ? this : null;
    }

    @Override
    @NotNull
    public JpsUrlList getContentRootsList() {
        return this.myContainer.getChild(CONTENT_ROOTS_ROLE);
    }

    @Override
    @NotNull
    public JpsUrlList getExcludeRootsList() {
        return this.myContainer.getChild(EXCLUDED_ROOTS_ROLE);
    }

    @Override
    @NotNull
    public List<JpsModuleSourceRoot> getSourceRoots() {
        return ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE))).getElements();
    }

    @Override
    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedModuleSourceRoot<P>> getSourceRoots(@NotNull JpsModuleSourceRootType<P> type) {
        return ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE))).getElementsOfType(type);
    }

    @Override
    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType) {
        return this.addSourceRoot(url, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    @Override
    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        JpsModuleSourceRootImpl<P> root = new JpsModuleSourceRootImpl<P>(url, rootType, properties);
        this.addSourceRoot(root);
        return root;
    }

    @Override
    public void addSourceRoot(@NotNull JpsModuleSourceRoot root) {
        ((JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE))).addChild(root);
    }

    @Override
    public void removeSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType rootType) {
        JpsElementCollection roots = (JpsElementCollection)((Object)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE));
        for (JpsModuleSourceRoot root : roots.getElements()) {
            if (!root.getRootType().equals(rootType) || !root.getUrl().equals(url)) continue;
            roots.removeChild(root);
            break;
        }
    }

    @Override
    public void addExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        ((JpsElementCollection)this.myContainer.getOrSetChild(EXCLUDE_PATTERNS_ROLE)).addChild(new JpsExcludePatternImpl(baseDirUrl, pattern));
    }

    @Override
    public void removeExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        JpsElementCollection child = (JpsElementCollection)((Object)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE));
        if (child != null) {
            for (JpsExcludePattern excludePattern : child.getElements()) {
                if (!excludePattern.getBaseDirUrl().equals(baseDirUrl) || !excludePattern.getPattern().equals(pattern)) continue;
                child.removeChild(excludePattern);
            }
        }
    }

    @Override
    public List<JpsExcludePattern> getExcludePatterns() {
        JpsElementCollection child = (JpsElementCollection)((Object)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE));
        return child != null ? child.getElements() : Collections.emptyList();
    }

    @Override
    @NotNull
    public JpsDependenciesList getDependenciesList() {
        return this.myContainer.getChild(DEPENDENCIES_LIST_CHILD_ROLE);
    }

    @Override
    @NotNull
    public JpsSdkReferencesTable getSdkReferencesTable() {
        return this.myContainer.getChild(JpsSdkReferencesTableImpl.ROLE);
    }

    @Override
    public <P extends JpsElement> JpsSdkReference<P> getSdkReference(@NotNull JpsSdkType<P> type) {
        JpsSdkReference<P> sdkReference = this.getSdkReferencesTable().getSdkReference(type);
        if (sdkReference != null) {
            return sdkReference;
        }
        JpsProject project = this.getProject();
        if (project != null) {
            return project.getSdkReferencesTable().getSdkReference(type);
        }
        return null;
    }

    @Override
    public <P extends JpsElement> JpsSdk<P> getSdk(@NotNull JpsSdkType<P> type) {
        JpsSdkReference<P> reference = this.getSdkReference(type);
        if (reference == null) {
            return null;
        }
        JpsTypedLibrary library = (JpsTypedLibrary)reference.resolve();
        return library != null ? (JpsSdk)library.getProperties() : null;
    }

    @Override
    public void delete() {
        ((JpsElementCollection)((Object)this.myParent)).removeChild(this);
    }

    @Override
    @NotNull
    public JpsModuleReference createReference() {
        return new JpsModuleReferenceImpl(this.getName());
    }

    @Override
    @NotNull
    public <P extends JpsElement, Type extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addModuleLibrary(@NotNull String name, @NotNull Type type) {
        return this.myLibraryCollection.addLibrary(name, type);
    }

    @Override
    public void addModuleLibrary(@NotNull JpsLibrary library) {
        this.myLibraryCollection.addLibrary(library);
    }

    @Override
    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        return this.myLibraryCollection;
    }

    @Override
    @Nullable
    public JpsProject getProject() {
        JpsModel model = this.getModel();
        return model != null ? model.getProject() : null;
    }

    @Override
    @NotNull
    public JpsModuleType<P> getModuleType() {
        return this.myModuleType;
    }

    public String toString() {
        return "JpsModuleImpl: " + this.getName();
    }
}

