/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.JpsJavaSdkTypeWrapper;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsProductionModuleSourcePackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.impl.ExplodedDirectoryModuleExtensionImpl;
import org.jetbrains.jps.model.java.impl.JavaModuleExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaModuleIndexRole;
import org.jetbrains.jps.model.java.impl.JavaProjectExtensionRole;
import org.jetbrains.jps.model.java.impl.JavaSdkUtil;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumeratorImpl;
import org.jetbrains.jps.model.java.impl.JpsJavaDependencyExtensionRole;
import org.jetbrains.jps.model.java.impl.JpsProductionModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsProductionModuleSourcePackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsTestModuleOutputPackagingElementImpl;
import org.jetbrains.jps.model.java.impl.JpsWrappedJavaSdkReferenceImpl;
import org.jetbrains.jps.model.java.impl.compiler.JpsJavaCompilerConfigurationImpl;
import org.jetbrains.jps.model.java.impl.runConfiguration.JpsApplicationRunConfigurationPropertiesImpl;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationProperties;
import org.jetbrains.jps.model.java.runConfiguration.JpsApplicationRunConfigurationState;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsTestModuleProperties;
import org.jetbrains.jps.model.module.impl.JpsTestModulePropertiesImpl;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsJavaExtensionServiceImpl
extends JpsJavaExtensionService {
    @Override
    @NotNull
    public JpsJavaProjectExtension getOrCreateProjectExtension(@NotNull JpsProject project) {
        return (JpsJavaProjectExtension)project.getContainer().getOrSetChild(JavaProjectExtensionRole.INSTANCE);
    }

    @Override
    @Nullable
    public JpsJavaProjectExtension getProjectExtension(@NotNull JpsProject project) {
        return project.getContainer().getChild(JavaProjectExtensionRole.INSTANCE);
    }

    @Override
    @NotNull
    public JpsJavaModuleExtension getOrCreateModuleExtension(@NotNull JpsModule module) {
        return (JpsJavaModuleExtension)module.getContainer().getOrSetChild(JavaModuleExtensionRole.INSTANCE);
    }

    @Override
    @NotNull
    public JpsJavaDependencyExtension getOrCreateDependencyExtension(@NotNull JpsDependencyElement dependency) {
        return (JpsJavaDependencyExtension)dependency.getContainer().getOrSetChild(JpsJavaDependencyExtensionRole.INSTANCE);
    }

    @Override
    public JpsJavaDependencyExtension getDependencyExtension(@NotNull JpsDependencyElement dependency) {
        return dependency.getContainer().getChild(JpsJavaDependencyExtensionRole.INSTANCE);
    }

    @Override
    @Nullable
    public JpsJavaModuleExtension getModuleExtension(@NotNull JpsModule module) {
        return module.getContainer().getChild(JavaModuleExtensionRole.INSTANCE);
    }

    @Override
    @NotNull
    public ExplodedDirectoryModuleExtension getOrCreateExplodedDirectoryExtension(@NotNull JpsModule module) {
        return (ExplodedDirectoryModuleExtension)module.getContainer().getOrSetChild(ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
    }

    @Override
    @Nullable
    public ExplodedDirectoryModuleExtension getExplodedDirectoryExtension(@NotNull JpsModule module) {
        return module.getContainer().getChild(ExplodedDirectoryModuleExtensionImpl.ExplodedDirectoryModuleExtensionRole.INSTANCE);
    }

    @Override
    @NotNull
    public List<JpsDependencyElement> getDependencies(JpsModule module, JpsJavaClasspathKind classpathKind, boolean exportedOnly) {
        ArrayList<JpsDependencyElement> result = new ArrayList<JpsDependencyElement>();
        for (JpsDependencyElement dependencyElement : module.getDependenciesList().getDependencies()) {
            JpsJavaDependencyExtension extension = this.getDependencyExtension(dependencyElement);
            if (extension != null && (!extension.getScope().isIncludedIn(classpathKind) || exportedOnly && !extension.isExported())) continue;
            result.add(dependencyElement);
        }
        return result;
    }

    @Override
    public LanguageLevel getLanguageLevel(JpsModule module) {
        JpsJavaModuleExtension moduleExtension = this.getModuleExtension(module);
        if (moduleExtension == null) {
            return null;
        }
        LanguageLevel languageLevel = moduleExtension.getLanguageLevel();
        if (languageLevel != null) {
            return languageLevel;
        }
        JpsJavaProjectExtension projectExtension = this.getProjectExtension(module.getProject());
        return projectExtension != null ? projectExtension.getLanguageLevel() : null;
    }

    @Override
    public String getOutputUrl(JpsModule module, boolean forTests) {
        JpsJavaModuleExtension extension = this.getModuleExtension(module);
        if (extension == null) {
            return null;
        }
        if (extension.isInheritOutput()) {
            JpsJavaProjectExtension projectExtension = this.getProjectExtension(module.getProject());
            if (projectExtension == null) {
                return null;
            }
            String url = projectExtension.getOutputUrl();
            if (url == null) {
                return null;
            }
            return url + "/" + (forTests ? "test" : "production") + "/" + module.getName();
        }
        return forTests ? extension.getTestOutputUrl() : extension.getOutputUrl();
    }

    @Override
    @Nullable
    public File getOutputDirectory(JpsModule module, boolean forTests) {
        String url = this.getOutputUrl(module, forTests);
        return url != null ? JpsPathUtil.urlToFile(url) : null;
    }

    @Override
    public JpsTypedLibrary<JpsSdk<JpsDummyElement>> addJavaSdk(@NotNull JpsGlobal global, @NotNull String name, @NotNull String homePath) {
        JdkVersionDetector.JdkVersionInfo jdkInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(homePath);
        assert (jdkInfo != null) : homePath;
        String version = JdkVersionDetector.formatVersionString(jdkInfo.version);
        JpsTypedLibrary<JpsSdk<JpsDummyElement>> sdk = global.addSdk(name, homePath, version, JpsJavaSdkType.INSTANCE);
        List<Path> roots = JavaSdkUtil.getJdkClassesRoots(Paths.get(homePath, new String[0]), false);
        for (Path root : roots) {
            sdk.addRoot(root.toFile(), JpsOrderRootType.COMPILED);
        }
        return sdk;
    }

    @Override
    @NotNull
    public JpsJavaCompilerConfiguration getCompilerConfiguration(@NotNull JpsProject project) {
        return (JpsJavaCompilerConfiguration)project.getContainer().getOrSetChild(JpsJavaCompilerConfigurationImpl.ROLE);
    }

    @Override
    @Deprecated
    @NotNull
    public JpsJavaCompilerConfiguration getOrCreateCompilerConfiguration(@NotNull JpsProject project) {
        return this.getCompilerConfiguration(project);
    }

    @Override
    @Nullable
    public JpsTestModuleProperties getTestModuleProperties(@NotNull JpsModule module) {
        return module.getContainer().getChild(JpsTestModulePropertiesImpl.ROLE);
    }

    @Override
    public void setTestModuleProperties(@NotNull JpsModule module, @NotNull JpsModuleReference productionModuleReference) {
        module.getContainer().setChild(JpsTestModulePropertiesImpl.ROLE, new JpsTestModulePropertiesImpl(productionModuleReference));
    }

    @Override
    @NotNull
    public JpsSdkReference<JpsDummyElement> createWrappedJavaSdkReference(@NotNull JpsJavaSdkTypeWrapper sdkType, @NotNull JpsSdkReference<?> wrapperReference) {
        return new JpsWrappedJavaSdkReferenceImpl(sdkType, wrapperReference);
    }

    @Override
    @NotNull
    public JpsApplicationRunConfigurationProperties createRunConfigurationProperties(JpsApplicationRunConfigurationState state) {
        return new JpsApplicationRunConfigurationPropertiesImpl(state);
    }

    @Override
    @NotNull
    public JavaSourceRootProperties createSourceRootProperties(@NotNull String packagePrefix, boolean isGenerated) {
        return new JavaSourceRootProperties(packagePrefix, isGenerated);
    }

    @Override
    @NotNull
    public JavaSourceRootProperties createSourceRootProperties(@NotNull String packagePrefix) {
        return this.createSourceRootProperties(packagePrefix, false);
    }

    @Override
    @NotNull
    public JavaResourceRootProperties createResourceRootProperties(@NotNull String relativeOutputPath, boolean forGeneratedResource) {
        return new JavaResourceRootProperties(relativeOutputPath, forGeneratedResource);
    }

    @Override
    @NotNull
    public JpsProductionModuleOutputPackagingElement createProductionModuleOutput(@NotNull JpsModuleReference moduleReference) {
        return new JpsProductionModuleOutputPackagingElementImpl(moduleReference);
    }

    @Override
    @NotNull
    public JpsProductionModuleSourcePackagingElement createProductionModuleSource(@NotNull JpsModuleReference moduleReference) {
        return new JpsProductionModuleSourcePackagingElementImpl(moduleReference);
    }

    @Override
    @NotNull
    public JpsTestModuleOutputPackagingElement createTestModuleOutput(@NotNull JpsModuleReference moduleReference) {
        return new JpsTestModuleOutputPackagingElementImpl(moduleReference);
    }

    @Override
    public JpsJavaDependenciesEnumerator enumerateDependencies(Collection<JpsModule> modules) {
        return new JpsJavaDependenciesEnumeratorImpl(modules);
    }

    @Override
    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsProject project) {
        return new JpsJavaDependenciesEnumeratorImpl(project.getModules());
    }

    @Override
    protected JpsJavaDependenciesEnumerator enumerateDependencies(JpsModule module) {
        return new JpsJavaDependenciesEnumeratorImpl(Collections.singletonList(module));
    }

    @Override
    @NotNull
    public JavaModuleIndex getJavaModuleIndex(@NotNull JpsProject project) {
        return (JavaModuleIndex)project.getContainer().getOrSetChild(JavaModuleIndexRole.INSTANCE, () -> this.getCompilerConfiguration(project).getCompilerExcludes());
    }
}

