/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSdkUtil {
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        return ContainerUtil.map(JavaSdkUtil.getJdkClassesRoots(home.toPath(), isJre), Path::toFile);
    }

    @NotNull
    public static List<Path> getJdkClassesRoots(@NotNull Path home, boolean isJre) {
        Path classesDir;
        Path path;
        Path[] jarDirs;
        Path libDir;
        Path fileName = home.getFileName();
        if (fileName != null && "Home".equals(fileName.toString()) && Files.exists(home.resolve("../Classes/classes.jar"), new LinkOption[0])) {
            libDir = home.resolve("lib");
            Path classesDir2 = home.resolveSibling("Classes");
            Path path2 = libDir.resolve("ext");
            Path libEndorsedDir = libDir.resolve("endorsed");
            jarDirs = new Path[]{libEndorsedDir, libDir, classesDir2, path2};
        } else if (Files.exists(home.resolve("lib/jrt-fs.jar"), new LinkOption[0])) {
            jarDirs = new Path[]{};
        } else {
            libDir = home.resolve(isJre ? "lib" : "jre/lib");
            Path libExtDir = libDir.resolve("ext");
            Path path3 = libDir.resolve("endorsed");
            jarDirs = new Path[]{path3, libDir, libExtDir};
        }
        Set pathFilter = CollectionFactory.createFilePathSet();
        ArrayList<Path> rootFiles = new ArrayList<Path>();
        if (Registry.is((String)"project.structure.add.tools.jar.to.new.jdk", (boolean)false) && Files.isRegularFile(path = home.resolve("lib/tools.jar"), new LinkOption[0])) {
            rootFiles.add(path);
        }
        for (Path jarDir : jarDirs) {
            if (jarDir == null || !Files.isDirectory(jarDir, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(jarDir, "*.jar");){
                for (Path jarFile : stream) {
                    String canonicalPath;
                    String jarFileName = jarFile.getFileName().toString();
                    if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                    rootFiles.add(jarFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(home.resolve(isJre ? "bin" : "jre/bin"));
        try (DirectoryStream<Path> stream22 = Files.newDirectoryStream(home.resolve(isJre ? "lib" : "jre/lib"), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            Iterator iterator = stream22.iterator();
            while (iterator.hasNext()) {
                Path path4 = (Path)iterator.next();
                arrayList.add(path4);
            }
        }
        catch (IOException stream22) {
            // empty catch block
        }
        for (Path candidate : arrayList) {
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(candidate, p -> p.getFileName().toString().startsWith("jclSC") && Files.isDirectory(p, new LinkOption[0]));
                try {
                    for (Path dir : stream) {
                        Path vmJar = dir.resolve("vm.jar");
                        if (!Files.isRegularFile(vmJar, new LinkOption[0])) continue;
                        rootFiles.add(vmJar);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        Path classesZip = home.resolve("lib/classes.zip");
        if (Files.isRegularFile(classesZip, new LinkOption[0])) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && Files.isDirectory(classesDir = home.resolve("classes"), new LinkOption[0])) {
            rootFiles.add(classesDir);
        }
        return rootFiles;
    }

    @Nullable
    private static String getCanonicalPath(Path file) {
        try {
            return file.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

