/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.ex.JpsElementBase;

public class JavaSourceRootProperties
extends JpsElementBase<JavaSourceRootProperties> {
    private String myPackagePrefix = "";
    private boolean myForGeneratedSources;

    @ApiStatus.Internal
    public JavaSourceRootProperties(@NotNull String packagePrefix, boolean forGeneratedSources) {
        this.myPackagePrefix = packagePrefix;
        this.myForGeneratedSources = forGeneratedSources;
    }

    @NotNull
    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    @Override
    @NotNull
    public JavaSourceRootProperties createCopy() {
        return new JavaSourceRootProperties(this.myPackagePrefix, this.myForGeneratedSources);
    }

    public boolean isForGeneratedSources() {
        return this.myForGeneratedSources;
    }

    public void setPackagePrefix(@NotNull String packagePrefix) {
        if (!Objects.equals(this.myPackagePrefix, packagePrefix)) {
            this.myPackagePrefix = packagePrefix;
            this.fireElementChanged();
        }
    }

    public void setForGeneratedSources(boolean forGeneratedSources) {
        if (this.myForGeneratedSources != forGeneratedSources) {
            this.myForGeneratedSources = forGeneratedSources;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(@NotNull JavaSourceRootProperties modified) {
        this.setPackagePrefix(modified.myPackagePrefix);
        this.setForGeneratedSources(modified.myForGeneratedSources);
    }
}

