/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsFileTypesConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsFileTypesConfigurationImpl;
import org.jetbrains.jps.model.impl.JpsGlobalElementReference;
import org.jetbrains.jps.model.impl.JpsRootElementBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.serialization.JpsPathMapper;

public class JpsGlobalImpl
extends JpsRootElementBase<JpsGlobalImpl>
implements JpsGlobal {
    private final JpsLibraryCollectionImpl myLibraryCollection;
    private JpsPathMapper myPathMapper = JpsPathMapper.IDENTITY;

    public JpsGlobalImpl(@NotNull JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(model, eventDispatcher);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE));
        this.myContainer.setChild(JpsFileTypesConfigurationImpl.ROLE, new JpsFileTypesConfigurationImpl());
    }

    public JpsGlobalImpl(JpsGlobalImpl original, JpsModel model, JpsEventDispatcher eventDispatcher) {
        super(original, model, eventDispatcher);
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection)((Object)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @Override
    @NotNull
    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(@NotNull LibraryType libraryType, @NotNull String name) {
        return this.myLibraryCollection.addLibrary(name, libraryType);
    }

    @Override
    public <P extends JpsElement> JpsTypedLibrary<JpsSdk<P>> addSdk(@NotNull String name, @Nullable String homePath, @Nullable String versionString, @NotNull JpsSdkType<P> type, @NotNull P properties) {
        JpsTypedLibrary<JpsSdk<P>> sdk = JpsElementFactory.getInstance().createSdk(name, homePath, versionString, type, properties);
        this.myLibraryCollection.addLibrary(sdk);
        return sdk;
    }

    @Override
    public <P extends JpsElement, SdkType extends JpsSdkType<P>> JpsTypedLibrary<JpsSdk<P>> addSdk(@NotNull String name, @Nullable String homePath, @Nullable String versionString, @NotNull SdkType type) {
        return this.addSdk(name, homePath, versionString, type, (JpsElement)((JpsElementTypeWithDefaultProperties)((Object)type)).createDefaultProperties());
    }

    @Override
    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        return this.myLibraryCollection;
    }

    @Override
    @NotNull
    public JpsFileTypesConfiguration getFileTypesConfiguration() {
        return this.myContainer.getChild(JpsFileTypesConfigurationImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsPathMapper getPathMapper() {
        return this.myPathMapper;
    }

    @Override
    public void setPathMapper(@NotNull JpsPathMapper pathMapper) {
        this.myPathMapper = pathMapper;
    }

    @Override
    @NotNull
    public JpsElementReference<JpsGlobal> createReference() {
        return new JpsGlobalElementReference();
    }
}

