/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsFileTypesConfiguration;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public class JpsFileTypesConfigurationImpl
extends JpsElementBase<JpsFileTypesConfigurationImpl>
implements JpsFileTypesConfiguration {
    public static final JpsElementChildRole<JpsFileTypesConfiguration> ROLE = JpsElementChildRoleBase.create("file types");
    private String myIgnoredPatternString;

    public JpsFileTypesConfigurationImpl() {
        this("CVS;.DS_Store;.svn;.pyc;.pyo;*.pyc;*.pyo;.git;*.hprof;_svn;.hg;*.lib;*~;__pycache__;.bundle;vssver.scc;vssver2.scc;*.rbc;");
    }

    private JpsFileTypesConfigurationImpl(String ignoredPatternString) {
        this.myIgnoredPatternString = ignoredPatternString;
    }

    @Override
    @NotNull
    public JpsFileTypesConfigurationImpl createCopy() {
        return new JpsFileTypesConfigurationImpl(this.myIgnoredPatternString);
    }

    @Override
    public String getIgnoredPatternString() {
        return this.myIgnoredPatternString;
    }

    @Override
    public void setIgnoredPatternString(@NotNull String ignoredPatternString) {
        if (!this.myIgnoredPatternString.equals(ignoredPatternString)) {
            this.myIgnoredPatternString = ignoredPatternString;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(@NotNull JpsFileTypesConfigurationImpl modified) {
        this.setIgnoredPatternString(modified.myIgnoredPatternString);
    }
}

