/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsEventDispatcher;

public abstract class JpsEventDispatcherBase
implements JpsEventDispatcher {
    private final Map<Class<?>, EventDispatcher<?>> myDispatchers = new HashMap();

    @Override
    @NotNull
    public <T extends EventListener> T getPublisher(Class<T> listenerClass) {
        EventDispatcher dispatcher = this.myDispatchers.get(listenerClass);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(listenerClass);
            this.myDispatchers.put(listenerClass, dispatcher);
        }
        return (T)dispatcher.getMulticaster();
    }

    @Override
    public <T extends JpsElement> void fireElementAdded(@NotNull T element, @NotNull JpsElementChildRole<T> role) {
        role.fireElementAdded(this, element);
    }

    @Override
    public <T extends JpsElement> void fireElementRemoved(@NotNull T element, @NotNull JpsElementChildRole<T> role) {
        role.fireElementRemoved(this, element);
    }
}

