/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.impl.JpsEncodingProjectConfigurationImpl;

public class JpsEncodingConfigurationServiceImpl
extends JpsEncodingConfigurationService {
    private static final JpsElementChildRoleBase<JpsSimpleElement<String>> ENCODING_ROLE = JpsElementChildRoleBase.create("encoding");

    @Override
    @Nullable
    public String getGlobalEncoding(@NotNull JpsGlobal global) {
        JpsSimpleElement<String> encoding = global.getContainer().getChild(ENCODING_ROLE);
        return encoding != null ? encoding.getData() : null;
    }

    @Override
    public void setGlobalEncoding(@NotNull JpsGlobal global, @Nullable String encoding) {
        if (encoding != null) {
            global.getContainer().setChild(ENCODING_ROLE, JpsElementFactory.getInstance().createSimpleElement(encoding));
        } else {
            global.getContainer().removeChild(ENCODING_ROLE);
        }
    }

    @Override
    @Nullable
    public String getProjectEncoding(@NotNull JpsModel model) {
        String projectEncoding;
        JpsEncodingProjectConfiguration configuration = this.getEncodingConfiguration(model.getProject());
        if (configuration != null && (projectEncoding = configuration.getProjectEncoding()) != null) {
            return projectEncoding;
        }
        return this.getGlobalEncoding(model.getGlobal());
    }

    @Override
    @Nullable
    public JpsEncodingProjectConfiguration getEncodingConfiguration(@NotNull JpsProject project) {
        return project.getContainer().getChild(JpsEncodingProjectConfigurationImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsEncodingProjectConfiguration setEncodingConfiguration(@NotNull JpsProject project, @Nullable String projectEncoding, @NotNull Map<String, String> urlToEncoding) {
        JpsEncodingProjectConfigurationImpl configuration = new JpsEncodingProjectConfigurationImpl(urlToEncoding, projectEncoding);
        return project.getContainer().setChild(JpsEncodingProjectConfigurationImpl.ROLE, configuration);
    }
}

