/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;

public class ExactFileNameMatcher
implements FileNameMatcher {
    private final String myFileName;
    private final boolean myIgnoreCase;

    public ExactFileNameMatcher(@NotNull String fileName) {
        this.myFileName = fileName;
        this.myIgnoreCase = false;
    }

    public ExactFileNameMatcher(@NotNull String fileName, boolean ignoreCase) {
        this.myFileName = fileName;
        this.myIgnoreCase = ignoreCase;
    }

    @Override
    public boolean acceptsCharSequence(@NotNull CharSequence fileName) {
        return Comparing.equal((CharSequence)fileName, (CharSequence)this.myFileName, (!this.myIgnoreCase ? 1 : 0) != 0);
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return this.myFileName;
    }

    public String getFileName() {
        return this.myFileName;
    }

    public boolean isIgnoreCase() {
        return this.myIgnoreCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExactFileNameMatcher that = (ExactFileNameMatcher)o;
        return this.myFileName.equals(that.myFileName);
    }

    public int hashCode() {
        return this.myFileName.hashCode();
    }

    public String toString() {
        return this.getPresentableString();
    }
}

