/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.AbstractIrTypeSubstitutor;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrCapturedType;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/types/IrCapturedTypeSubstitutor;", "Lorg/jetbrains/kotlin/ir/types/AbstractIrTypeSubstitutor;", "typeParameters", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "typeArguments", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "capturedTypes", "Lorg/jetbrains/kotlin/ir/types/impl/IrCapturedType;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/ir/IrBuiltIns;)V", "capturedSubstitution", "", "oldSubstitution", "getSubstitutionArgument", "typeParameter", "isEmptySubstitution", "", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeSubstitutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeSubstitutor.kt\norg/jetbrains/kotlin/ir/types/IrCapturedTypeSubstitutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class IrCapturedTypeSubstitutor
extends AbstractIrTypeSubstitutor {
    @NotNull
    private final Map<IrTypeParameterSymbol, IrTypeArgument> oldSubstitution;
    @NotNull
    private final Map<IrTypeParameterSymbol, IrCapturedType> capturedSubstitution;

    public IrCapturedTypeSubstitutor(@NotNull List<? extends IrTypeParameterSymbol> typeParameters2, @NotNull List<? extends IrTypeArgument> typeArguments, @NotNull List<IrCapturedType> capturedTypes, @NotNull IrBuiltIns irBuiltIns) {
        boolean bl;
        Intrinsics.checkNotNullParameter(typeParameters2, (String)"typeParameters");
        Intrinsics.checkNotNullParameter(typeArguments, (String)"typeArguments");
        Intrinsics.checkNotNullParameter(capturedTypes, (String)"capturedTypes");
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        super(irBuiltIns);
        boolean bl2 = bl = typeArguments.size() == typeParameters2.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = capturedTypes.size() == typeParameters2.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.oldSubstitution = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)typeParameters2, (Iterable)typeArguments));
        this.capturedSubstitution = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)typeParameters2, (Iterable)capturedTypes));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IrTypeArgument getSubstitutionArgument(@NotNull IrTypeParameterSymbol typeParameter) {
        IrTypeArgument irTypeArgument;
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        IrTypeProjection irTypeProjection = this.capturedSubstitution.get(typeParameter);
        if (irTypeProjection != null) {
            IrCapturedType it = irTypeProjection;
            boolean bl = false;
            IrTypeProjection irTypeProjection = IrSimpleTypeImplKt.makeTypeProjection(it, Variance.INVARIANT);
            irTypeProjection = irTypeProjection;
            if (irTypeProjection2 != null) {
                irTypeArgument = irTypeProjection;
                return irTypeArgument;
            }
        }
        IrTypeArgument irTypeArgument = this.oldSubstitution.get(typeParameter);
        irTypeArgument = irTypeArgument;
        if (irTypeArgument2 != null) return irTypeArgument;
        throw new AssertionError((Object)("Unsubstituted type parameter: " + RenderIrElementKt.render(typeParameter.getOwner())));
    }

    @Override
    public boolean isEmptySubstitution() {
        return this.oldSubstitution.isEmpty();
    }
}

