/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0018B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "kind", "Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "value", "(IILorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;Ljava/lang/Object;)V", "getEndOffset", "()I", "getKind", "()Lorg/jetbrains/kotlin/ir/expressions/IrConstKind;", "getStartOffset", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "Companion", "ir.tree"})
public final class IrConstImpl<T>
extends IrConst<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private IrType type;
    @NotNull
    private final IrConstKind<T> kind;
    private final T value;

    public IrConstImpl(int startOffset, int endOffset, @NotNull IrType type2, @NotNull IrConstKind<T> kind, T value) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type2;
        this.kind = kind;
        this.value = value;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    @NotNull
    public IrType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<set-?>");
        this.type = irType;
    }

    @Override
    @NotNull
    public IrConstKind<T> getKind() {
        return this.kind;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rJ,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fJ$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ&\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016J,\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001bJ,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001dJ,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl$Companion;", "", "()V", "boolean", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "value", "byte", "", "char", "", "constFalse", "constNull", "", "constTrue", "defaultValueForType", "double", "", "float", "", "int", "long", "", "short", "", "string", "", "ir.tree"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrConstImpl<String> string(int startOffset, int endOffset, @NotNull IrType type2, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new IrConstImpl<String>(startOffset, endOffset, type2, IrConstKind.String.INSTANCE, value);
        }

        @NotNull
        public final IrConstImpl<Integer> int(int startOffset, int endOffset, @NotNull IrType type2, int value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Integer>(startOffset, endOffset, type2, IrConstKind.Int.INSTANCE, value);
        }

        @NotNull
        public final IrConstImpl constNull(int startOffset, int endOffset, @NotNull IrType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Object>(startOffset, endOffset, type2, IrConstKind.Null.INSTANCE, null);
        }

        @NotNull
        public final IrConstImpl<Boolean> boolean(int startOffset, int endOffset, @NotNull IrType type2, boolean value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Boolean>(startOffset, endOffset, type2, IrConstKind.Boolean.INSTANCE, value);
        }

        @NotNull
        public final IrConstImpl<Boolean> constTrue(int startOffset, int endOffset, @NotNull IrType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.boolean(startOffset, endOffset, type2, true);
        }

        @NotNull
        public final IrConstImpl<Boolean> constFalse(int startOffset, int endOffset, @NotNull IrType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.boolean(startOffset, endOffset, type2, false);
        }

        @NotNull
        public final IrConstImpl<Long> long(int startOffset, int endOffset, @NotNull IrType type2, long value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Long>(startOffset, endOffset, type2, IrConstKind.Long.INSTANCE, value);
        }

        @NotNull
        public final IrConstImpl<Float> float(int startOffset, int endOffset, @NotNull IrType type2, float value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Float>(startOffset, endOffset, type2, IrConstKind.Float.INSTANCE, Float.valueOf(value));
        }

        @NotNull
        public final IrConstImpl<Double> double(int startOffset, int endOffset, @NotNull IrType type2, double value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Double>(startOffset, endOffset, type2, IrConstKind.Double.INSTANCE, value);
        }

        @NotNull
        public final IrConstImpl<Character> char(int startOffset, int endOffset, @NotNull IrType type2, char value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Character>(startOffset, endOffset, type2, IrConstKind.Char.INSTANCE, Character.valueOf(value));
        }

        @NotNull
        public final IrConstImpl<Byte> byte(int startOffset, int endOffset, @NotNull IrType type2, byte value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Byte>(startOffset, endOffset, type2, IrConstKind.Byte.INSTANCE, value);
        }

        @NotNull
        public final IrConstImpl<Short> short(int startOffset, int endOffset, @NotNull IrType type2, short value) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return new IrConstImpl<Short>(startOffset, endOffset, type2, IrConstKind.Short.INSTANCE, value);
        }

        @NotNull
        public final IrConstImpl<?> defaultValueForType(int startOffset, int endOffset, @NotNull IrType type2) {
            IrConstImpl<Comparable<Boolean>> irConstImpl;
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (IrTypePredicatesKt.isMarkedNullable(type2)) {
                return this.constNull(startOffset, endOffset, type2);
            }
            PrimitiveType primitiveType = IrTypePredicatesKt.getPrimitiveType(type2);
            switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()]) {
                case 1: {
                    irConstImpl = this.boolean(startOffset, endOffset, type2, false);
                    break;
                }
                case 2: {
                    irConstImpl = this.char(startOffset, endOffset, type2, '\u0000');
                    break;
                }
                case 3: {
                    irConstImpl = this.byte(startOffset, endOffset, type2, (byte)0);
                    break;
                }
                case 4: {
                    irConstImpl = this.short(startOffset, endOffset, type2, (short)0);
                    break;
                }
                case 5: {
                    irConstImpl = this.int(startOffset, endOffset, type2, 0);
                    break;
                }
                case 6: {
                    irConstImpl = this.float(startOffset, endOffset, type2, 0.0f);
                    break;
                }
                case 7: {
                    irConstImpl = this.long(startOffset, endOffset, type2, 0L);
                    break;
                }
                case 8: {
                    irConstImpl = this.double(startOffset, endOffset, type2, 0.0);
                    break;
                }
                default: {
                    irConstImpl = this.constNull(startOffset, endOffset, type2);
                }
            }
            return irConstImpl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PrimitiveType.values().length];
                try {
                    nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.CHAR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.BYTE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.SHORT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.INT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.FLOAT.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.LONG.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

