/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.mangle.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.mangle.KotlinMangleComputer;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleConstant;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleMode;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B!\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\bH&J\u001c\u0010 \u001a\u00020!2\n\u0010\"\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u00020!2\n\u0010&\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\n\u0010\"\u001a\u00060\u0005j\u0002`\u0006H\u0014J\u001c\u0010*\u001a\u00020!2\n\u0010+\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010'\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020!2\u0006\u0010\u001d\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020!2\u0006\u0010\u001d\u001a\u000202H\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020!2\u0006\u0010\u001d\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010@\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020(H\u0016J\u0018\u0010G\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010G\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010J\u001a\u00020\u001cH\u0002J\u0018\u0010K\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010K\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010L\u001a\u00020MH\u0002J\u0018\u0010K\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010J\u001a\u00020\u001cH\u0002J\f\u0010N\u001a\u00020\u0003*\u00020(H\u0002J$\u0010O\u001a\u00020!*\u00020\u001a2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\n2\u0006\u0010R\u001a\u00020\u0003H\u0002J\u001c\u0010S\u001a\u00020!*\u00020\u001a2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\nH\u0002J\u0014\u0010T\u001a\u00020!*\u00020\u00032\u0006\u0010U\u001a\u00020\u001cH\u0002J\u0018\u0010V\u001a\u00020!*\u00060\u0005j\u0002`\u00062\u0006\u0010W\u001a\u00020(H\u0002J\u0012\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001c0Y*\u00020\u001aH\u0016J\u000e\u0010Z\u001a\u0004\u0018\u00010\u001c*\u00020\u001aH\u0016J\u0014\u0010[\u001a\u00020\u001c*\u00020\u001a2\u0006\u0010'\u001a\u00020,H\u0016R\u0018\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0012j\b\u0012\u0004\u0012\u00020\u0003`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\n*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/mangle/ir/IrMangleComputer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/KotlinMangleComputer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mode", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;", "compatibleMode", "", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;Z)V", "getBuilder", "()Ljava/lang/StringBuilder;", "getCompatibleMode", "()Z", "isRealExpect", "typeParameterContainer", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "isSyntheticForJavaField", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Z", "addReturnType", "addReturnTypeSpecialCase", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "computeMangle", "", "declaration", "copy", "newMode", "mangleType", "", "tBuilder", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "mangleTypeParameter", "tpBuilder", "param", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "mangleTypePlatformSpecific", "mangleValueParameter", "vpBuilder", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitAnonymousInitializer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "visitErrorDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrErrorDeclaration;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "visitProperty", "visitScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "visitTypeParameter", "appendName", "c", "", "s", "appendSignature", "i", "", "effectiveParent", "mangleFunction", "isCtor", "isStatic", "container", "mangleSignature", "mangleSimpleDeclaration", "name", "mangleTypeParameterReference", "typeParameter", "platformSpecificFunctionMarks", "", "platformSpecificFunctionName", "specialValueParamPrefix", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrMangleComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrMangleComputer.kt\norg/jetbrains/kotlin/backend/common/serialization/mangle/ir/IrMangleComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1855#2,2:327\n800#2,11:331\n178#3:329\n1#4:330\n*S KotlinDebug\n*F\n+ 1 IrMangleComputer.kt\norg/jetbrains/kotlin/backend/common/serialization/mangle/ir/IrMangleComputer\n*L\n116#1:327,2\n290#1:331,11\n178#1:329\n*E\n"})
public abstract class IrMangleComputer
implements IrElementVisitorVoid,
KotlinMangleComputer<IrDeclaration> {
    @NotNull
    private final StringBuilder builder;
    @NotNull
    private final MangleMode mode;
    private final boolean compatibleMode;
    @NotNull
    private final ArrayList<IrDeclaration> typeParameterContainer;
    private boolean isRealExpect;

    public IrMangleComputer(@NotNull StringBuilder builder2, @NotNull MangleMode mode, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.builder = builder2;
        this.mode = mode;
        this.compatibleMode = compatibleMode;
        this.typeParameterContainer = new ArrayList(4);
    }

    @NotNull
    protected final StringBuilder getBuilder() {
        return this.builder;
    }

    protected final boolean getCompatibleMode() {
        return this.compatibleMode;
    }

    @Nullable
    public String platformSpecificFunctionName(@NotNull IrFunction $this$platformSpecificFunctionName) {
        Intrinsics.checkNotNullParameter((Object)$this$platformSpecificFunctionName, (String)"<this>");
        return null;
    }

    @NotNull
    public List<String> platformSpecificFunctionMarks(@NotNull IrFunction $this$platformSpecificFunctionMarks) {
        Intrinsics.checkNotNullParameter((Object)$this$platformSpecificFunctionMarks, (String)"<this>");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String specialValueParamPrefix(@NotNull IrFunction $this$specialValueParamPrefix, @NotNull IrValueParameter param) {
        Intrinsics.checkNotNullParameter((Object)$this$specialValueParamPrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return "";
    }

    public boolean addReturnType() {
        return false;
    }

    protected boolean addReturnTypeSpecialCase(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        return false;
    }

    @NotNull
    public abstract IrMangleComputer copy(@NotNull MangleMode var1);

    private final void appendName(StringBuilder $this$appendName, String s) {
        if (this.mode.getFqn()) {
            $this$appendName.append(s);
        }
    }

    private final void appendName(StringBuilder $this$appendName, char c) {
        if (this.mode.getFqn()) {
            $this$appendName.append(c);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, String s) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(s);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, char c) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(c);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, int i) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(i);
        }
    }

    @Override
    @NotNull
    public String computeMangle(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrVisitorsKt.acceptVoid(declaration, this);
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void mangleSimpleDeclaration(IrDeclaration $this$mangleSimpleDeclaration, String name) {
        int l = this.builder.length();
        IrVisitorsKt.acceptVoid($this$mangleSimpleDeclaration.getParent(), this);
        if (this.builder.length() != l) {
            this.appendName(this.builder, '.');
        }
        this.appendName(this.builder, name);
    }

    private final void mangleFunction(IrFunction $this$mangleFunction, boolean isCtor, boolean isStatic, IrDeclaration container) {
        this.isRealExpect |= $this$mangleFunction.isExpect();
        this.typeParameterContainer.add(container);
        IrDeclarationParent containerParent = container.getParent();
        IrDeclarationParent realParent = containerParent instanceof IrField && Intrinsics.areEqual((Object)((IrField)containerParent).getOrigin(), (Object)IrDeclarationOrigin.DELEGATE.INSTANCE) ? ((IrField)containerParent).getParent() : containerParent;
        IrVisitorsKt.acceptVoid(realParent, this);
        this.appendName(this.builder, '#');
        String string = this.platformSpecificFunctionName($this$mangleFunction);
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.builder.append(it);
            return;
        }
        String string2 = $this$mangleFunction.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
        String funName = string2;
        this.builder.append(funName);
        this.mangleSignature($this$mangleFunction, isCtor, isStatic);
    }

    private final void mangleSignature(IrFunction $this$mangleSignature, boolean isCtor, boolean isStatic) {
        if (!this.mode.getSignature()) {
            return;
        }
        if (isStatic) {
            this.appendSignature(this.builder, "#static");
        }
        Iterable $this$forEach$iv = this.platformSpecificFunctionMarks($this$mangleSignature);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.appendSignature(this.builder, it);
        }
        IrValueParameter irValueParameter = $this$mangleSignature.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            if (!it.isHidden()) {
                this.appendSignature(this.builder, '@');
                this.mangleValueParameter(this.builder, it);
            }
        }
        MangleUtilsKt.collectForMangler((Collection)$this$mangleSignature.getValueParameters(), this.builder, MangleConstant.VALUE_PARAMETERS, (Function2)new Function2<StringBuilder, IrValueParameter, Unit>(this, $this$mangleSignature){
            final /* synthetic */ IrMangleComputer this$0;
            final /* synthetic */ IrFunction $this_mangleSignature;
            {
                this.this$0 = $receiver;
                this.$this_mangleSignature = $receiver2;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrValueParameter it) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!it.isHidden()) {
                    IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, this.this$0.specialValueParamPrefix(this.$this_mangleSignature, it));
                    IrMangleComputer.access$mangleValueParameter(this.this$0, $this$collectForMangler, it);
                }
            }
        });
        MangleUtilsKt.collectForMangler((Collection)$this$mangleSignature.getTypeParameters(), this.builder, MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IrTypeParameter, Unit>(this){
            final /* synthetic */ IrMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrTypeParameter it) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IrMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, it);
            }
        });
        if (!isCtor && !IrTypePredicatesKt.isUnit($this$mangleSignature.getReturnType()) && (this.addReturnType() || this.addReturnTypeSpecialCase($this$mangleSignature))) {
            this.mangleType(this.builder, $this$mangleSignature.getReturnType());
        }
    }

    private final IrDeclaration effectiveParent(IrTypeParameter $this$effectiveParent) {
        IrDeclaration irDeclaration;
        IrDeclarationParent irParent = $this$effectiveParent.getParent();
        if (irParent instanceof IrSimpleFunction) {
            Object object = ((IrSimpleFunction)irParent).getCorrespondingPropertySymbol();
            irDeclaration = (IrDeclaration)(object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)irParent);
        } else if (irParent instanceof IrTypeParametersContainer) {
            irDeclaration = (IrDeclaration)((Object)irParent);
        } else {
            throw new IllegalStateException(("Unexpected type parameter container " + RenderIrElementKt.render(irParent) + " for TP " + RenderIrElementKt.render($this$effectiveParent)).toString());
        }
        return irDeclaration;
    }

    private final void mangleValueParameter(StringBuilder vpBuilder, IrValueParameter param) {
        this.mangleType(vpBuilder, param.getType());
        if (AdditionalIrUtilsKt.isVararg(param)) {
            this.appendSignature(vpBuilder, "...");
        }
    }

    private final void mangleTypeParameter(StringBuilder tpBuilder, IrTypeParameter param) {
        this.appendSignature(tpBuilder, param.getIndex());
        this.appendSignature(tpBuilder, '\u00a7');
        MangleUtilsKt.collectForMangler((Collection)param.getSuperTypes(), tpBuilder, MangleConstant.UPPER_BOUNDS, (Function2)new Function2<StringBuilder, IrType, Unit>(this){
            final /* synthetic */ IrMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrType it) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IrMangleComputer.access$mangleType(this.this$0, $this$collectForMangler, it);
            }
        });
    }

    private final void mangleTypeParameterReference(StringBuilder $this$mangleTypeParameterReference, IrTypeParameter typeParameter) {
        IrDeclaration parent2 = this.effectiveParent(typeParameter);
        int ci = this.typeParameterContainer.indexOf(parent2);
        this.appendSignature($this$mangleTypeParameterReference, ci);
        this.appendSignature($this$mangleTypeParameterReference, ':');
        this.appendSignature($this$mangleTypeParameterReference, typeParameter.getIndex());
    }

    private final void mangleType(StringBuilder tBuilder, IrType type2) {
        IrType irType = type2;
        if (irType instanceof IrSimpleType) {
            IrClassifierSymbol classifier = ((IrSimpleType)type2).getClassifier();
            if (classifier instanceof IrClassSymbol) {
                IrVisitorsKt.acceptVoid(((IrClassSymbol)classifier).getOwner(), this.copy(MangleMode.FQNAME));
            } else if (classifier instanceof IrTypeParameterSymbol) {
                this.mangleTypeParameterReference(tBuilder, (IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner());
            }
            Collection $this$ifNotEmpty$iv = ((IrSimpleType)type2).getArguments();
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                List $this$mangleType_u24lambda_u243 = (List)$this$ifNotEmpty$iv;
                boolean bl = false;
                MangleUtilsKt.collectForMangler($this$mangleType_u24lambda_u243, tBuilder, MangleConstant.TYPE_ARGUMENTS, (Function2)new Function2<StringBuilder, IrTypeArgument, Unit>(this){
                    final /* synthetic */ IrMangleComputer this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrTypeArgument arg) {
                        Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                        IrTypeArgument irTypeArgument = arg;
                        if (irTypeArgument instanceof IrStarProjection) {
                            IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, '*');
                        } else if (irTypeArgument instanceof IrTypeProjection) {
                            if (((IrTypeProjection)arg).getVariance() != Variance.INVARIANT) {
                                IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, ((IrTypeProjection)arg).getVariance().getLabel());
                                IrMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, '|');
                            }
                            IrMangleComputer.access$mangleType(this.this$0, $this$collectForMangler, ((IrTypeProjection)arg).getType());
                        }
                    }
                });
            }
            if (IrTypePredicatesKt.isMarkedNullable((IrSimpleType)type2)) {
                this.appendSignature(tBuilder, '?');
            }
            this.mangleTypePlatformSpecific(type2, tBuilder);
        } else if (irType instanceof IrDynamicType) {
            this.appendSignature(tBuilder, "<dynamic>");
        } else if (irType instanceof IrErrorType) {
            this.appendSignature(tBuilder, "<ERROR CLASS>");
        } else {
            throw new IllegalStateException(("Unexpected type " + type2).toString());
        }
    }

    protected void mangleTypePlatformSpecific(@NotNull IrType type2, @NotNull StringBuilder tBuilder) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)tBuilder, (String)"tBuilder");
    }

    @NotNull
    public Void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("unexpected element " + RenderIrElementKt.render(element)).toString());
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrVisitorsKt.acceptVoid(declaration.getParent(), this);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.mangleSimpleDeclaration(declaration, "<ERROR DECLARATION>");
    }

    @Override
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.isRealExpect |= declaration.isExpect();
        this.typeParameterContainer.add(declaration);
        String string = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name.asString()");
        String className = string;
        this.mangleSimpleDeclaration(declaration, className);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FqName it = declaration.getFqName();
        boolean bl = false;
        if (!it.isRoot()) {
            String string = it.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.asString()");
            this.appendName(this.builder, string);
        }
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        Object object;
        IrDeclarationBase irDeclarationBase;
        boolean isStaticProperty;
        boolean bl;
        IrSimpleFunction accessor;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrProperty $this$visitProperty_u24lambda_u245 = declaration;
        boolean bl2 = false;
        IrSimpleFunction irSimpleFunction = $this$visitProperty_u24lambda_u245.getGetter();
        if (irSimpleFunction == null) {
            irSimpleFunction = $this$visitProperty_u24lambda_u245.getSetter();
        }
        if (!((accessor = irSimpleFunction) != null || declaration.getBackingField() != null)) {
            boolean $i$a$-require-IrMangleComputer$visitProperty$22 = false;
            String $i$a$-require-IrMangleComputer$visitProperty$22 = "Expected at least one accessor or backing field for property " + RenderIrElementKt.render(declaration);
            throw new IllegalArgumentException($i$a$-require-IrMangleComputer$visitProperty$22.toString());
        }
        this.isRealExpect |= declaration.isExpect();
        this.typeParameterContainer.add(declaration);
        IrVisitorsKt.acceptVoid(declaration.getParent(), this);
        if (accessor != null) {
            IrSimpleFunction it = accessor;
            boolean bl3 = false;
            bl = it.getDispatchReceiverParameter() == null && !(declaration.getParent() instanceof IrPackageFragment) && !IrUtilsKt.isFacadeClass(declaration.getParent());
        } else {
            IrDeclarationBase irDeclarationBase2 = (IrProperty)IrFakeOverrideUtilsKt.resolveFakeOverride$default(declaration, false, null, 3, null);
            if (irDeclarationBase2 == null || (irDeclarationBase2 = ((IrProperty)irDeclarationBase2).getBackingField()) == null) {
                throw new IllegalStateException(("Expected at least one accessor or a backing field for property " + RenderIrElementKt.render(declaration)).toString());
            }
            IrDeclarationBase backingField2 = irDeclarationBase2;
            bl = isStaticProperty = ((IrField)backingField2).isStatic();
        }
        if (isStaticProperty) {
            this.appendSignature(this.builder, "#static");
        }
        if ((irDeclarationBase = accessor) != null && (irDeclarationBase = irDeclarationBase.getExtensionReceiverParameter()) != null) {
            IrDeclarationBase it = irDeclarationBase;
            boolean bl4 = false;
            this.appendSignature(this.builder, '@');
            this.mangleValueParameter(this.builder, (IrValueParameter)it);
        }
        if ((object = accessor) == null || (object = object.getTypeParameters()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object typeParameters2 = object;
        MangleUtilsKt.collectForMangler((Collection)typeParameters2, this.builder, MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IrTypeParameter, Unit>(this){
            final /* synthetic */ IrMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IrTypeParameter it) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                IrMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, it);
            }
        });
        this.builder.append(declaration.getName().asString());
        if (this.isSyntheticForJavaField(declaration)) {
            this.builder.append("#jf");
        }
    }

    private final boolean isSyntheticForJavaField(IrProperty $this$isSyntheticForJavaField) {
        return Intrinsics.areEqual((Object)$this$isSyntheticForJavaField.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && $this$isSyntheticForJavaField.getGetter() == null && $this$isSyntheticForJavaField.getSetter() == null;
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrPropertySymbol prop2 = declaration.getCorrespondingPropertySymbol();
        if (this.compatibleMode || prop2 == null) {
            IrDeclaration irDeclaration = declaration;
            String string = declaration.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name.asString()");
            this.mangleSimpleDeclaration(irDeclaration, string);
        } else {
            this.visitProperty((IrProperty)prop2.getOwner());
        }
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclaration irDeclaration = declaration;
        String string = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name.asString()");
        this.mangleSimpleDeclaration(irDeclaration, string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        StringBuilder stringBuilder;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrClass klass = IrUtilsKt.getParentAsClass(declaration);
        Iterable $this$filterIsInstance$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List anonInitializers = (List)destination$iv$iv;
        StringBuilder $this$visitAnonymousInitializer_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$visitAnonymousInitializer_u24lambda_u249.append("<ANI>");
        if (anonInitializers.size() > 1) {
            $this$visitAnonymousInitializer_u24lambda_u249.append('$');
            $this$visitAnonymousInitializer_u24lambda_u249.append(anonInitializers.indexOf(declaration));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String anonName = string;
        this.mangleSimpleDeclaration(declaration, anonName);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrDeclaration irDeclaration = declaration;
        String string = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.name.asString()");
        this.mangleSimpleDeclaration(irDeclaration, string);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrVisitorsKt.acceptVoid(this.effectiveParent(declaration), this);
        this.appendSignature(this.builder, '@');
        this.appendSignature(this.builder, declaration.getIndex());
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.isRealExpect |= declaration.isExpect();
        Object object = declaration.getCorrespondingPropertySymbol();
        IrElement container = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (IrElement)declaration;
        boolean isStatic = declaration.getDispatchReceiverParameter() == null && !(((IrDeclarationBase)container).getParent() instanceof IrPackageFragment) && !IrUtilsKt.isFacadeClass(((IrDeclarationBase)container).getParent());
        this.mangleFunction(declaration, false, isStatic, (IrDeclaration)container);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.mangleFunction(declaration, true, false, declaration);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression);
    }

    @Override
    public void visitCall(@NotNull IrCall expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression, data);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression, data);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression, data);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression, data);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression, data);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression, data);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression, data);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression, data);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    public static final /* synthetic */ void access$appendSignature(IrMangleComputer $this, StringBuilder $receiver, String s) {
        $this.appendSignature($receiver, s);
    }

    public static final /* synthetic */ void access$mangleValueParameter(IrMangleComputer $this, StringBuilder vpBuilder, IrValueParameter param) {
        $this.mangleValueParameter(vpBuilder, param);
    }

    public static final /* synthetic */ void access$mangleTypeParameter(IrMangleComputer $this, StringBuilder tpBuilder, IrTypeParameter param) {
        $this.mangleTypeParameter(tpBuilder, param);
    }

    public static final /* synthetic */ void access$mangleType(IrMangleComputer $this, StringBuilder tBuilder, IrType type2) {
        $this.mangleType(tBuilder, type2);
    }

    public static final /* synthetic */ void access$appendSignature(IrMangleComputer $this, StringBuilder $receiver, char c) {
        $this.appendSignature($receiver, c);
    }
}

