/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoHandler;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionDirection;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionType;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/UntilHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoHandler;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ProgressionType;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "progressionElementTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "build", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfo;", "expression", "data", "scopeOwner", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "matchIterable", "", "ir.backend.common"})
public final class UntilHandler
implements HeaderInfoHandler<IrCall, ProgressionType> {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final Collection<IrType> progressionElementTypes;

    public UntilHandler(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.progressionElementTypes = this.context.getIr().getSymbols().getProgressionElementTypes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchIterable(@NotNull IrCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression.getSymbol().getOwner();
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(callee.getValueParameters());
        if (!CollectionsKt.contains((Iterable)this.progressionElementTypes, (Object)(irValueParameter != null ? irValueParameter.getType() : null))) return false;
        IrValueParameter irValueParameter2 = callee.getExtensionReceiverParameter();
        if (!CollectionsKt.contains((Iterable)this.progressionElementTypes, (Object)(irValueParameter2 != null ? irValueParameter2.getType() : null))) return false;
        if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getKotlinFqName(callee), (Object)new FqName("kotlin.ranges.until"))) return false;
        return true;
    }

    @Override
    @Nullable
    public HeaderInfo build(@NotNull IrCall expression, @NotNull ProgressionType data, @NotNull IrSymbol scopeOwner) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)scopeOwner, (String)"scopeOwner");
        DeclarationIrBuilder $this$build_u24lambda_u240 = LowerUtilsKt.createIrBuilder(this.context, scopeOwner, expression.getStartOffset(), expression.getEndOffset());
        boolean bl = false;
        IrExpression irExpression = expression.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression irExpression2 = irExpression;
        IrExpression irExpression3 = expression.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression3);
        IrExpression irExpression4 = irExpression3;
        IrConstImpl irConstImpl = ExpressionHelpersKt.irInt$default($this$build_u24lambda_u240, 1, null, 2, null);
        ProgressionDirection progressionDirection = ProgressionDirection.INCREASING;
        return new ProgressionHeaderInfo(data, irExpression2, irExpression4, irConstImpl, false, false, false, progressionDirection, null, null, 800, null);
    }
}

