/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.LateinitLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/NullableFieldsForLateinitCreationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class NullableFieldsForLateinitCreationLowering
implements DeclarationTransformer {
    @NotNull
    private final CommonBackendContext backendContext;

    public NullableFieldsForLateinitCreationLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
    }

    @NotNull
    public final CommonBackendContext getBackendContext() {
        return this.backendContext;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrField) {
            Object object = ((IrField)declaration).getCorrespondingPropertySymbol();
            if (object != null && (object = (IrProperty)object.getOwner()) != null) {
                IrField newField;
                Object property = object;
                boolean bl = false;
                if (LateinitLoweringKt.access$isRealLateinit((IrProperty)property) && !Intrinsics.areEqual((Object)declaration, (Object)(newField = LateinitLoweringKt.access$buildOrGetNullableField(this.backendContext, (IrField)declaration))) && !Intrinsics.areEqual((Object)declaration.getParent(), (Object)property.getParent())) {
                    return CollectionsKt.listOf((Object)newField);
                }
            }
        }
        return null;
    }
}

