/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.MethodsFromAnyGeneratorForLowerings;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J8\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$J\u0010\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(H&J \u0010-\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0015H&J\u0016\u0010/\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0018\u00100\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0018H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000fH\u0016J\u0010\u00107\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u00108\u001a\u00020\u001c*\u00020\u000fH\u0004J\u0010\u00109\u001a\b\u0012\u0004\u0012\u00020;0:*\u00020\u000fJ\f\u0010<\u001a\u00020\u001c*\u00020\u000fH\u0016J\u001c\u0010=\u001a\u00020$*\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "forbidDirectFieldAccessInMethods", "", "getForbidDirectFieldAccessInMethods", "()Z", "implementations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getImplementations$ir_backend_common", "()Ljava/util/Map;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "createAnnotationImplementation", "annotationClass", "generateFunctionBodies", "", "eqFun", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "hcFun", "toStringFun", "generator", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationMemberGenerator;", "generatedEquals", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "arg1", "arg2", "getArrayContentEqualsSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "implementAnnotationPropertiesAndConstructor", "generatedConstructor", "implementGeneratedFunctions", "implementPlatformSpecificParts", "moveValueArgumentsUsingNames", "source", "destination", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitConstructorCall", "addConstructorBodyForCompatibility", "getAnnotationProperties", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "platformSetup", "transformArrayEqualsArgument", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nAnnotationImplementationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,274:1\n410#2,5:275\n72#3,2:280\n1#4:282\n1#4:352\n361#5,7:283\n1208#6,2:290\n1238#6,4:292\n1864#6,3:296\n800#6,11:317\n800#6,11:328\n766#6:339\n857#6,2:340\n1603#6,9:342\n1855#6:351\n1856#6:353\n1612#6:354\n38#7,4:299\n229#7:303\n223#7,13:304\n*S KotlinDebug\n*F\n+ 1 AnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer\n*L\n65#1:275,5\n65#1:280,2\n160#1:352\n84#1:283,7\n100#1:290,2\n100#1:292,4\n105#1:296,3\n157#1:317,11\n159#1:328,11\n159#1:339\n159#1:340,2\n160#1:342,9\n160#1:351\n160#1:353\n160#1:354\n120#1:299,4\n137#1:303\n137#1:304,13\n*E\n"})
public abstract class AnnotationImplementationTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final BackendContext context;
    @Nullable
    private final IrFile irFile;
    @NotNull
    private final Map<IrClass, IrClass> implementations;
    private final boolean forbidDirectFieldAccessInMethods;

    public AnnotationImplementationTransformer(@NotNull BackendContext context, @Nullable IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.irFile = irFile;
        this.implementations = new LinkedHashMap();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Nullable
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final Map<IrClass, IrClass> getImplementations$ir_backend_common() {
        return this.implementations;
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.addConstructorBodyForCompatibility(declaration);
        return super.visitClassNew(declaration);
    }

    /*
     * WARNING - void declaration
     */
    protected final void addConstructorBodyForCompatibility(@NotNull IrClass $this$addConstructorBodyForCompatibility) {
        void $this$addConstructorBodyForCompatibility_u24lambda_u240;
        void this_$iv$iv;
        void startOffset$iv;
        void $this$irBlockBody$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addConstructorBodyForCompatibility, (String)"<this>");
        if (!IrUtilsKt.isAnnotationClass($this$addConstructorBodyForCompatibility)) {
            return;
        }
        IrConstructor irConstructor = (IrConstructor)SequencesKt.singleOrNull(IrUtilsKt.getConstructors($this$addConstructorBodyForCompatibility));
        if (irConstructor == null) {
            return;
        }
        IrConstructor primaryConstructor = irConstructor;
        if (primaryConstructor.getBody() != null) {
            return;
        }
        $this$addConstructorBodyForCompatibility.setModality(Modality.OPEN);
        IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)$this$addConstructorBodyForCompatibility.getSymbol(), 0, 0, 6, null);
        int n = -2;
        int endOffset$iv = -2;
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_9 = this_$iv$iv;
        IrConstructor irConstructor2 = primaryConstructor;
        boolean bl = false;
        $this$addConstructorBodyForCompatibility_u24lambda_u240.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$addConstructorBodyForCompatibility_u24lambda_u240, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$addConstructorBodyForCompatibility_u24lambda_u240.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        $this$addConstructorBodyForCompatibility_u24lambda_u240.unaryPlus(new IrInstanceInitializerCallImpl($this$addConstructorBodyForCompatibility_u24lambda_u240.getStartOffset(), $this$addConstructorBodyForCompatibility_u24lambda_u240.getEndOffset(), $this$addConstructorBodyForCompatibility.getSymbol(), $this$addConstructorBodyForCompatibility_u24lambda_u240.getContext().getIrBuiltIns().getUnitType()));
        irConstructor2.setBody(this_$iv$iv.doBuild());
    }

    @NotNull
    public abstract IrConstructor chooseConstructor(@NotNull IrClass var1, @NotNull IrConstructorCall var2);

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Object object = IrTypesKt.getClassOrNull(expression.getType());
        if (object == null || (object = (IrClass)object.getOwner()) == null) {
            return super.visitConstructorCall(expression);
        }
        Object constructedClass = object;
        if (!IrUtilsKt.isAnnotationClass((IrClass)constructedClass)) {
            return super.visitConstructorCall(expression);
        }
        if (!((Collection)constructedClass.getTypeParameters()).isEmpty()) {
            return super.visitConstructorCall(expression);
        }
        if (!((IrConstructor)expression.getSymbol().getOwner()).isPrimary()) {
            boolean $i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22 = false;
            String $i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22 = "Non-primary constructors of annotations are not supported";
            throw new IllegalArgumentException($i$a$-require-AnnotationImplementationTransformer$visitConstructorCall$22.toString());
        }
        Map<IrClass, IrClass> $this$getOrPut$iv = this.implementations;
        boolean $i$f$getOrPut = false;
        IrClass value$iv = $this$getOrPut$iv.get(constructedClass);
        if (value$iv == null) {
            boolean bl = false;
            IrClass answer$iv = this.createAnnotationImplementation((IrClass)constructedClass);
            $this$getOrPut$iv.put((IrClass)constructedClass, answer$iv);
            irClass = answer$iv;
        } else {
            irClass = value$iv;
        }
        IrClass implClass = irClass;
        IrConstructor ctor = this.chooseConstructor(implClass, expression);
        IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, expression.getStartOffset(), expression.getEndOffset(), IrUtilsKt.getDefaultType(implClass), ctor.getSymbol(), null, 16, null);
        this.moveValueArgumentsUsingNames(expression, newCall);
        this.transformChildrenVoid(newCall);
        return newCall;
    }

    public void platformSetup(@NotNull IrClass $this$platformSetup) {
        Intrinsics.checkNotNullParameter((Object)$this$platformSetup, (String)"<this>");
    }

    /*
     * WARNING - void declaration
     */
    private final void moveValueArgumentsUsingNames(IrConstructorCall source, IrConstructorCall destination) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = IrUtilsKt.getArgumentsWithIr(source);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IrExpression value;
            Pair pair = (Pair)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            IrValueParameter param = (IrValueParameter)pair.component1();
            pair = (Pair)element$iv$iv;
            Name name = param.getName();
            boolean bl2 = false;
            IrExpression irExpression = value = (IrExpression)pair.component2();
            map.put(name, irExpression);
        }
        Map argumentsByName = destination$iv$iv;
        Iterable $this$forEachIndexed$iv = ((IrConstructor)destination.getSymbol().getOwner()).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index = n;
            boolean bl = false;
            IrExpression valueArg = (IrExpression)argumentsByName.get(parameter.getName());
            if (parameter.getDefaultValue() == null && valueArg == null) {
                Object object;
                String string = "Usage of default value argument for this annotation is not yet possible.\nPlease specify value for '" + ((object = IrTypesKt.getClassOrNull(source.getType())) != null && (object = (IrClass)object.getOwner()) != null ? object.getName() : null) + '.' + parameter.getName() + "' explicitly";
                throw new IllegalStateException(string.toString());
            }
            destination.putValueArgument(index, valueArg);
        }
    }

    private final IrClass createAnnotationImplementation(IrClass annotationClass) {
        IrConstructor irConstructor;
        Object subclass;
        Object object = this.getCurrentClass();
        IrDeclarationParent irDeclarationParent = object != null && (object = ((ScopeWithIr)object).getScope()) != null ? ((Scope)object).getLocalDeclarationParent() : null;
        IrClass localDeclarationParent = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName);
        String string = fqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotationClass.fqNameWhenAvailable!!.asString()");
        String parentFqName = StringsKt.replace$default((String)string, (char)'.', (char)'_', (boolean)false, (int)4, null);
        Name name = Name.identifier((String)("annotationImpl$" + parentFqName + "$0"));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"annotationImpl\\$$parentFqName$0\")");
        Name wrapperName = name;
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$createAnnotationImplementation_u24lambda_u246 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$createAnnotationImplementation_u24lambda_u246.setStartOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u246.setEndOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u246.setName(wrapperName);
        $this$createAnnotationImplementation_u24lambda_u246.setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"INTERNAL");
        $this$createAnnotationImplementation_u24lambda_u246.setVisibility(descriptorVisibility);
        Object $this$createAnnotationImplementation_u24lambda_u247 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrElementBase irElementBase = localDeclarationParent;
        if (irElementBase == null) {
            irElementBase = this.irFile;
        }
        if ((bl = irElementBase) == null) {
            throw new IllegalStateException("irFile in transformer should be specified when creating synthetic implementation".toString());
        }
        $this$createAnnotationImplementation_u24lambda_u247.setParent(bl);
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$createAnnotationImplementation_u24lambda_u247);
        ((IrClass)$this$createAnnotationImplementation_u24lambda_u247).setSuperTypes(CollectionsKt.listOf((Object)IrUtilsKt.getDefaultType(annotationClass)));
        this.platformSetup((IrClass)$this$createAnnotationImplementation_u24lambda_u247);
        Object $this$addConstructor$iv = subclass = $this$buildClass$iv;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2422$iv$iv = new IrFunctionBuilder();
        boolean bl4 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2423$iv = $this$buildConstructor_u24lambda_u2422$iv$iv;
        boolean bl5 = false;
        IrFunctionBuilder $this$createAnnotationImplementation_u24lambda_u248 = $this$addConstructor_u24lambda_u2423$iv;
        boolean bl6 = false;
        $this$createAnnotationImplementation_u24lambda_u248.setStartOffset(-2);
        $this$createAnnotationImplementation_u24lambda_u248.setEndOffset(-2);
        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        $this$createAnnotationImplementation_u24lambda_u248.setVisibility(descriptorVisibility2);
        $this$addConstructor_u24lambda_u2423$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrConstructor constructor$iv = irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2422$iv$iv);
        boolean bl7 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        IrConstructor ctor = irConstructor;
        this.implementAnnotationPropertiesAndConstructor((IrClass)subclass, annotationClass, ctor);
        this.implementGeneratedFunctions(annotationClass, (IrClass)subclass);
        this.implementPlatformSpecificParts(annotationClass, (IrClass)subclass);
        return subclass;
    }

    public abstract void implementAnnotationPropertiesAndConstructor(@NotNull IrClass var1, @NotNull IrClass var2, @NotNull IrConstructor var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrProperty> getAnnotationProperties(@NotNull IrClass $this$getAnnotationProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotationProperties, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$getAnnotationProperties.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List props = (List)destination$iv$iv;
        if (!((Collection)props).isEmpty()) {
            return props;
        }
        $this$filterIsInstance$iv = $this$getAnnotationProperties.getDeclarations();
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IrProperty it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            IrPropertySymbol irPropertySymbol = it.getCorrespondingPropertySymbol();
            if ((irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public abstract IrFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType var1);

    @NotNull
    public IrExpression transformArrayEqualsArgument(@NotNull IrExpression $this$transformArrayEqualsArgument, @NotNull IrType type2, @NotNull IrBlockBodyBuilder irBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$transformArrayEqualsArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        return $this$transformArrayEqualsArgument;
    }

    @NotNull
    public final IrExpression generatedEquals(@NotNull IrBlockBodyBuilder irBuilder, @NotNull IrType type2, @NotNull IrExpression arg1, @NotNull IrExpression arg2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        if (IrTypePredicatesKt.isArray(type2) || IrTypeUtilsKt.isPrimitiveArray(type2) || IrTypeUtilsKt.isUnsignedArray(type2)) {
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrFunctionSymbol requiredSymbol = this.getArrayContentEqualsSymbol(type2);
            IrExpression lhs = this.transformArrayEqualsArgument(arg1, type2, irBuilder);
            IrExpression rhs = this.transformArrayEqualsArgument(arg2, type2, irBuilder);
            IrFunctionAccessExpression $this$generatedEquals_u24lambda_u2411 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)irBuilder, requiredSymbol);
            boolean bl = false;
            if (requiredSymbol.getOwner().getExtensionReceiverParameter() != null) {
                $this$generatedEquals_u24lambda_u2411.setExtensionReceiver(lhs);
                $this$generatedEquals_u24lambda_u2411.putValueArgument(0, rhs);
            } else {
                $this$generatedEquals_u24lambda_u2411.putValueArgument(0, lhs);
                $this$generatedEquals_u24lambda_u2411.putValueArgument(1, rhs);
            }
            irExpression = irFunctionAccessExpression;
        } else {
            irExpression = ExpressionHelpersKt.irEquals$default(irBuilder, arg1, arg2, null, 4, null);
        }
        return irExpression;
    }

    public boolean getForbidDirectFieldAccessInMethods() {
        return this.forbidDirectFieldAccessInMethods;
    }

    public void generateFunctionBodies(@NotNull IrClass annotationClass, @NotNull IrClass implClass, @NotNull IrSimpleFunction eqFun, @NotNull IrSimpleFunction hcFun, @NotNull IrSimpleFunction toStringFun, @NotNull AnnotationImplementationMemberGenerator generator2) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)eqFun, (String)"eqFun");
        Intrinsics.checkNotNullParameter((Object)hcFun, (String)"hcFun");
        Intrinsics.checkNotNullParameter((Object)toStringFun, (String)"toStringFun");
        Intrinsics.checkNotNullParameter((Object)generator2, (String)"generator");
        List<IrProperty> properties = this.getAnnotationProperties(annotationClass);
        generator2.generateEqualsUsingGetters(eqFun, IrUtilsKt.getDefaultType(annotationClass), properties);
        generator2.generateHashCodeMethod(hcFun, properties);
        generator2.generateToStringMethod(toStringFun, properties);
    }

    public final void implementGeneratedFunctions(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        MethodsFromAnyGeneratorForLowerings creator = new MethodsFromAnyGeneratorForLowerings(this.context, implClass, AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        IrSimpleFunction eqFun = creator.createEqualsMethodDeclaration();
        IrSimpleFunction hcFun = creator.createHashCodeMethodDeclaration();
        IrSimpleFunction toStringFun = creator.createToStringMethodDeclaration();
        if (!Intrinsics.areEqual((Object)annotationClass, (Object)implClass)) {
            IrUtilsKt.addFakeOverrides$default(implClass, this.context.getTypeSystem(), null, null, 6, null);
        }
        StringBuilder stringBuilder = new StringBuilder().append('@');
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName);
        AnnotationImplementationMemberGenerator generator2 = new AnnotationImplementationMemberGenerator(this.context, implClass, stringBuilder.append(fqName.asString()).toString(), this.getForbidDirectFieldAccessInMethods(), (Function4<? super IrBlockBodyBuilder, ? super IrType, ? super IrExpression, ? super IrExpression, ? extends IrExpression>)((Function4)new Function4<IrBlockBodyBuilder, IrType, IrExpression, IrExpression, IrExpression>(this){
            final /* synthetic */ AnnotationImplementationTransformer this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrBlockBodyBuilder $this$$receiver, @NotNull IrType type2, @NotNull IrExpression a, @NotNull IrExpression b) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return this.this$0.generatedEquals($this$$receiver, type2, a, b);
            }
        }));
        this.generateFunctionBodies(annotationClass, implClass, eqFun, hcFun, toStringFun, generator2);
    }

    public void implementPlatformSpecificParts(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
    }
}

