/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.JsScopesCollector;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u000eH\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/KotlinLocalsUsageCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "scopeInfo", "Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;", "findValueDeclarationWithName", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;Lkotlin/jvm/functions/Function1;)V", "functionStack", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "kotlinLocalsUsedInJs", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "processedNames", "", "usedLocals", "", "getUsedLocals", "()Ljava/util/Map;", "visitFunction", "", "x", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isDeclaredInsideJsCode", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/KotlinLocalsUsageCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n1#2:272\n*E\n"})
final class KotlinLocalsUsageCollector
extends RecursiveJsVisitor {
    @NotNull
    private final JsScopesCollector scopeInfo;
    @NotNull
    private final Function1<String, IrValueDeclaration> findValueDeclarationWithName;
    @NotNull
    private final List<JsFunction> functionStack;
    @NotNull
    private final Set<String> processedNames;
    @NotNull
    private final Map<JsName, IrValueDeclaration> kotlinLocalsUsedInJs;

    public KotlinLocalsUsageCollector(@NotNull JsScopesCollector scopeInfo, @NotNull Function1<? super String, ? extends IrValueDeclaration> findValueDeclarationWithName) {
        Intrinsics.checkNotNullParameter(scopeInfo, "scopeInfo");
        Intrinsics.checkNotNullParameter(findValueDeclarationWithName, "findValueDeclarationWithName");
        this.scopeInfo = scopeInfo;
        this.findValueDeclarationWithName = findValueDeclarationWithName;
        JsFunction[] jsFunctionArray = new JsFunction[]{null};
        this.functionStack = CollectionsKt.mutableListOf(jsFunctionArray);
        this.processedNames = new LinkedHashSet();
        this.kotlinLocalsUsedInJs = new LinkedHashMap();
    }

    @NotNull
    public final Map<JsName, IrValueDeclaration> getUsedLocals() {
        return this.kotlinLocalsUsedInJs;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkNotNullParameter(x, "x");
        UtilsKt.push(this.functionStack, x);
        super.visitFunction(x);
        UtilsKt.pop(this.functionStack);
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        block2: {
            JsName jsName;
            Intrinsics.checkNotNullParameter(nameRef, "nameRef");
            super.visitNameRef(nameRef);
            JsName it = jsName = nameRef.getName();
            boolean bl = false;
            JsName jsName2 = nameRef.getQualifier() == null ? jsName : null;
            if (jsName2 == null) {
                return;
            }
            JsName name = jsName2;
            String string2 = name.getIdent();
            Intrinsics.checkNotNullExpressionValue(string2, "name.ident");
            if (!this.processedNames.add(string2) || this.isDeclaredInsideJsCode(name)) break block2;
            String string3 = name.getIdent();
            Intrinsics.checkNotNullExpressionValue(string3, "name.ident");
            IrValueDeclaration irValueDeclaration = this.findValueDeclarationWithName.invoke(string3);
            if (irValueDeclaration != null) {
                IrValueDeclaration it2 = irValueDeclaration;
                boolean bl2 = false;
                this.kotlinLocalsUsedInJs.put(name, it2);
            }
        }
    }

    private final boolean isDeclaredInsideJsCode(JsName $this$isDeclaredInsideJsCode) {
        String string2 = $this$isDeclaredInsideJsCode.getIdent();
        Intrinsics.checkNotNullExpressionValue(string2, "ident");
        return this.scopeInfo.varWithNameExistsInScopeOf(UtilsKt.peek(this.functionStack), string2);
    }
}

