/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0014\b\u0002\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005BR\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012/\b\u0002\u0010\b\u001a)\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e0\t\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00028\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\b\u001a)\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/MapExternalizer;", "K", "V", "M", "", "Lcom/intellij/util/io/DataExternalizer;", "keyExternalizer", "valueExternalizer", "newMap", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "size", "", "(Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/DataExternalizer;Lkotlin/jvm/functions/Function1;)V", "read", "input", "Ljava/io/DataInput;", "(Ljava/io/DataInput;)Ljava/util/Map;", "save", "", "output", "Ljava/io/DataOutput;", "map", "(Ljava/io/DataOutput;Ljava/util/Map;)V", "kotlin-build-common"})
public class MapExternalizer<K, V, M extends Map<K, ? extends V>>
implements DataExternalizer<M> {
    @NotNull
    private final DataExternalizer<K> keyExternalizer;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;
    @NotNull
    private final Function1<Integer, Map<K, V>> newMap;

    public MapExternalizer(@NotNull DataExternalizer<K> keyExternalizer, @NotNull DataExternalizer<V> valueExternalizer, @NotNull Function1<? super Integer, ? extends Map<K, V>> newMap2) {
        Intrinsics.checkNotNullParameter(keyExternalizer, "keyExternalizer");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        Intrinsics.checkNotNullParameter(newMap2, "newMap");
        this.keyExternalizer = keyExternalizer;
        this.valueExternalizer = valueExternalizer;
        this.newMap = newMap2;
    }

    public /* synthetic */ MapExternalizer(DataExternalizer dataExternalizer, DataExternalizer dataExternalizer2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(dataExternalizer, dataExternalizer2, function1);
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull M map) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(map, "map");
        output.writeInt(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            this.keyExternalizer.save(output, key);
            this.valueExternalizer.save(output, value2);
        }
    }

    @Override
    @NotNull
    public M read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        int size = input.readInt();
        Map<K, V> map = this.newMap.invoke(size);
        int n = 0;
        while (n < size) {
            int it = n++;
            boolean bl = false;
            K key = this.keyExternalizer.read(input);
            V value2 = this.valueExternalizer.read(input);
            map.put(key, value2);
        }
        Intrinsics.checkNotNull(map, "null cannot be cast to non-null type M of org.jetbrains.kotlin.incremental.storage.MapExternalizer");
        return (M)map;
    }
}

