/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.upgrade;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;

public class CmdUpgradeClient
extends BaseSvnClient
implements UpgradeClient {
    private static final String STATUS = "\\s*(.+?)\\s*";
    private static final String PATH = "\\s*'(.*?)'\\s*";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(.+?)\\s*\\s*'(.*?)'\\s*");

    @Override
    public void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @Nullable ProgressTracker handler) throws VcsException {
        this.validateFormat(format, this.getSupportedFormats());
        CmdUpgradeClient.callHandler(handler, CmdUpgradeClient.createEvent(path, EventAction.UPDATE_COMPLETED));
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, path);
        FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new UpgradeStatusConvertor());
        UpgradeLineCommandListener listener2 = new UpgradeLineCommandListener(parser);
        this.execute(this.myVcs, Target.on(path), SvnCommandName.upgrade, parameters, (LineCommandListener)listener2);
        listener2.throwIfException();
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
        result.add(WorkingCopyFormat.from(this.myFactory.createVersionClient().getVersion()));
        return result;
    }

    private static final class UpgradeLineCommandListener
    extends LineCommandAdapter {
        @NotNull
        private final FileStatusResultParser parser;
        @NotNull
        private final AtomicReference<VcsException> exception;

        private UpgradeLineCommandListener(@NotNull FileStatusResultParser parser) {
            this.parser = parser;
            this.exception = new AtomicReference();
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                try {
                    this.parser.onLine(line);
                }
                catch (VcsException e) {
                    this.exception.set(e);
                }
            }
        }

        public void throwIfException() throws VcsException {
            VcsException e = this.exception.get();
            if (e != null) {
                throw e;
            }
        }
    }

    private static class UpgradeStatusConvertor
    implements Convertor<Matcher, ProgressEvent> {
        @NonNls
        private static final String UPGRADED_CODE = "Upgraded";

        private UpgradeStatusConvertor() {
        }

        public ProgressEvent convert(@NotNull Matcher matcher) {
            String statusMessage = matcher.group(1);
            String path = matcher.group(2);
            return CmdUpgradeClient.createEvent(new File(path), UpgradeStatusConvertor.createAction(statusMessage));
        }

        @Nullable
        public static EventAction createAction(@NotNull String code) {
            EventAction result = null;
            if (UPGRADED_CODE.equals(code)) {
                result = EventAction.UPGRADED_PATH;
            }
            return result;
        }
    }
}

