/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.FilePathUtil;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;

public class SvnUpdateContext
implements SequentialUpdatesContext {
    private final Set<File> myUpdatedExternals;
    private final SvnVcs myVcs;
    private final List<FilePath> myContentRoots;

    public SvnUpdateContext(SvnVcs vcs, FilePath[] contentRoots) {
        this.myVcs = vcs;
        this.myContentRoots = Arrays.asList(contentRoots);
        this.myContentRoots.sort((Comparator<FilePath>)FilePathByPathComparator.getInstance());
        this.myUpdatedExternals = new HashSet<File>();
    }

    @NotNull
    public String getMessageWhenInterruptedBeforeStart() {
        return null;
    }

    public boolean shouldFail() {
        return false;
    }

    public void registerExternalRootBeingUpdated(File root) {
        this.myUpdatedExternals.add(root);
    }

    public boolean shouldRunFor(File ioRoot) {
        RootUrlInfo info2;
        boolean result = true;
        if (this.myUpdatedExternals.contains(ioRoot)) {
            result = false;
        } else if (FilePathUtil.isNested(this.myContentRoots, ioRoot) && (info2 = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((File)ioRoot))) != null) {
            if (NestedCopyType.switched.equals((Object)info2.getType())) {
                result = false;
            } else if (NestedCopyType.external.equals((Object)info2.getType())) {
                result = !this.myVcs.getSvnConfiguration().isIgnoreExternals();
            }
        }
        return result;
    }
}

