/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public final class ExternalsDefinitionParser {
    @NotNull
    public static Map<String, String> parseExternalsProperty(@NotNull String externals) throws SvnBindException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String external : StringUtil.splitByLines((String)externals, (boolean)true)) {
            map.put(ExternalsDefinitionParser.parseRelativeDirectory(external), external);
        }
        return map;
    }

    @NotNull
    public static String parseRelativeDirectory(@NotNull String s) throws SvnBindException {
        String result;
        int length;
        if (ExternalsDefinitionParser.isUnescapedQuote(s = s.trim(), (length = s.length()) - 1)) {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length - 1, '\"');
            ExternalsDefinitionParser.assertIndex(s, index, SvnBundle.message("error.could.not.find.start.quote", new Object[0]));
            result = s.substring(index + 1, length - 1);
        } else {
            int index = ExternalsDefinitionParser.lastUnescapedIndexOf(s, length, ' ');
            ExternalsDefinitionParser.assertIndex(s, index, SvnBundle.message("error.could.not.find.separating.space", new Object[0]));
            result = s.substring(index + 1);
        }
        return ExternalsDefinitionParser.unescape(result);
    }

    private static void assertIndex(@NlsSafe @NotNull String s, int index, @NlsContexts.DialogMessage @NotNull String message) throws SvnBindException {
        if (index < 0) {
            throw new SvnBindException(message + " - " + s);
        }
    }

    @NotNull
    private static String unescape(@NotNull String s) {
        return s.replace("\\", "");
    }

    private static int lastUnescapedIndexOf(@NotNull String s, int from, char c) {
        int result = from;
        while ((result = s.lastIndexOf(c, result - 1)) != -1 && !ExternalsDefinitionParser.isUnescaped(s, result, c)) {
        }
        return result;
    }

    private static boolean isUnescapedQuote(@NotNull String s, int index) {
        return ExternalsDefinitionParser.isUnescaped(s, index, '\"');
    }

    private static boolean isUnescaped(@NotNull String s, int index, char c) {
        return StringUtil.isChar((CharSequence)s, (int)index, (char)c) && !StringUtil.isChar((CharSequence)s, (int)(index - 1), (char)'\\');
    }
}

