/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflow;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowHandler;
import com.intellij.vcs.commit.SingleChangeListCommitWorkflowUi;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.integrate.AlienCommitChangeListDialog;
import org.jetbrains.idea.svn.integrate.AlienCommitWorkflow;
import org.jetbrains.idea.svn.integrate.AlienDirtyScope;
import org.jetbrains.idea.svn.integrate.GatheringChangelistBuilder;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.IntegrateEventHandler;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.ResolveWorker;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.update.UpdateEventHandler;

public class SvnIntegrateChangesTask
extends Task.Backgroundable {
    private final ProjectLevelVcsManagerEx myProjectLevelVcsManager;
    private final SvnVcs myVcs;
    private final WorkingCopyInfo myInfo;
    private final UpdatedFilesReverseSide myAccumulatedFiles;
    private UpdatedFiles myRecentlyUpdatedFiles;
    private final List<VcsException> myExceptions;
    private final UpdateEventHandler myHandler;
    private final IMerger myMerger;
    private ResolveWorker myResolveWorker;
    private FilePath myMergeTarget;
    private final boolean myDryRun;

    public SvnIntegrateChangesTask(SvnVcs vcs, @NotNull WorkingCopyInfo info2, MergerFactory mergerFactory, Url currentBranchUrl, @NlsContexts.ProgressTitle @NotNull String title, boolean dryRun, String branchName) {
        super(vcs.getProject(), title, true);
        this.myDryRun = dryRun;
        this.myProjectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx((Project)this.myProject);
        this.myVcs = vcs;
        this.myInfo = info2;
        this.myAccumulatedFiles = new UpdatedFilesReverseSide(UpdatedFiles.create());
        this.myExceptions = new ArrayList<VcsException>();
        this.myHandler = new IntegrateEventHandler(this.myVcs, ProgressManager.getInstance().getProgressIndicator());
        this.myMerger = mergerFactory.createMerger(this.myVcs, new File(this.myInfo.getLocalPath()), this.myHandler, currentBranchUrl, branchName);
    }

    private static void indicatorOnStart() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(true);
            indicator.setText(SvnBundle.message("action.Subversion.integrate.changes.progress.integrating.text", new Object[0]));
        }
    }

    public void run(@NotNull ProgressIndicator indicator) {
        this.myHandler.setProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
        this.myResolveWorker = new ResolveWorker(this.myInfo.isUnderProjectRoot(), this.myProject);
        StoreReloadManager.getInstance().blockReloadingProjectOnExternalChanges();
        this.myProjectLevelVcsManager.startBackgroundVcsOperation();
        try {
            this.myRecentlyUpdatedFiles = UpdatedFiles.create();
            this.myHandler.setUpdatedFiles(this.myRecentlyUpdatedFiles);
            SvnIntegrateChangesTask.indicatorOnStart();
            while (true) {
                this.doMerge();
                RefreshVFsSynchronously.updateAllChanged((UpdatedFiles)this.myRecentlyUpdatedFiles);
                indicator.setText(VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
                if (this.myResolveWorker.needsInteraction(this.myRecentlyUpdatedFiles) || !this.myMerger.hasNext() || !this.myExceptions.isEmpty()) break;
                if (UpdatedFilesReverseSide.containErrors((UpdatedFiles)this.myRecentlyUpdatedFiles)) {
                    break;
                }
                this.accumulate();
            }
        }
        finally {
            this.myProjectLevelVcsManager.stopBackgroundVcsOperation();
        }
    }

    @NotNull
    private static VcsException createException(boolean isWarning, String ... messages) {
        List notEmptyMessages = ContainerUtil.mapNotNull((Object[])messages, message -> StringUtil.nullize((String)message, (boolean)true));
        return new VcsException((Collection)notEmptyMessages).setIsWarning(isWarning);
    }

    private void doMerge() {
        this.myHandler.startUpdate();
        try {
            this.myMerger.mergeNext();
        }
        catch (VcsException e) {
            this.myExceptions.add(SvnIntegrateChangesTask.createException(false, e.getMessage(), this.myMerger.getInfo(), this.myMerger.getSkipped()));
        }
        finally {
            this.myHandler.finishUpdate();
        }
    }

    public void onCancel() {
        this.onTaskFinished(true);
    }

    public void onSuccess() {
        this.onTaskFinished(false);
    }

    private void onTaskFinished(boolean wasCancelled) {
        TransactionGuard.submitTransaction((Disposable)this.getProject(), () -> {
            try {
                this.afterExecution(wasCancelled);
            }
            finally {
                StoreReloadManager.getInstance().unblockReloadingProjectOnExternalChanges();
            }
        });
    }

    private void accumulate() {
        this.myAccumulatedFiles.accumulateFiles(this.myRecentlyUpdatedFiles, UpdatedFilesReverseSide.DuplicateLevel.DUPLICATE_ERRORS);
    }

    private void afterExecution(boolean wasCanceled) {
        if (!this.myRecentlyUpdatedFiles.isEmpty()) {
            this.myResolveWorker.execute(this.myRecentlyUpdatedFiles);
        }
        boolean haveConflicts = ResolveWorker.haveUnresolvedConflicts(this.myRecentlyUpdatedFiles);
        this.accumulate();
        if (!this.myMerger.hasNext() || haveConflicts || !this.myExceptions.isEmpty() || this.myAccumulatedFiles.containErrors() || wasCanceled) {
            this.initMergeTarget();
            if (this.myAccumulatedFiles.isEmpty() && this.myExceptions.isEmpty() && this.myMergeTarget == null && !wasCanceled) {
                Messages.showMessageDialog((String)SvnBundle.message("action.Subversion.integrate.changes.message.files.up.to.date.text", new Object[0]), (String)this.getTitle(), (Icon)Messages.getInformationIcon());
            } else {
                if (haveConflicts) {
                    this.myExceptions.add(SvnIntegrateChangesTask.createException(true, SvnBundle.message("svn.integrate.changelist.warning.unresolved.conflicts.text", new Object[0])));
                }
                if (wasCanceled) {
                    this.myExceptions.add(SvnIntegrateChangesTask.createException(true, SvnBundle.message("error.integration.was.canceled", new Object[0]), this.myMerger.getSkipped()));
                }
                this.finishActions(wasCanceled);
            }
            this.myMerger.afterProcessing();
        } else {
            this.stepToNextChangeList();
        }
    }

    private void finishActions(boolean wasCanceled) {
        if (!(wasCanceled || ApplicationManager.getApplication().isUnitTestMode() || this.myDryRun || !this.myExceptions.isEmpty() || this.myAccumulatedFiles.containErrors() || this.myAccumulatedFiles.isEmpty() && this.myMergeTarget == null)) {
            if (this.myInfo.isUnderProjectRoot()) {
                this.showLocalCommit();
            } else {
                this.showAlienCommit();
            }
            return;
        }
        Collection<FilePath> files = this.gatherChangedPaths();
        VcsDirtyScopeManager.getInstance((Project)this.getProject()).filePathsDirty(files, null);
        this.prepareAndShowResults();
    }

    private void prepareAndShowResults() {
        if (!this.myAccumulatedFiles.isEmpty()) {
            this.showUpdateTree();
        }
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{this.myExceptions.size()}));
        }
    }

    private void showUpdateTree() {
        RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.getInstance((Project)this.getProject());
        restoreUpdateTree.registerUpdateInformation(this.myAccumulatedFiles.getUpdatedFiles(), ActionInfo.INTEGRATE);
        UpdateInfoTree tree = this.myProjectLevelVcsManager.showUpdateProjectInfo(this.myAccumulatedFiles.getUpdatedFiles(), this.getTitle(), ActionInfo.INTEGRATE, false);
        if (tree != null) {
            ViewUpdateInfoNotification.focusUpdateInfoTree((Project)this.getProject(), (UpdateInfoTree)tree);
        }
    }

    private void stepToNextChangeList() {
        ApplicationManager.getApplication().invokeLater(() -> ProgressManager.getInstance().run((Task)this));
    }

    private void initMergeTarget() {
        Status svnStatus;
        File mergeInfoHolder = this.myMerger.getMergeInfoHolder();
        if (mergeInfoHolder != null && (svnStatus = SvnUtil.getStatus(this.myVcs, mergeInfoHolder)) != null && svnStatus.isProperty(StatusType.STATUS_MODIFIED)) {
            this.myMergeTarget = VcsUtil.getFilePath((File)mergeInfoHolder);
        }
    }

    private void showLocalCommit() {
        Collection<FilePath> files = this.gatherChangedPaths();
        VcsDirtyScopeManager.getInstance((Project)this.getProject()).filePathsDirty(files, null);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.getProject());
        changeListManager.invokeAfterUpdateWithModal(true, this.getTitle(), () -> {
            ArrayList changes = new ArrayList();
            for (FilePath file : files) {
                ContainerUtil.addIfNotNull(changes, (Object)changeListManager.getChange(file));
            }
            CommitChangeListDialog.commitChanges((Project)this.getProject(), changes, null, null, (String)this.myMerger.getComment());
            this.prepareAndShowResults();
        });
    }

    @NotNull
    private Collection<FilePath> gatherChangedPaths() {
        ArrayList<FilePath> result = new ArrayList<FilePath>();
        UpdateFilesHelper.iterateFileGroupFiles((UpdatedFiles)this.myAccumulatedFiles.getUpdatedFiles(), (filePath, groupId) -> result.add(VcsUtil.getFilePath((File)new File(filePath))));
        ContainerUtil.addIfNotNull(result, (Object)this.myMergeTarget);
        return result;
    }

    private void showAlienCommit() {
        AlienDirtyScope dirtyScope = new AlienDirtyScope(this.myVcs);
        if (this.myMergeTarget != null) {
            dirtyScope.addDir(this.myMergeTarget);
        } else {
            UpdateFilesHelper.iterateFileGroupFiles((UpdatedFiles)this.myAccumulatedFiles.getUpdatedFiles(), (filePath, groupId) -> dirtyScope.addFile(VcsUtil.getFilePath((File)new File(filePath))));
        }
        this.showAlienCommit(dirtyScope);
    }

    private void showAlienCommit(final @NotNull AlienDirtyScope dirtyScope) {
        new Task.Backgroundable(this.myVcs.getProject(), SvnBundle.message("action.Subversion.integrate.changes.collecting.changes.to.commit.task.title", new Object[0])){
            private final GatheringChangelistBuilder changesBuilder;
            private final Ref<@Nls String> caughtError;
            {
                super(arg0, arg1);
                this.changesBuilder = new GatheringChangelistBuilder(SvnIntegrateChangesTask.this.myVcs, SvnIntegrateChangesTask.this.myAccumulatedFiles);
                this.caughtError = new Ref();
            }

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                if (!SvnIntegrateChangesTask.this.myVcs.getProject().isDisposed()) {
                    try {
                        new SvnChangeProvider(SvnIntegrateChangesTask.this.myVcs).getChanges(dirtyScope, (ChangelistBuilder)this.changesBuilder, indicator, new FakeGate());
                    }
                    catch (VcsException e) {
                        this.caughtError.set((Object)SvnBundle.message("action.Subversion.integrate.changes.error.unable.to.collect.changes.text", e.getMessage()));
                    }
                }
            }

            public void onSuccess() {
                if (!this.caughtError.isNull()) {
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)SvnIntegrateChangesTask.this.myVcs.getProject(), (String)((String)this.caughtError.get()), (MessageType)MessageType.ERROR);
                } else if (!this.changesBuilder.getChanges().isEmpty()) {
                    AlienCommitWorkflow workflow = new AlienCommitWorkflow(SvnIntegrateChangesTask.this.myVcs, SvnIntegrateChangesTask.this.myMerger.getComment(), this.changesBuilder.getChanges(), SvnIntegrateChangesTask.this.myMerger.getComment());
                    AlienCommitChangeListDialog dialog = new AlienCommitChangeListDialog(workflow);
                    new SingleChangeListCommitWorkflowHandler((SingleChangeListCommitWorkflow)workflow, (SingleChangeListCommitWorkflowUi)dialog).activate();
                }
            }
        }.queue();
    }

    private static class FakeGate
    implements ChangeListManagerGate {
        private FakeGate() {
        }

        @NotNull
        public List<LocalChangeList> getListsCopy() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public LocalChangeList findChangeList(String name) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public LocalChangeList addChangeList(@NotNull String name, String comment) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public LocalChangeList findOrCreateList(@NotNull String name, String comment) {
            throw new UnsupportedOperationException();
        }

        public void editComment(@NotNull String name, String comment) {
            throw new UnsupportedOperationException();
        }

        public void editName(@NotNull String oldName, @NotNull String newName) {
            throw new UnsupportedOperationException();
        }

        public void setListsToDisappear(@NotNull Collection<String> names) {
            throw new UnsupportedOperationException();
        }

        public FileStatus getStatus(@NotNull VirtualFile file) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public FileStatus getStatus(@NotNull FilePath filePath) {
            throw new UnsupportedOperationException();
        }

        public void setDefaultChangeList(@NotNull String list) {
            throw new UnsupportedOperationException();
        }
    }
}

