/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;

public class LookForBranchOriginTask
extends BaseMergeTask {
    private static final Logger LOG = Logger.getInstance(LookForBranchOriginTask.class);
    private final boolean myFromSource;
    @NotNull
    private final Consumer<? super SvnBranchPointsCalculator.WrapperInvertor> myCallback;

    public LookForBranchOriginTask(@NotNull QuickMerge mergeProcess, boolean fromSource, @NotNull Consumer<? super SvnBranchPointsCalculator.WrapperInvertor> callback) {
        super(mergeProcess);
        this.myFromSource = fromSource;
        this.myCallback = callback;
    }

    @Override
    public void run() throws VcsException {
        Url repoUrl = this.myMergeContext.getWcInfo().getRootInfo().getRepositoryUrl();
        Url sourceUrl = this.myFromSource ? this.myMergeContext.getSourceUrl() : this.myMergeContext.getWcInfo().getUrl();
        Url targetUrl = this.myFromSource ? this.myMergeContext.getWcInfo().getUrl() : this.myMergeContext.getSourceUrl();
        SvnBranchPointsCalculator.WrapperInvertor copyPoint = this.myMergeContext.getVcs().getSvnBranchPointsCalculator().calculateCopyPoint(repoUrl, sourceUrl, targetUrl);
        if (copyPoint != null) {
            this.myCallback.consume((Object)copyPoint);
        } else {
            LOG.info("Error: Merge start wasn't found");
            this.myMergeProcess.end(SvnBundle.message("notification.content.merge.start.was.not.found", new Object[0]), true);
        }
    }
}

