/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.ignore.FileIterationListener;

public class IgnoreGroupHelperAction {
    private boolean myAllCanBeIgnored;
    private boolean myAllAreIgnored;
    private FileIterationListener myListener;

    public void update(@NotNull AnActionEvent e) {
        this.myAllAreIgnored = true;
        this.myAllCanBeIgnored = true;
        Project project = e.getProject();
        SvnVcs vcs = project != null ? SvnVcs.getInstance(project) : null;
        Object[] files = this.getSelectedFiles(e);
        boolean enabledAndVisible = project != null && vcs != null && !ArrayUtil.isEmpty((Object[])files) && this.isEnabled(vcs, (VirtualFile[])files);
        e.getPresentation().setEnabledAndVisible(enabledAndVisible);
    }

    private VirtualFile @Nullable [] getSelectedFiles(@NotNull AnActionEvent e) {
        Iterable exactlySelectedFiles;
        if (e.getPlace().equals("ChangesViewPopup") && (exactlySelectedFiles = (Iterable)e.getData(ChangesListView.EXACTLY_SELECTED_FILES_DATA_KEY)) != null) {
            return (VirtualFile[])JBIterable.from((Iterable)exactlySelectedFiles).toList().toArray(VirtualFile[]::new);
        }
        return (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
    }

    protected boolean isEnabled(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files) {
        return ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).checkAllFilesAreUnder((AbstractVcs)vcs, files) && ContainerUtil.and((Object[])files, file -> this.isEnabled(vcs, (VirtualFile)file));
    }

    public void setFileIterationListener(FileIterationListener listener2) {
        this.myListener = listener2;
    }

    private boolean isEnabledImpl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (SvnStatusUtil.isIgnoredInAnySense(vcs.getProject(), file)) {
            this.myAllCanBeIgnored = false;
            return this.myAllAreIgnored;
        }
        if (ChangeListManager.getInstance((Project)vcs.getProject()).isUnversioned(file) && (parent = file.getParent()) != null && SvnStatusUtil.isUnderControl(vcs, parent)) {
            this.myAllAreIgnored = false;
            return this.myAllCanBeIgnored;
        }
        this.myAllCanBeIgnored = false;
        this.myAllAreIgnored = false;
        return false;
    }

    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        boolean result = this.isEnabledImpl(vcs, file);
        if (result) {
            this.myListener.onFileEnabled(file);
        }
        return result;
    }

    public boolean allCanBeIgnored() {
        return this.myAllCanBeIgnored;
    }

    public boolean allAreIgnored() {
        return this.myAllAreIgnored;
    }
}

